<?php
// file.class.php
// ファイル操作関連

// ファイルロック試行回数
define("PUBLOG_FILELOCK_RETRY",3);

// ファイルロック試行ウェイト時間(sec)
define("PUBLOG_FILELOCK_RETRY_WAIT",5);

class PublogFile
{
	function file_lock($fp,$locktype){
		for($lc=0;$lc<PUBLOG_FILELOCK_RETRY&&(!flock($fp,$locktype));$lc++){
			echo "<p>flock(".($locktype).") err wait...</p>\n";
			flush();
			sleep(PUBLOG_FILELOCK_RETRY_WAIT);
		}
	}
	
	function file_lock_ex($fp){
		file_lock($fp,LOCK_EX);
	}
	
	function file_lock_un($fp){
		file_lock($fp,LOCK_UN);
	}
	
	function pfopen($filename,$option){
		$fp=fopen($filename,$option);
		if(!$fp){
			html_out("file open error","file open error[".$filename."]","");
			return $fp;
		}
		file_lock($fp,LOCK_EX);
		return $fp;
	}
	
	function pfclose($fp){
		file_lock($fp,LOCK_UN);
		fclose($fp);
	}
	
	function &file_sanitize($param)
	{
		global $file_enc;
		if (is_array($param))
		{
			$result = array_map('file_sanitize',$param);
		}
		else
		{
			$result = str_replace("\0",'',$param);
			$result=mb_convert_encoding($result,PUBLOG_INTERNAL_ENCODING,$file_enc);
		}
		return $result;
	}
	
	
	function pfgets($handle,$length=1024)
	{
		global $file_enc;
		return mb_convert_encoding(fgets($handle,$length),PUBLOG_INTERNAL_ENCODING,$file_enc);
	}
	
	function pfgetcsv($handle,$length=1024,$delimiter=',',$enclosure='"')
	{
		return file_sanitize(fgetcsv($handle,$length,$delimiter,$enclosure));
	}
	
	function pfwrite($handle,$string)
	{
	//	global $file_enc;
	//	return fwrite($handle,mb_convert_encoding($string,$file_enc,PUBLOG_INTERNAL_ENCODING));
		return fwrite($handle,$string);
	}
	
	function write_file($filename,$data)
	{
		$fp=pfopen($filename,"w");
		pfwrite($fp,$data);
		pfclose($fp);
		chmod($filename,0777);
	}
	
	function add_file($filename,$data)
	{
		$fp=pfopen($filename,"a");
		pfwrite($fp,$data);
		pfclose($fp);
		chmod($filename,0777);
	}
	
	function &load_file($filename){
		// データオープン
		$fp = pfopen($filename, "r");
		if(!$fp) {
			error_exit(" file open error [".$filename."]");
		}
		$data="";
		while(!feof($fp)) {
			$data.= fgets($fp,20000);
		}
		pfclose($fp);
		return $data;
	}
	
	function &load_file_table($filename){
		// データオープン
		$fp = pfopen($filename, "r");
		if(!$fp) {
			echo "なんかヘンだわ[".$filename."]\n";
			return "";
		}
	
		$data=array();
		while(!feof($fp)) {
			$data[]=pfgetcsv($fp,20000,"\t");
		}
		pfclose($fp);
		return $data;
	}
	
	//ディレクトリ丸ごと削除(thanks,jackylee.)
	function deldir($dir)
	{
		// ルートから見て３階層以上の深さのディレクトリのみ
		if(!preg_match('/^[\/][^\/.]+[\/][^\/.]+[\/][^.]+$/',$dir))
		{
			return false;
		}
		$success = false;
	  $handle = opendir($dir);
	  while (false!==($FolderOrFile = readdir($handle)))
	  {
	     if($FolderOrFile != "." && $FolderOrFile != "..") 
	     {  
	       if(is_dir("$dir/$FolderOrFile")) 
	       { deldir("$dir/$FolderOrFile"); }  // recursive
	       else
	       { unlink("$dir/$FolderOrFile"); }
	     }  
	  }
	  closedir($handle);
	  if(rmdir($dir))
	  { $success = true; }
	  return $success;  
	} 
	
	// 指定したディレクトリの指定した正規表現と一致するファイル名のファイルを削除
	function &rm_ereg_files($dirname,$pattern){
		if(""==$dirname){
			print("err dirname");
			exit;
		}
		if(""==$pattern){
			print("err pattern");
			exit;
		}
		$d = dir($dirname);
		$d->rewind();
		$deleted_filename_list=array();
		while($file = $d->read()){
			if("."==$file){ continue; }
			if(".."==$file){ continue; }
			if(ereg($pattern,$file)){
				unlink($dirname.$file);
				$deleted_filename_list[]=$file;
			}
		}
		$d->close();
		return $deleted_filename_list;
	}

}
?>
