<?php
/*
 * $Id: file.func.php,v 1.10 2005/03/30 10:19:38 fukami Exp $
 * ファイル操作関連
 */

// ファイルロック試行回数
define("PUBLOG_FILELOCK_RETRY",3);

// ファイルロック試行ウェイト時間(sec)
define("PUBLOG_FILELOCK_RETRY_WAIT",5);


function file_lock($fp,$locktype){
	for($lc=0;$lc<PUBLOG_FILELOCK_RETRY&&(!flock($fp,$locktype));$lc++){
		echo "<p>flock(".($locktype).") err wait...</p>\n";
		flush();
		sleep(PUBLOG_FILELOCK_RETRY_WAIT);
	}
}

function file_lock_ex($fp){
	file_lock($fp,LOCK_EX);
}

function file_lock_un($fp){
	file_lock($fp,LOCK_UN);
}

function pfopen($filename,$option){
	$fp=fopen($filename,$option);
	if(!$fp){
		html_out("file open error","file open error[".$filename."]","");
		return $fp;
	}
	file_lock($fp,LOCK_EX);
	return $fp;
}

function pfclose($fp){
	file_lock($fp,LOCK_UN);
	fclose($fp);
}

function &file_sanitize($param)
{
//	global $file_enc;
	if (is_array($param))
	{
		$result = array_map('file_sanitize',$param);
	}
	else
	{
		$result = str_replace("\0",'',$param);
//		$result=mb_convert_encoding($result,PUBLOG_INTERNAL_ENCODING,$file_enc);
	}
	return $result;
}


function pfgets($handle,$length=1024)
{
//	global $file_enc;
//	return mb_convert_encoding(fgets($handle,$length),PUBLOG_INTERNAL_ENCODING,$file_enc);
	return fgets($handle,$length);
}

function pfgetcsv($handle,$length=1024,$delimiter=',',$enclosure='"')
{
	return file_sanitize(fgetcsv($handle,$length,$delimiter,$enclosure));
}

function pfwrite($handle,$string)
{
//	global $file_enc;
//	return fwrite($handle,mb_convert_encoding($string,$file_enc,PUBLOG_INTERNAL_ENCODING));
	return fwrite($handle,$string);
}

function write_file($filename,$data)
{
	$fp=pfopen($filename,"w");
	pfwrite($fp,$data);
	pfclose($fp);
//	if(!chmod($filename,0707))
//	{
//		echo "publog warning: ".$filename." write_file() chmod error";
//	}
}

function add_file($filename,$data)
{
	$fp=pfopen($filename,"a");
	pfwrite($fp,$data);
	pfclose($fp);
	return;
/*	if(!chmod($filename,0707))
	{
		echo "publog warning: ".$filename." add_file() chmod error";
	}
*/
}

function &load_file($filename){
	// データオープン
	$fp = pfopen($filename, "r");
	if(!$fp) {
		error_exit(" file open error [".$filename."]");
	}
	$data="";
	while(!feof($fp)) {
		$data.= fgets($fp,20000);
	}
	pfclose($fp);
	return $data;
}

function &load_file_table($filename){
	// データオープン
	$fp = pfopen($filename, "r");
	if(!$fp) {
		echo "なんかヘンだわ[".$filename."]\n";
		return "";
	}

	$data=array();
	while(!feof($fp)) {
		$arr=pfgetcsv($fp,20000,"\t");
		if(!is_array($arr)) continue;
		$data[]=$arr;
	}
	pfclose($fp);
	return $data;
}

function save_file_table($filename,$data,$sep="\t",$end="\n")
{
	$sdata=null;
	foreach($data as $line)
	{
		$ctmax = count($line);
		$ct = 1;
		foreach($line as $key => $val)
		{
			if($ct++ >= $ctmax)
			{
				$sdata.=$val.$end;
			}else{
				$sdata.=$val.$sep;
			}
		}
	}
	write_file($filename,$sdata);
}

//ディレクトリ丸ごと削除(thanks,jackylee.)
function deldir($dir)
{
	if(!file_exists($dir))
	{
		return false;
	}
	
	//OSに応じてパターンを切り分け
	if ( OS_TYPE == OS_TYPE_WINDOWS ) 
	{
	//windows
		$ptn = '/^[a-zA-Z]:[\/][^\/.]+[\/][^\/.]+[\/][^.]+$/';
	} else {
	//others
		$ptn = '/^[\/][^\/.]+[\/][^\/.]+[\/][^.]+$/';
	}

	// ルートから見て３階層以上の深さのディレクトリのみ
	if(!preg_match($ptn,$dir))
	{
		echo "{$ptn}浅すぎるから消さない\n";
		return false;
	}
	
	
	$success = false;
  $handle = opendir($dir);
  while (false!==($FolderOrFile = readdir($handle)))
  {
     if($FolderOrFile != "." && $FolderOrFile != "..") 
     {  
       if(is_dir("$dir/$FolderOrFile")) 
       { deldir("$dir/$FolderOrFile"); }  // recursive
       else
       { unlink("$dir/$FolderOrFile"); }
     }  
  }
  closedir($handle);
  if(rmdir($dir))
  { $success = true; }
  return $success;  
} 

// 指定したディレクトリの指定した正規表現と一致するファイル名のファイルを削除
function &rm_ereg_files($dirname,$pattern){
	if(""==$dirname){
		print("err dirname");
		exit;
	}
	if(""==$pattern){
		print("err pattern");
		exit;
	}
	$d = dir($dirname);
	$d->rewind();
	$deleted_filename_list=array();
	while($file = $d->read()){
		if("."==$file){ continue; }
		if(".."==$file){ continue; }
		if(ereg($pattern,$file)){
			unlink($dirname.$file);
			$deleted_filename_list[]=$file;
		}
	}
	$d->close();
	return $deleted_filename_list;
}

// 指定したディレクトリの指定した正規表現と一致するファイルのリストを返す
function &get_dir_list($dirname,$pattern){
	if(""==$dirname){
//		print("err dirname");
		return array();
	}
	if(""==$pattern){
//		print("err pattern");
		return array();
	}
	$d = dir($dirname);
	$d->rewind();
	$filename_list=array();
	while($file = $d->read()){
		if("."==$file){ continue; }
		if(".."==$file){ continue; }
		if(preg_match('/'.$pattern.'/',$file)){
			$filename_list[]=$file;
		}
	}
	$d->close();
	return $filename_list;
}


// ディレクトリがあるかどうか確認し、なければディレクトリを作る
// ディレクトリ名の最後に/が必要ですよ
function check_dir($path)
{

	// / で終わっていない場合は不正
	if ( !ereg("/$",$path) )
	{
//		echo "missing \"/\" end of dirname :{$path}\n";
//		return false;
	}

    //Windows時のチェック
	if ( OS_TYPE == OS_TYPE_WINDOWS )
	{

		if ( ereg("^[a-zA-Z]:",$path)  )
		{
			//echo "有効なパス\n";
		} else {
			echo "不正なWindowsパスですよ {$path}\n";
			return false;
		}
	
	} 


	preg_match("/^(([-_.!~*'()a-zA-Z0-9;?:@&=+$,%#]*\/)*)([-_.!~*'()a-zA-Z0-9;?:@&=+$,%#]*)$/i",$path,$matches);
//print_r($matches);
	$dirname = $matches[1];
	if(is_writable($dirname))
	{
		return true;
	}
	
	// ディレクトリ作成を試みる
	$dirs = preg_split('/\//', $dirname, 100, PREG_SPLIT_NO_EMPTY);
	
	//Windowsの場合は冒頭のノードは作成を試行しない
	if ( OS_TYPE == OS_TYPE_WINDOWS )
	{
		$dirname_stock = array_shift($dirs);
	} else {
		$dirname_stock = null;
	}
	
	foreach($dirs as $dir)
	{
//print("[".$dir."]");
		$dirname_stock .= '/'.$dir;
		if(!file_exists($dirname_stock)){
			if(!mkdir($dirname_stock,0707))
			{
				return false;
			}
			chmod($dirname_stock,0707);
		}
	}
	if(is_writable($dirname))
	{
		return true;
	}
	return false;
}

	// ディレクトリまるごとコピー(ディレクトリは無視)
	function dir_copy_file($src_dirname,$dest_dirname)
	{
		if(!is_dir($src_dirname)){
			return false;
		}
		if(!is_dir($dest_dirname)){
			return false;
		}
		if(!is_writable($dest_dirname)){
			return false;
		}
		$d = dir($src_dirname);
		$d->rewind();
		while($file = $d->read()){
			if("."==$file){ continue; }
			if(".."==$file){ continue; }
			if(is_file($src_dirname.'/'.$file)){
				if(!is_readable($src_dirname.'/'.$file)) continue;
				copy($src_dirname.'/'.$file,$dest_dirname.'/'.$file);
				chmod($dest_dirname.'/'.$file,0707);
			}
		}
		$d->close();
		return true;
	}

// リモートホストのファイルの存在チェック
function remote_file_exists ($url) 
{ 
   $head = ""; 
   $url_p = parse_url ($url); 

   if (isset ($url_p["host"])) 
   { $host = $url_p["host"]; } 
   else 
   { return false; } 
    
   if (isset ($url_p["path"])) 
   { $path = $url_p["path"]; } 
   else 
   { $path = ""; } 
    
   $fp = fsockopen ($host, 80, $errno, $errstr, 1); 
   if (!$fp) 
   { return false; } 
   else 
   { 
       $parse = parse_url($url); 
       $host = $parse['host']; 

       fputs($fp, "HEAD ".$url." HTTP/1.1\r\n"); 
       fputs($fp, "HOST: ".$host."\r\n"); 
       fputs($fp, "Connection: close\r\n\r\n"); 
       $headers = ""; 
       $headers .= fgets ($fp, 2048); 
   } 
   fclose ($fp); 
   $arr_headers = explode("\n", $headers); 
   $return = false; 
   if (isset ($arr_headers[0])) 
   { $return = strpos($arr_headers[0], "404") === false; } 
   return $return; 
}
?>
