<?php
// $Id: page.func.php,v 1.2 2004/08/04 05:27:46 fukami Exp $
//プロジェクトレベルのページ生成関連

// スレッドテンプレートデータ(.ttmp)の読み込み
function load_threadtemplate_file($filename){
	$fp = pfopen($filename, "r");
	if(!$fp) {
		echo "err load ".$filename."\n";
		exit;
	}
//	$bodydata=array();
	$bodytext="";
	$headerdata=array();
	$headsw=true;
	$firstline=true;
	while(!feof($fp)) {
		$line = fgets($fp,50000);
		$line=trim($line);
		if($firstline){
			if(ereg("^MFBBS-THREAD-TEMPLATE-DATA",$line,$regs)){
				$firstline=false;
			}else{
				echo "file format err(bbs)\n";
				exit;
			}
		}
		if($headsw){
			if($line==""){
				$headsw=false;
				continue;
			}
			$arr=split("\t",$line);
			$headerdata[$arr[0]]=$arr[1];
			continue;
		}
		if($line==""){
			continue;
		}
//		$arr=array();
//		$arr=split("\t",$line);
//		$bodydata[]=$arr;
		$bodytext.=$line."\n";
	}
	pfclose($fp);
	
	$retdata=array();
	$retdata["header"]=$headerdata;
//	$retdata["body"]=$bodydata;
	$retdata["bodytext"]=$bodytext;
	return $retdata;
}

////////////////////////////////////////
// 静的ページテンプレートファイルをHTMLに
function prj_ptmp_to_html($prjcd){
	// ページテンプレートからHTML生成
	$ret_prj=prj_get_data($prjcd);	// プロジェクトデータ取得
	cnv_prj_template_file_to_html($prjcd,$ret_prj[1][1],$ret_prj[1][2],$ret_prj[1][7]);
}
// プロジェクトディレクトリ内の静的ページテンプレートファイルを総て変換してHTML出力
function cnv_prj_template_file_to_html($prjcd,$prjname="",$setsumei="",$homeurl=""){
	// プロジェクトディレクトリのファイル一覧を取得
	$filelist=prj_get_filelist($prjcd,"designthema/");
	reset($filelist);
	// テンプレートファイルごとのループ
	while(list($key,$val) = each($filelist)){
		if(!ereg("(.+)[.]ptmp$",$val,$regs)){
			continue;
		}
		$filename_body=$regs[1];
		$data=load_file(APATH_HOME_DIR.$prjcd."/designthema/".$val);
		$data=ereg_replace("<!title>",$prjname,$data);
		$data=ereg_replace("<!description>",$setsumei,$data);
		$data=ereg_replace("<!prjcd>",$prjcd,$data);
		$data=ereg_replace("<!prj-dir>",HTTP_HOME_DIR.$prjcd."/",$data);
		// カレンダーインクルード
		for($i=0;$i<100;$i++){	// 100回まで
			// <!Include=threadid:[yyyymm/now]>
			if(eregi("<!calendar=([0-9a-zA-Z-]+):([0-9now/]+)>",$data,$regs)){
				if(eregi("^now$",$regs[2],$param_month)){
					// カレンダーデータ
					$cal_data=gen_blog_calendar($prjcd,$homeurl,$regs[1],"","");
					$data=ereg_replace("<!calendar=".$regs[1].":".$regs[2].">",$cal_data,$data);
				}else if(eregi("([0-9][0-9][0-9][0-9])[/]*([0-9][0-9])",$regs[2],$param_month)){
					// カレンダーデータ
					$cal_data=gen_blog_calendar($prjcd,$homeurl,$regs[1],$param_month[1],$param_month[2]);
					$data=eregi_replace("<!calendar=".$regs[1].":".$regs[2].">",$cal_data,$data);
				}else{
					// パラメーターエラー
					$data=eregi_replace("<!calendar=".$regs[1].":".$regs[2].">","<!--- mfbbs-param-error --->",$data);
				}
			}else{
				break;
			}
		}
		// スレッドインクルード
		for($i=0;$i<100;$i++){	// 100回まで
			// <!Include=threadid:templateid>
			if(eregi("<!Include=([0-9a-zA-Z]+):([0-9a-zA-Z-]+)>",$data,$regs)){
				$include_file=APATH_DATA_DIR.$prjcd."/include/".$regs[1]."-".$regs[2].".tinc";
				if(!file_exists($include_file)){
					$data=eregi_replace("<!Include=".$regs[1].":".$regs[2].">","",$data);
					continue;
				}
				$include_file_data=load_file($include_file);	// インクルードファイル読み込み
				$data=eregi_replace("<!Include=".$regs[1].":".$regs[2].">",$include_file_data,$data);
			}else{
				break;
			}
		}
		write_file(APATH_HOME_DIR.$prjcd."/".$filename_body.".html",$data);
	}
}


// シーケンスナンバーで指定したページだけ書き出し
function gen_one_archive_page_seq($prjcd,$threadid,$seq){
	$obj = new Blog();
	$dataset=&$obj->load_file($prjcd,$threadid);
	$headerdata=$dataset["header"];
	$bodydata=$dataset["body"];
	// archivesディレクトリの存在チェック
	if(!file_exists(APATH_HOME_DIR.$prjcd."/archives")){
		mkdir(APATH_HOME_DIR.$prjcd."/archives",0707);
		chmod(APATH_HOME_DIR.$prjcd."/archives",0707);
	}
	$ret_prj=prj_get_data($prjcd);	// プロジェクトデータ取得
	$prjname=$ret_prj[1][1];
	$setsumei=$ret_prj[1][2];
	$homeurl=$ret_prj[1][7];
	
	reset($bodydata);
	$template_id="page";
	// 動的ページテンプレートを読み込み
	$t_dataset=array();
	$template_data=load_file(APATH_HOME_DIR.$prjcd."/designthema/".$template_id.".dptmp");
	$t_dataset[$template_id."-template-data"]=$template_data;
	// 動的スレッドテンプレートを読み込み
	if(file_exists(APATH_HOME_DIR.$prjcd."/designthema/".$template_id.".dttmp")){
		$thread_template_data=load_threadtemplate_file(APATH_HOME_DIR.$prjcd."/designthema/".$template_id.".dttmp");
	}else{
		return false;	// スレッドテンプレート読み込みエラー
	}
	$t_dataset[$template_id."-thread-template-data"]=$thread_template_data;

		$t_dataset["page"][0]=$bodydata[($seq-1)];
		$pagedata=prj_dynamic_ptmp_to_html($prjcd,$threadid,$template_id,$t_dataset,$prjname,$setsumei,$homeurl);
		// シーケンスNO でファイル生成
		write_file(APATH_HOME_DIR.$prjcd."/archives/".$threadid.((string)$seq).".html",$pagedata);
//		write_file(APATH_HOME_DIR.$prjcd."/archives/".$threadid.((string)$val[0]).".html",$pagedata);

	$rev_bodydata=array_reverse($bodydata);
	reset($rev_bodydata);
	gen_all_blog_index($prjcd,$threadid,$rev_bodydata);
}



// １日分原稿書き出し
function gen_archive_page_bydate($prjcd,$threadid,$outdate){
	$obj = new Blog();
	$dataset=&$obj->load_file($prjcd,$threadid);
	$headerdata=$dataset["header"];
	$bodydata=$dataset["body"];
	// archivesディレクトリの存在チェック
	if(!file_exists(APATH_HOME_DIR.$prjcd."/archives")){
		mkdir(APATH_HOME_DIR.$prjcd."/archives",0707);
		chmod(APATH_HOME_DIR.$prjcd."/archives",0707);
	}
	// 日ごとの切り分け
	reset($bodydata);
	$datedata=array();
	print("outdate[".$outdate."]");
	while(list($key,$val) = each($bodydata)){
		flush();
		if(substr($val[19],0,8)==$outdate){
			$datedata[]=$val;
		}
	}
	print("[".(string)count($datedata)."] page ");
	flush();
	if(0>=count($datedata)){
		return;
	}
	$ret_prj=prj_get_data($prjcd);	// プロジェクトデータ取得
	$prjname=$ret_prj[1][1];
	$setsumei=$ret_prj[1][2];
	$homeurl=$ret_prj[1][7];
	// 日ごとの書き出し
	$template_id="page";
	// 動的ページテンプレートを読み込み
	$t_dataset=array();
	$template_data=load_file(APATH_HOME_DIR.$prjcd."/designthema/".$template_id.".dptmp");
	$t_dataset[$template_id."-template-data"]=$template_data;
	// 動的スレッドテンプレートを読み込み
	if(file_exists(APATH_HOME_DIR.$prjcd."/designthema/".$template_id.".dttmp")){
		$thread_template_data=load_threadtemplate_file(APATH_HOME_DIR.$prjcd."/designthema/".$template_id.".dttmp");
	}else{
		return false;	// スレッドテンプレート読み込みエラー
	}
	$t_dataset[$template_id."-thread-template-data"]=$thread_template_data;

		$t_dataset["page"]=$datedata;
		$pagedata=prj_dynamic_ptmp_to_html($prjcd,$threadid,$template_id,$t_dataset,$prjname,$setsumei,$homeurl);
		// 日付でファイル生成
		write_file(APATH_HOME_DIR.$prjcd."/archives/".$threadid.((string)$outdate).".html",$pagedata);
}


function gen_all_archive_page_seq($prjcd,$threadid){
	$obj = new Blog();
	$dataset=&$obj->load_file($prjcd,$threadid);
	$headerdata=$dataset["header"];
	$bodydata=$dataset["body"];
	// archivesディレクトリの存在チェック
	if(!file_exists(APATH_HOME_DIR.$prjcd."/archives")){
		mkdir(APATH_HOME_DIR.$prjcd."/archives",0707);
		chmod(APATH_HOME_DIR.$prjcd."/archives",0707);
	}
	$ret_prj=prj_get_data($prjcd);	// プロジェクトデータ取得
	$prjname=$ret_prj[1][1];
	$setsumei=$ret_prj[1][2];
	$homeurl=$ret_prj[1][7];
	
	reset($bodydata);
	$template_id="page";
	// 動的ページテンプレートを読み込み
	$t_dataset=array();
	$template_data=load_file(APATH_HOME_DIR.$prjcd."/designthema/".$template_id.".dptmp");
	$t_dataset[$template_id."-template-data"]=$template_data;
	// 動的スレッドテンプレートを読み込み
	if(file_exists(APATH_HOME_DIR.$prjcd."/designthema/".$template_id.".dttmp")){
		$thread_template_data=load_threadtemplate_file(APATH_HOME_DIR.$prjcd."/designthema/".$template_id.".dttmp");
	}else{
		return false;	// スレッドテンプレート読み込みエラー
	}
	$t_dataset[$template_id."-thread-template-data"]=$thread_template_data;
	while(list($key,$val) = each($bodydata)){
		$t_dataset["page"][0]=$val;
		$pagedata=prj_dynamic_ptmp_to_html($prjcd,$threadid,$template_id,$t_dataset,$prjname,$setsumei,$homeurl);
		// シーケンスNO でファイル生成
		write_file(APATH_HOME_DIR.$prjcd."/archives/".$threadid.((string)$val[0]).".html",$pagedata);
	}
	
	$rev_bodydata=array_reverse($bodydata);
	reset($rev_bodydata);
	gen_all_blog_index($prjcd,$threadid,$rev_bodydata);
}

// 日ごとのアーカイブ書き出し
function gen_all_archive_page_day($prjcd,$threadid){
	$obj = new Blog();
	$dataset=&$obj->load_file($prjcd,$threadid);
	$headerdata=$dataset["header"];
	$bodydata=$dataset["body"];
	// archivesディレクトリの存在チェック
	if(!file_exists(APATH_HOME_DIR.$prjcd."/archives")){
		mkdir(APATH_HOME_DIR.$prjcd."/archives",0707);
		chmod(APATH_HOME_DIR.$prjcd."/archives",0707);
	}
	// 日ごとの切り分け
	reset($bodydata);
	$sepdata=array();
	while(list($key,$val) = each($bodydata)){
		$sepdata[substr($val[19],0,8)][]=$val;
	}
	$ret_prj=prj_get_data($prjcd);	// プロジェクトデータ取得
	$prjname=$ret_prj[1][1];
	$setsumei=$ret_prj[1][2];
	$homeurl=$ret_prj[1][7];
	// 日ごとの書き出し
	reset($sepdata);
	$template_id="page";
	// 動的ページテンプレートを読み込み
	$t_dataset=array();
	$template_data=load_file(APATH_HOME_DIR.$prjcd."/designthema/".$template_id.".dptmp");
	$t_dataset[$template_id."-template-data"]=$template_data;
	// 動的スレッドテンプレートを読み込み
	if(file_exists(APATH_HOME_DIR.$prjcd."/designthema/".$template_id.".dttmp")){
		$thread_template_data=load_threadtemplate_file(APATH_HOME_DIR.$prjcd."/designthema/".$template_id.".dttmp");
	}else{
		return false;	// スレッドテンプレート読み込みエラー
	}
	$t_dataset[$template_id."-thread-template-data"]=$thread_template_data;
	while(list($key,$val) = each($sepdata)){
		$t_dataset["page"]=$val;
		$pagedata=prj_dynamic_ptmp_to_html($prjcd,$threadid,$template_id,$t_dataset,$prjname,$setsumei,$homeurl);
		// シーケンスNO でファイル生成
		write_file(APATH_HOME_DIR.$prjcd."/archives/".$threadid.((string)$key).".html",$pagedata);
	}
}

// プロジェクトディレクトリ内の動的ページテンプレートファイルを変換して返す
function prj_dynamic_ptmp_to_html($prjcd,$threadid,$page_template_id,$t_dataset,$prjname,$setsumei,$homeurl){
	$data=$t_dataset[$page_template_id."-template-data"];
	$data=ereg_replace("<!title>",$prjname,$data);
	$data=ereg_replace("<!description>",$setsumei,$data);
	$data=ereg_replace("<!prjcd>",$prjcd,$data);
	$data=ereg_replace("<!default-css>",HTTP_HOME_DIR.$prjcd."/default.css",$data);
	$data=ereg_replace("<!prj-dir>",HTTP_HOME_DIR.$prjcd."/",$data);

	//<!date>
	$out_date=substr($t_dataset[page][0][19],2,2);
	$out_date.="/";
	$out_date.=substr($t_dataset[page][0][19],4,2);
	$out_date.="/";
	$out_date.=substr($t_dataset[page][0][19],6,2);
	$data=ereg_replace("<!date>",$out_date,$data);

	// カレンダーインクルード
	for($i=0;$i<100;$i++){	// 100回まで
		// <!Include=threadid:[yyyymm/now]>
		if(eregi("<!calendar=([0-9a-zA-Z-]+):([0-9now/]+)>",$data,$regs)){
			if(eregi("^now$",$regs[2],$param_month)){
				// カレンダーデータ
				$cal_data=gen_blog_calendar($prjcd,$homeurl,$regs[1],"","");
				$data=ereg_replace("<!calendar=".$regs[1].":".$regs[2].">",$cal_data,$data);
			}else if(eregi("([0-9][0-9][0-9][0-9])[/]*([0-9][0-9])",$regs[2],$param_month)){
				// カレンダーデータ
				$cal_data=gen_blog_calendar($prjcd,$homeurl,$regs[1],$param_month[1],$param_month[2]);
				$data=ereg_replace("<!calendar=".$regs[1].":".$regs[2].">",$cal_data,$data);
			}else{
				// パラメーターエラー
				$data=ereg_replace("<!calendar=".$regs[1].":".$regs[2].">","<!--- mfbbs-param-error --->",$data);
			}
		}else{
			break;
		}
	}
	// 静的スレッドインクルード
	for($i=0;$i<100;$i++){	// 100回まで
		// <!Include=threadid:templateid>
		if(eregi("<!Include=([0-9a-zA-Z]+):([0-9a-zA-Z-]+)>",$data,$regs)){
			$include_file_data=load_file(APATH_DATA_DIR.$prjcd."/include/".$regs[1]."-".$regs[2].".tinc");				// インクルードファイル読み込み
			$data=eregi_replace("<!Include=".$regs[1].":".$regs[2].">",$include_file_data,$data);			}else{
			break;
		}
	}
	// 動的スレッドインクルード
//	for($i=0;$i<100;$i++){	// 100回まで
		// <!dynamic-include=threadid:templateid>
//		if(eregi("<!dynamic-include=([0-9a-zA-Z-]+)>",$data,$regs)){
		if(eregi("<!dynamic-include=".$page_template_id.">",$data,$regs)){
//			if(is_array($t_dataset[$regs[1]])){	// 該当するthread_idのデータが存在するかどうか
				// インクルードファイル読み込み
				$include_file_data=gen_dynamic_include_conv_thread_data($prjcd,$threadid,$page_template_id,$t_dataset);
//				$data=eregi_replace("<!dynamic-include=".$regs[1].">",$include_file_data,$data);
				$data=eregi_replace("<!dynamic-include=".$page_template_id.">",$include_file_data,$data);
//			}else{
				// そのデータは存在しなかったのであった…
//				$data=eregi_replace("<!dynamic-nclude=".$regs[1].">","<!--- mfbbs_error_thread_data_empty(".$regs[1].") --->",$data);
//				$data=eregi_replace("<!dynamic-nclude=".$page_template_id.">","<!--- mfbbs_error_thread_data_empty(".$regs[1].") --->",$data);
//			}
		}
//		else{
//			break;
//		}
//	}
	return $data;
}

//////////////////////////////////////////////////////////////////////
// 最新ｎ件表示データ作成
// スレッドテンプレートを読み込んで、データを当てはめて書き出し
//
function gen_dynamic_include_conv_thread_data($anid,$hakoid,$dynamic_thread_template_id,$t_dataset){
	$t_data=$t_dataset[$dynamic_thread_template_id];
	$thread_template_data=$t_dataset[$dynamic_thread_template_id."-thread-template-data"];
	$thread_template_header=$thread_template_data["header"];
	$thread_template=$thread_template_data["bodytext"];
	// 動的スレッドテンプレートを読み込み
//	if(file_exists(APATH_HOME_DIR.$anid."/designthema/".$dynamic_thread_template_id.".dttmp")){
//		$thread_template_data=load_threadtemplate_file(APATH_HOME_DIR.$anid."/designthema/".$dynamic_thread_template_id.".dttmp");
//		$thread_template_header=$thread_template_data["header"];
//		$thread_template=$thread_template_data["bodytext"];
//	}else{
//		return "<!--- mfbbs_file_exists_error(".$dynamic_thread_template_filename.") --->";
//	}
	// プロジェクト関連の置き換え
	$thread_template=ereg_replace("<!prj-dir>",HTTP_HOME_DIR.$anid."/",$thread_template);
	// 板URL抽出
	reset($t_data);
	$pagedata="";
	// レス（投稿）ごとのループ
	$seqcounter=1;
//$starttime=microtime();
	while(list($key,$t_body) = each($t_data)){
		if($t_body[6]!="o"){	// state 非公開
			continue;
		}
		$res_data=$thread_template;
		// <!title>
		if(""==$t_body[17]){	// URL
			$res_data=ereg_replace("<!title>",$t_body[15],$res_data);
		}else{
			$res_data=ereg_replace("<!title>",
				"<a href=\"".$t_body[17]."\" target=_blank>".$t_body[15]."</a>",
				$res_data);
		}
		// <!title.org>
		$res_data=ereg_replace("<!title.org>",$t_body[15],$res_data);
		// <!seqno>
		$res_data=ereg_replace("<!seq>",(string)($seqcounter),$res_data);
		// <!resno>
		$res_data=ereg_replace("<!resno>",$t_body[0],$res_data);
		// <!tburl>		2003/08/07
		$tburl=HTTP_SCRIPT_DIR."tb".PUBLOG_PHP_EXTENSION."?id=$anid:$hakoid:$t_body[0]";
		$res_data=ereg_replace("<!trackbackurl>",$tburl,$res_data);
		//<!prjcd>
		$res_data=ereg_replace("<!prjcd>",$anid,$res_data);
		//<!thread-id>
		$res_data=ereg_replace("<!thread-id>",$hakoid,$res_data);
		//<!referurl>
		$referurl=HTTP_HOME_DIR.$anid."/archives/".$hakoid.$t_body[0].".html";
		$res_data=ereg_replace("<!referurl>",$referurl,$res_data);
		//<!refertitle>
		$res_data=ereg_replace("<!refertitle>",rawurlencode($t_body[15]),$res_data);
		//<!back>
		$res_data=ereg_replace("<!back>",HTTP_HOME_DIR.$anid."/",$res_data);
		// <!comment-form>
		$res_data=ereg_replace("<!comment-form>",HTTP_SCRIPT_DIR."v".PUBLOG_PHP_EXTENSION."?v=comment-form&prjcd=$anid&threadid=$hakoid&refer=".HTTP_HOME_DIR.$anid."/archives/".$hakoid.$t_body[0].".html&refertitle=".rawurlencode($t_body[15])."&back=".HTTP_HOME_DIR.$anid."/",$res_data);
		// <!categorycd>
		$res_data=ereg_replace("<!categorycd>",$t_body[9],$res_data);
		// <!categoryname>
		if($t_body[10]!=""){	// カテゴリ名
			if(""==$caturl){	// カテゴリURL
				$res_data=ereg_replace("<!categoryname>",$t_body[10],$res_data);
			}else{
				$res_data=ereg_replace("<!categoryname>",
					"<a href=\"".$caturl."\">".$t_body[10]."</a>",
					$res_data);
			}
		}
		// <!date>
		$out_date=substr($t_body[19],2,2);
		$out_date.="/";
		$out_date.=substr($t_body[19],4,2);
		$out_date.="/";
		$out_date.=substr($t_body[19],6,2);
		$res_data=ereg_replace("<!date>",$out_date,$res_data);
		// <!time>
		$out_time=substr($t_body[19],8,2);
		$out_time.=":";
		$out_time.=substr($t_body[19],10,2);
		$res_data=ereg_replace("<!time>",$out_time,$res_data);
		// <!datetime>
		$res_data=ereg_replace("<!datetime>",$out_date." ".$out_time,$res_data);
		// <!writer>
		if($t_body[12]==""){
			$res_data=ereg_replace("<!writer>",$t_body[11],$res_data);
		}else{
			$res_data=ereg_replace("<!writer>",$t_body[11]."◆".$t_body[12],$res_data);
		}
		// レス本文の処理
		if(("h"==$t_body[18])||("w"==$t_body[18])){
			$t_body[16]=ereg_replace(PUBLOG_BETA_BR,"\n",$t_body[16]);
		}
		if("w"==$t_body[18]){
			if(WIKI_FORMAT_ENABLE){
				$t_body[16]=convert_html($t_body[16]);	// wiki フォーマット変換
			}
		}else if("x"==$t_body[18]){
			$t_body[16]=url2href($t_body[16]);	// コメント(URLをリンクに変換)
		}
		// <!description>
		// <!text>
		// <!story>
		$res_data=ereg_replace("<!description>",$t_body[16],$res_data);
		$res_data=ereg_replace("<!text>",$t_body[16],$res_data);
		$res_data=ereg_replace("<!story>",$t_body[16],$res_data);
		// <!url>
		$res_data=ereg_replace("<!url>",$t_body[17],$res_data);
		
		// RDF
		$rdf="";
		$rdf.="<!--\n";
		$rdf.="<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n";
		$rdf.="         xmlns:trackback=\"http://madskills.com/public/xml/rss/module/trackback/\"\n";
		$rdf.="         xmlns:dc=\"http://purl.org/dc/elements/1.1/\">\n";
		$rdf.="<rdf:Description\n";
		$rdf.="    rdf:about=\"".$referurl."\"\n";
		$rdf.="    trackback:ping=\"".$tburl."\"\n";
		$rdf.="    dc:title=\"".$t_body[15]."\"\n";
		$rdf.="    dc:identifier=\"".$referurl."\"\n";
		$rdf.="    dc:subject=\"\"\n";
		//    dc:description
		if($t_body[12]==""){
			$rdf.="    dc:creator=\"".$t_body[11]."\"\n";
		}else{
			$rdf.="    dc:creator=\"".$t_body[11]."◆".$t_body[12]."\"\n";
		}
		$dcdatetime=substr($t_body[19],0,4);
		$dcdatetime.="-";
		$dcdatetime.=substr($t_body[19],4,2);
		$dcdatetime.="-";
		$dcdatetime.=substr($t_body[19],6,2);
		$dcdatetime.="T";
		$dcdatetime.=substr($t_body[19],8,2);
		$dcdatetime.=":";
		$dcdatetime.=substr($t_body[19],10,2);
		$dcdatetime.=":";
		$dcdatetime.=substr($t_body[19],12,2);
		$dcdatetime.="+09:00";

		$rdf.="    dc:date=\"".$dcdatetime."\" />\n";
		$rdf.="</rdf:RDF>\n";
		$rdf.="-->\n";

		$res_data.="\n";
		$res_data.=$rdf;
		$res_data.="\n";
		

		$pagedata.=$res_data;
		$seqcounter++;
	}
	return $pagedata;
}



// 全記事バックナンバー出力
function gen_all_blog_index($prjcd,$threadid,$bodydata){
	$allindex="";
	while(list($key,$val) = each($bodydata)){
		if($val[6]!="o"){
			continue;
		}
		// 全ログインデックス
		$allindex.="<li>";
		$allindex.=substr($val[19],0,4);
		$allindex.="/";
		$allindex.=substr($val[19],4,2);
		$allindex.="/";
		$allindex.=substr($val[19],6,2);
		$allindex.=" ";
		$allindex.=substr($val[19],8,2);
		$allindex.=":";
		$allindex.=substr($val[19],10,2);
		$allindex.=" ";
		
		$allindex.="<a href=\"".$threadid.((string)$val[0]).".html"."\" target=_blank>";
		$allindex.=$val[15];
		$allindex.="</a>";
		$allindex.=" (";
		if($val[12]==""){
			$allindex.=$val[11];
		}else{
			$allindex.=$val[11]."◆".$val[12];
		}
		$allindex.=")";
		$allindex.="</li>";
	}
	
	$index="<html><head><title>";
	$index.="全記事バックナンバー";
	$index.="</title>";
	$index.="<link rel=\"stylesheet\" type=\"text/css\" href=\"../designthema/default.css\"></head>";
	$index.="<body>";
	$index.="全記事バックナンバー<br />\n";
	$index.="<a href=\"../\">戻る</a>";
	$index.="<hr />";
	$index.="<ul>";
	$index.=$allindex;
	$index.="</ul>";
	$index.="<hr />";
	$index.="<a href=\"../\">戻る</a>";
	$index.="</body>";
	$index.="</html>";
	// 全記事バックナンバーリスト
	write_file(APATH_HOME_DIR.$prjcd."/archives/".$threadid.".html",$index);
}


?>
