<?php
// $Id: publog.func.php,v 1.3 2005/01/31 20:59:30 fukami Exp $
// publog.func.php
// PUBLOG に特化した小物関数達


function psanitize($param,$to_enc=PUBLOG_INTERNAL_ENCODING,$from_enc=PUBLOG_HTTP_INPUT_ENCODING)
{
	if (is_array($param))
	{
		$result = array_map('psanitize',$param);
	}
	else
	{
		$result = str_replace("\0",'',$param);
		if (get_magic_quotes_gpc())
		{
			$result = stripslashes($result);
		}
		$result=mb_convert_encoding($result,$to_enc,$from_enc);
	}
	return $result;
}


// メッセージファイル読み込み
function load_message($dir,$name)
{
	$filename=$dir.$name.".".LANG.".".DIALECT.".lng";
	if (!file_exists($filename)||!is_readable($filename))
	{
		$filename=$dir.$name.".".LANG.".default.lng";
		if (!file_exists($filename)||!is_readable($filename))
		{
			$filename=$dir.$name."."."default.lng";
			if (!file_exists($filename)||!is_readable($filename))
			{
//				error_exit($filename.'(message file) is not found.');
					return array();
			}
		}
	}
	return parse_ini_file($filename,TRUE);
}

function make_id_current () {
    return make_id (get_ip_addr (), time ());
}

function make_id ($ip_addr, $timestamp) {
    global $_SERVER;
	$tane=$_SERVER ['HTTP_USER_AGENT'];

	$key = $ip_addr . date ("Ymd", $timestamp).$tane."omaemona-";
	$md = md5 ($key);
	$md = strrev($md);
	$dm="";
	for($i=0;$i<32;$i+=2){
		$dm .= chr(hexdec(substr($md,$i,2)));
	}
	$b64 = base64_encode($dm);
	$b64 = strrev($b64);
	return substr($b64,-10,10);
}

function sep_name_trip10($name_full){

	if(ereg("(.*)#(.+)",$name_full,$regs)){
		$name = $regs[1];
		$trip = gen_trip10($regs[2]);
	}else{
		$name=$name_full;
		$trip="";
	}
	$list=array();
	$list["name"]=$name;
	$list["trip"]=$trip;

	return $list;
}

// ディレクトリ内のファイルリスト
function prj_dir($dirpath,$dirmark="/"){
	$d = dir($dirpath);
	$flist=array();
	while($file = $d->read()){
		if("."==$file){ continue; }
		if(".."==$file){ continue; }
		if(is_dir($dirpath.$file)){
			$file=$file.$dirmark;
		}
		$flist[]=$file;
	}
	$d->close();
	return $flist;
}

// ドキュメントディレクトリ内のファイルリストを取得
function prj_get_filelist($prjcd,$currentdir){
	$currentdir=ereg_replace("[.]","",trim($currentdir));	// ヘンな文字カット
	return prj_dir(APATH_HOME_DIR."$prjcd/".$currentdir);
}
function prj_filename_check($filename){
	if(ereg("^[a-z0-9][a-z0-9_-]+(\.[a-z0-9]+)*$",$filename,$matches)){
		global $ext;
		if(!empty($matches[1]))
			if(!in_array($matches[1],$ext['edit']))
				return false;
		return true;
	}
	return false;
}
function prj_file_ext_check($ext){
	if(ereg("^[.][a-z0-9]+$",$ext)){
		return true;
	}
	return false;
}

?>
