<?php
// staff.func.php
// スタッフ関連の関数
// 2004/04/26 
// $Id: staff.func.php,v 1.7 2004/10/19 21:50:31 fukami Exp $

//////////////////////////////////////////////////////////
// 権限管理関連
// 0     1    2      3      4
// prjid trip handle e-mail authority[owner/chief/desk/staff] 

// スタッフリストチェックとデータ取得
function stafflist_check($prjcd,$pass,$email){

	$trip=gen_trip_matcha($pass);
	// データオープン
	$fp = pfopen(APATH_STAFF_LIST_FILE, "r");
	if(!$fp) {
		html_out("システム的な問題でログインできません");
		return "";
	}
	$data=array();
	while(!feof($fp)) {
		$data=pfgetcsv($fp,200,"\t");
		if(($data[0]==$prjcd)&&($data[1]==$trip)&&($data[3]==$email)){
			fclose($fp);
			return $data;
		}
	}
	pfclose($fp);

	return false;
}


// スタッフリストから指定したスタッフのデータ取得
function &stafflist_get_staff_data($prjcd,$trip,$email){
	$stafflist=&load_file_table(APATH_STAFF_LIST_FILE);
	foreach($stafflist as $var)
	{
		if(($var[0]==$prjcd)&&($var[1]==$trip)&&($var[3]==$email))
		{
			return $var;
		}
	}
	return false;
}

// スタッフリストから指定したスタッフのデータ取得(emailのみで)
function &stafflist_get_staff_data_email($prjcd,$email){
	$stafflist=&load_file_table(APATH_STAFF_LIST_FILE);
	foreach($stafflist as $var)
	{
		if(($var[0]==$prjcd)&&($var[3]==$email))
		{
			return $var;
		}
	}
	return false;
}

// スタッフリストからスタッフのデータ取得(プロジェクトコードと権限で)
function &stafflist_get_staff_data_authority($prjcd,$authority){
	$stafflist=&load_file_table(APATH_STAFF_LIST_FILE);
	$list=array();
	foreach($stafflist as $var)
	{
		if(($var[0]==$prjcd)&&($var[4]==$authority))
		{
			$list[]=$var;
		}
	}
	return $list;
}


// スタッフ一覧リスト取得
function stafflist_prj_get($prjcd){
	$stafflist=load_file_table(APATH_STAFF_LIST_FILE);
	$stafflistcount=count($stafflist);
	$outlist=array();
	for($i=0;$i<$stafflistcount;$i++){
		if($stafflist[$i][0]==$prjcd){
			$outlist[]=$stafflist[$i];
		}
	}
	return $outlist;
}

// スタッフリスト新規追加
function stafflist_add($prjcd,$trip,$handle,$email,$authority){
	$stafflist=array();
	if(file_exists(APATH_STAFF_LIST_FILE)){
		$stafflist=load_file_table(APATH_STAFF_LIST_FILE);
		$stafflistcount=count($stafflist);
		for($j=0;$j<$stafflistcount;$j++){
			if(($stafflist[$j][0]==$prjcd)&&($stafflist[$j][3]==$email)){
				return false;
			}
		}
	}
	$newdata=$prjcd."\t".$trip."\t".$handle."\t".$email."\t".$authority."\n";
	add_file(APATH_STAFF_LIST_FILE,$newdata);

	return true;
}

// スタッフキュー削除
function staffque_delete($prjcd,$trip,$email){
	if(""==$trip){
		print("err");
		exit;
	}
	if(""==$email){
		print("err");
		exit;
	}
	$staffque=load_file_table(HIDDEN_DIR.$prjcd."/staffque.txt");
	$staffqueloopcount=count($staffque);
	$oldtripcheck=false;
	$outdata="";
	$staffquecount=0;
	for($i=0;$i<$staffqueloopcount;$i++){
//		var_dump($staffque);
		if(($staffque[$i][0]==$trip)&&($staffque[$i][2]==$email)){
			$oldtripcheck=true;
			continue;
		}
		if(($staffque[$i][0]=="")&&($staffque[$i][1]=="")&&($staffque[$i][2]=="")){	// 空行スキップ
			continue;
		}
		$outdata.=$staffque[$i][0];
		$outdata.="\t";
		$outdata.=$staffque[$i][1];
		$outdata.="\t";
		$outdata.=$staffque[$i][2];
		$outdata.="\t";
		$outdata.=$staffque[$i][3];
		$outdata.="\n";
		$staffquecount++;
	}

	if(!$oldtripcheck){
		// トリップがみつからない
		return false;
	}

	// スタッフキューが空なのでファイルを削除
	if($staffquecount==0){
		unlink(HIDDEN_DIR.$prjcd."/staffque.txt");
		return true;
	}

	// スタッフキューデータ保存
	$outfilename=HIDDEN_DIR.$prjcd."/staffque.txt";
	$outfp=pfopen($outfilename,"w");
	pfwrite($outfp,$outdata);
	pfclose($outfp);
	chmod($outfilename,0777);

	return true;
}




// スタッフリスト更新
function stafflist_update($prjcd,$oldtrip,$oldemail,$trip,$handle,$email,$authority){

	$stafflist=load_file_table(APATH_STAFF_LIST_FILE);
	$stafflistcount=count($stafflist);
	$oldtripcheck=false;
	for($i=0;$i<$stafflistcount;$i++){
		if(($stafflist[$i][0]==$prjcd)&&($stafflist[$i][1]==$oldtrip)&&($stafflist[$i][3]==$oldemail)){
			$oldtripcheck=true;
			$stafflist[$i][1]=$trip;
			$stafflist[$i][2]=$handle;
			$stafflist[$i][3]=$email;
			$stafflist[$i][4]=$authority;
			break;
		}
	}

	if(!$oldtripcheck){
		return false;
	}

	$outdata="";
	for($i=0;$i<$stafflistcount;$i++){
		$outdata.=$stafflist[$i][0];
		$outdata.="\t";
		$outdata.=$stafflist[$i][1];
		$outdata.="\t";
		$outdata.=$stafflist[$i][2];
		$outdata.="\t";
		$outdata.=$stafflist[$i][3];
		$outdata.="\t";
		$outdata.=$stafflist[$i][4];
		$outdata.="\n";
	}

	copy(APATH_STAFF_LIST_FILE,APATH_STAFF_LIST_FILE.".".date("Ymd"));	// ばっくあっぷ
	chmod(APATH_STAFF_LIST_FILE.".".date("Ymd"),0777);
	$outfp=pfopen(APATH_STAFF_LIST_FILE,"w");
	pfwrite($outfp,$outdata);
	pfclose($outfp);
//	chmod(APATH_STAFF_LIST_FILE,0777);

	return true;
}

// スタッフリスト更新(パスとメアドで,リスト内の全パスを更新)
function stafflist_update_email($oldtrip,$email,$newtrip){

	$stafflist=load_file_table(APATH_STAFF_LIST_FILE);
	$stafflistcount=count($stafflist);
	$oldtripcheck=false;
	for($i=0;$i<$stafflistcount;$i++){
		if(($stafflist[$i][3]==$email)&&($stafflist[$i][1]==$oldtrip)){
			$oldtripcheck=true;
			$stafflist[$i][1]=$newtrip;
//				$stafflist[$i][2]=$handle;
//				$stafflist[$i][3]=$email;
//				$stafflist[$i][4]=$authority;
//				break;
		}
	}

	if(!$oldtripcheck){
		return false;
	}

	// 整形再出力
	$outdata=null;
	for($i=0;$i<$stafflistcount;$i++){
		$outdata.=$stafflist[$i][0];
		$outdata.="\t";
		$outdata.=$stafflist[$i][1];
		$outdata.="\t";
		$outdata.=$stafflist[$i][2];
		$outdata.="\t";
		$outdata.=$stafflist[$i][3];
		$outdata.="\t";
		$outdata.=$stafflist[$i][4];
		$outdata.="\n";
	}

	copy(APATH_STAFF_LIST_FILE,APATH_STAFF_LIST_FILE.".".date("Ymd"));	// ばっくあっぷ
	chmod(APATH_STAFF_LIST_FILE.".".date("Ymd"),0777);
	$outfp=pfopen(APATH_STAFF_LIST_FILE,"w");
	pfwrite($outfp,$outdata);
	pfclose($outfp);
//	chmod(APATH_STAFF_LIST_FILE,0777);

	return true;
}

// スタッフリスト削除
function stafflist_delete($prjcd,$trip,$email){
	$stafflist=load_file_table(APATH_STAFF_LIST_FILE);
	$stafflistcount=count($stafflist);
	$oldtripcheck=false;
	$outdata="";
	for($i=0;$i<$stafflistcount;$i++){
		if(($stafflist[$i][0]==$prjcd)&&($stafflist[$i][1]==$trip)&&($stafflist[$i][3]==$email)){
			$oldtripcheck=true;
			continue;
		}
		$outdata.=$stafflist[$i][0];
		$outdata.="\t";
		$outdata.=$stafflist[$i][1];
		$outdata.="\t";
		$outdata.=$stafflist[$i][2];
		$outdata.="\t";
		$outdata.=$stafflist[$i][3];
		$outdata.="\t";
		$outdata.=$stafflist[$i][4];
		$outdata.="\n";

	}

	if(!$oldtripcheck){
		// トリップがみつからない
		return false;
	}
	

	copy(APATH_STAFF_LIST_FILE,APATH_STAFF_LIST_FILE.".".date("Ymd"));	// ばっくあっぷ
	chmod(APATH_STAFF_LIST_FILE.".".date("Ymd"),0777);
	$outfilename=APATH_STAFF_LIST_FILE;
	$outfp=pfopen($outfilename,"w");
	pfwrite($outfp,$outdata);
	pfclose($outfp);
	chmod($outfilename,0777);

	return true;
}


// スタッフリストからプロジェクトごと削除
function stafflist_prj_delete($prjcd){
	$stafflist=load_file_table(APATH_STAFF_LIST_FILE);
	$stafflistcount=count($stafflist);
	$oldtripcheck=false;
	$outdata="";
	for($i=0;$i<$stafflistcount;$i++){
		if($stafflist[$i][0]=="") continue;
		if($stafflist[$i][0]==$prjcd){
			$oldtripcheck=true;
			continue;
		}
		$outdata.=$stafflist[$i][0];
		$outdata.="\t";
		$outdata.=$stafflist[$i][1];
		$outdata.="\t";
		$outdata.=$stafflist[$i][2];
		$outdata.="\t";
		$outdata.=$stafflist[$i][3];
		$outdata.="\t";
		$outdata.=$stafflist[$i][4];
		$outdata.="\n";

	}

	if(!$oldtripcheck){
		// トリップがみつからない
		return false;
	}

	$outfilename=APATH_STAFF_LIST_FILE;
	$outfp=pfopen($outfilename,"w");
	pfwrite($outfp,$outdata);
	pfclose($outfp);
//	chmod($outfilename,0777);

	return true;
}


// 所属プロジェクト一覧表示
function &prj_staff_belonging_list_view($tripkey,$email){
	$trip=gen_trip_matcha($tripkey);
	$stafflist=load_file_table(APATH_STAFF_LIST_FILE);
	reset($stafflist);
	$pickrecord=array();

	// super_user check
	$root_staff=stafflist_check(SUPER_PROJECT,$tripkey,$email);
	if($root_staff !== false)
	{
		foreach($stafflist as $staff)
		{
			if(!empty($staff[0]) and !array_key_exists($staff[0],$pickrecord))
			{
				$pickrecord[$staff[0]] = $staff;
			}
		}
	}else{
		while(list($key,$val) = each($stafflist)){
			if(($val[1]==$trip)&&($val[3]==$email)){
				$pickrecord[]=$val;
			}
		}
	}
	$pickcount=count($pickrecord);
	if($pickcount<1){	// 参加しているプロジェクトがひとつもない
		error_exit("参加しているプロジェクトがひとつもありません");
	}
	
	reset($pickrecord);
	$pagedata="<table>";
	while(list($key,$val) = each($pickrecord)){
		$ret_prj=prj_get_data($val[0]);	// プロジェクトデータ取得
		if($ret_prj['ret']=false){
			continue;
		}
		$prjdata=$ret_prj['data'];
		
		$pagedata.="<tr>";
		$pagedata.="<form action=\"".PUBLOG_SCRIPT_FILE."?lv=project&mod=menu\" method=post>";
		$pagedata.="<td>";
		$pagedata.="<input type=hidden name=mfbbs_login_prjcd value=\"".$prjdata[0]."\">";
		$pagedata.="<input type=hidden name=mfbbs_login_tripkey value=\"".$tripkey."\">";
		$pagedata.="<input type=hidden name=mfbbs_login_email value=\"".$email."\">";
		$pagedata.="<input type=submit value=\"Login\">";
		$pagedata.="</td>";
		$pagedata.="</form>";
		$pagedata.="<td>";
		$pagedata.="[".$val[2]."/".$val[4]."]";	// ハンドル/権限
		$pagedata.="<a href=\"".HTTP_HOME_DIR.$prjdata[0]."\" target=_blank>";
		$pagedata.=$prjdata[1];	// プロジェクト名
		$pagedata.="(".$prjdata[0].")";	// プロジェクトコード
		$pagedata.="</a>";
		$pagedata.="</td>";
		$pagedata.="<td bgcolor=#cccccc><font size=\"-1\">";
		$pagedata.=$prjdata[2];	// プロジェクト説明
		$pagedata.="</font></td>";
		$pagedata.="</td>";
		$pagedata.="<td><font size=\"-1\">(";
		if($prjdata[4]=="o"){	// status
			$pagedata.="公開中";
		}else if($prjdata[4]=="p"){
			$pagedata.="準備中";
		}else if($prjdata[4]=="x"){
			$pagedata.="停止中";
		}else{
			$pagedata.="不明";
		}
		$pagedata.=")</font></td>";
		$pagedata.="</tr>";
	}
	$pagedata.="</table>";

	$outdata="";
	$outdata.="<strong>[".PUBLOG_SERVER_NAME."/".$email."]</strong> 所属プロジェクト一覧</b><br />";
	$outdata.="所属プロジェクト数: ".(string)($pickcount)." プロジェクト<br />";
	$outdata.="<p>";
	$outdata.=$pagedata;
	$outdata.="<p>";
	$outdata.="<hr noshade>";

	return $outdata;
}

?>
