<?php
// $Id: std.func.php,v 1.13 2005/04/06 07:11:28 fukami Exp $
// 標準的な小物関数達

// 現在の時刻をW3Cフォーマットで取得
// http://www.w3.org/TR/NOTE-datetime
function now_w3c()
{
	$tmp = date("O");
	$tz = substr($tmp,0,3).':'.substr($tmp,-2);
	$now = date("Y-m-d");
	$now.= 'T';
	$now.= date("H:i:s");
	$now.=$tz;
	return $now;
}

function publog_parse_url($src){

	$parsed_url = parse_url($src);	// src url 分解
	
	preg_match("/^(([-_.!~*'()a-zA-Z0-9;?:@&=+$,%#]*\/)*)([-_.!~*'()a-zA-Z0-9;?:@&=+$,%#]*)$/i",$parsed_url['path'],$matches);
	$dirname = $matches[1];
	$basename = $matches[3];
	if(!empty($basename))
	{
		$pathinfo = pathinfo($basename);
	}
	$parsed_url['dirname'] = $dirname;
	$parsed_url['basename'] = $basename;
	$parsed_url['extension'] = $pathinfo['extension'];
	
	return $parsed_url;
}

// ・配列中の、HTMLエンティティを特殊文字へ変換
// ・配列中の、キーが数値のものをくっつける
function xml_array_sanitize($param)
{
	if(is_array($param))
	{
		$vv = null;
		foreach($param as $key => $val)
		{
			if(is_numeric($key))
			{
				$vv.=$val;
			}
		}
		if(empty($vv))
		{
			$result = array_map('xml_array_sanitize',$param);
		}else{
//			$result = phtmldec($vv);
				$result = $vv;
		}
	}else{
//		$result = phtmldec($param);
		$result = $param;
	}
	return $result;
}
// 特殊文字をHTMLエンティティに変換
function phtmlenc($string)
{
//	return htmlentities($string,ENT_QUOTES,PUBLOG_INTERNAL_ENCODING);
	return htmlspecialchars($string,ENT_QUOTES,PUBLOG_INTERNAL_ENCODING);
}
function &phtmlenc_by_ref(&$string)
{
//	$s = htmlentities($string,ENT_QUOTES,PUBLOG_INTERNAL_ENCODING);
	$s = htmlspecialchars($string,ENT_QUOTES,PUBLOG_INTERNAL_ENCODING);
	$string =& $s;
	return $string;
}
function &array_phtmlenc_by_ref(&$param)
{
	if(is_array($param))
	{
		$result =& array_map('array_phtmlenc_by_ref',$param);
	}else{
		$result =& phtmlenc_by_ref($param);
	}
	return $result;
}
function array_phtmlenc($param)
{
	if(is_array($param))
	{
		$result = array_map('array_phtmlenc',$param);
	}else{
		$result = phtmlenc($param);
	}
	return $result;
}

// HTMLエンティティを文字に変換
function phtmldec($string)
{
	return html_entity_decode($string,ENT_QUOTES,PUBLOG_INTERNAL_ENCODING);
}

function is_url($url)
{
	if(ereg("^http://([0-9a-zA-Z]+[0-9a-zA-Z\-]*[0-9a-zA-Z]*\.)+[0-9a-zA-Z]+[0-9a-zA-Z]+\/*[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]*$",$url))
	{
		return true;
	}
	return false;
}

function is_email($email)
{
	return check_email($email);
}

// メールアドレス正当性評価
function check_email($email){
	if(ereg("^[0-9a-zA-Z_.~+&/\-]+\@([0-9a-zA-Z]+[0-9a-zA-Z\-]*[0-9a-zA-Z]*\.)+[0-9a-zA-Z]+[0-9a-zA-Z]+$",$email)){
			return true;
	}
	return false;
}


function publog_uniqid()
{
	return base_convert(time(),10,36);
}

/*function sanitize($param)
{
	if (is_array($param))
	{
		$result = array_map('sanitize',$param);
	}
	else
	{
		$result = str_replace("\0",'',$param);
		if (get_magic_quotes_gpc())
		{
			$result = stripslashes($result);
		}
	}
	return $result;
}
*/
// \r\n\t カット
function cut_nrt($param)
{
	if (is_array($param))
	{
		$result = array_map('cut_nrt',$param);
	}
	else
	{
		$result=ereg_replace("[\t\n\r]","",$param);
	}
	return $result;
}

function get_ip_addr () {
    global $_SERVER;
    return $_SERVER ['REMOTE_ADDR'];
}
define("P2_CASH_GET_URI","http://p2.chbox.jp/read.php?url=");
function &churl2href($in_message){
	$in_message =& ereg_replace("(http://[0-9a-zA-Z]+[0-9a-zA-Z\-]*[0-9a-zA-Z]*\.2ch\.net\/test\/read.cgi\/[-_a-zA-Z0-9]+/[0-9]+/[0-9a-zA-Z\-]*)",P2_CASH_GET_URI."\\1",$in_message);
	return $in_message;
}

function url2href($in_message){
	// リンク

	$in_message =& ereg_replace("http://([0-9a-zA-Z]+[0-9a-zA-Z\-]*[0-9a-zA-Z]*\.2ch\.net\/test\/read.cgi\/[-_a-zA-Z0-9]+/[0-9]+/[0-9a-zA-Z\-]*)","HTTP-2CH-LINK://\\1",$in_message);

//	$in_message=eregi_replace("(.ttp://(([0-9a-zA-Z]+[0-9a-zA-Z\-]*[0-9a-zA-Z]*\.)+[0-9a-zA-Z]+[0-9a-zA-Z]+\/*[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]*))","(<a href=\"http://\\2\" onMouseover=\"showHtmlPopUp(\'http://\\2\',event,0.2)\" onMouseout=\"offHtmlPopUp()\">p</a>)<a href=\"http://\\2\" target=_blank class=base>\\1</a>",$in_message);
	$in_message=eregi_replace("(.ttp://(([0-9a-zA-Z]+[0-9a-zA-Z\-]*[0-9a-zA-Z]*\.)+[0-9a-zA-Z]+[0-9a-zA-Z]+\/*[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]*))","<a href=\"http://\\2\" target=_blank class=base>\\1</a>",$in_message);

	$in_message =& ereg_replace("HTTP-2CH-LINK://([0-9a-zA-Z]+[0-9a-zA-Z\-]*[0-9a-zA-Z]*\.2ch\.net\/test\/read.cgi\/[-_a-zA-Z0-9]+/[0-9]+/[0-9a-zA-Z\-]*)","<a href=\"".P2_CASH_GET_URI."http://\\1\" target=_blank class=base>http://\\1</a>",$in_message);


	return $in_message;
}

function reslink($in_message){
	// レス元へのリンク
	$in_message =& preg_replace("/&gt;&gt;([0-9]+)/","<a href=\"#\\1\">&gt;&gt;\\1</a>",$in_message);

	return $in_message;
}

// 経過時間生成
function gen_elapse_time($starttime){
	if(""==$starttime){
		return;
	}
	$start_mili=substr($starttime,2,8);
	$start_sec=substr($starttime,17,4);
	$endtime=microtime();
	$end_mili=substr($endtime,2,8);
	$end_sec=substr($endtime,17,4);
	$keika_mili=((int)$end_sec.$end_mili)-((int)$start_sec.$start_mili);
	$keika=$keika_mili/100000000;
	return $keika;
}
function disp_elapse_time($starttime,$message){
	if(""==$starttime){
		return;
	}
	$keika=gen_elapse_time($starttime);
	print("[".$message." ".$keika." sec.]");
	flush();
}


// 折り返し( $orilen は バイトではなく文字数)
// orilen 文字ずつ end を挿入
function orikaeshi($src,$orilen,$end,$enc){
	if(""==$orilen){ $orilen=10; }
	if(""==$end){ $end="\n"; }
	if(""==$enc){ $enc=mb_detect_encoding($src); }
	$splsrcarr=split($end,$src);
	$arr=array();
	while(list($key,$val)=each($splsrcarr)){
		$len=strlen($val);
		if($len <= $orilen){
			$arr[]=$val;
			continue;
		}
		for($i=0;$i<$len;$i+=$orilen){
			$arr[]=mb_substr($val,$i,$orilen,$enc);
		}
	}
	$arr_count=count($arr);
	$dest="";
	for($i=0;$i<$arr_count;$i++){
		$dest.=$arr[$i].$end;
		if($i>=$arr_count){ break; }
	}
	return $dest;
}

?>
