<?php
// $Id: rcv.done.php,v 1.19.2.1 2006/02/13 15:14:33 n_a_o Exp $
// バーチャルディレクトリ受信

// node: publog node path
// vd: 割り当てカテゴリ

/*
	0	'datetime'  => 受信日時
	1	'vd'   => バーチャルディレクトリ:拡張
	2	'title'     => ページタイトル
	3	'url'       => 元ページ
	4	'excerpt'   => ページ要約
	5	'blog_name' => ブログ名

	6	'blog_tagline' => ブログ要約
	7	'author'   => 執筆者:拡張
	8	'logo' => イメージバナー 148x37 GIF
	9	'blog_url' => プロジェクトＵＲＬ
	10	'logo_mini' => イメージバナーmini 80x15 GIF


		'charset'   => SOURCE_ENCODING // 送信側文字コード(未既定)
*/

require_once('func/trackback.func.php');
require_once('func/vd.func.php');

// 上限行数が決まっているファイルに行追加
function vd_file_add_line($filename,$url,$newline,$maxline=100,$project_dupdel=false)
{
	$new_arr = explode("\t",$newline);
	$new_blog_url = $new_arr[9];
	$out_last_data = null;
	if(file_exists($filename))
	{
		$str = file_get_contents($filename);
		$str_arr = explode("\n",$str);
		// 重複チェック
		$chk_str_arr = array();
		foreach($str_arr as $line)
		{
			$line_arr = explode("\t",$line);
			// プロジェクト重複削除
			if($project_dupdel)
			{
				if($line_arr[9] == $new_blog_url)
				{
					continue;
				}
			}
			if($line_arr[3] == $url)
				tb_xml_msg(1,'TrackBack Ping URL is already exists.');
			$chk_str_arr[] = $line;
		}

		$str_arr =& $chk_str_arr;
		$str_arr_ct = count($str_arr);
		if($maxline <= $str_arr_ct)
		{
			$skip = count($str_arr) - $maxline;
			foreach($str_arr as $line)
			{
				if(trim($line)==null)
					continue;
				if($skip > 0)
				{
					$skip --;
					continue;
				}
				$out_last_data.= $line."\n";
			}
		}else{
			foreach($str_arr as $line)
			{
				if(trim($line)==null)
					continue;
				$out_last_data.= $line."\n";
			}
//			$out_last_data .= join("\n",$str_arr);
		}
	}
	$out_last_data.= $newline;
	write_file($filename,$out_last_data);

}

function do_mod_proc_disp()
{
	global $vars, $retvars;
	global $smes,$pmes;
	global $logindat,$prjdat,$userdat;
	global $systpl;
	extract($vars);

	//referer付きのTrackBack Pingは無視
	if(!empty($_SERVER['HTTP_REFERER'])){
		die(''); //return no message
	}

	// TrackBack Ping における URL パラメータは必須である。
	if (empty($url))
	{
		tb_xml_msg(1,'It is an indispensable parameter. URL is not set up.');
	}
	// Query String を得る
	if (empty($vd))
	{
		tb_xml_msg(1,'TrackBack Ping URL is inaccurate.');
	}

	$vd_arr = explode('/',$vd);
	if(10 < count($vd_arr))
	{
		tb_xml_msg(1,'too many vd directory Error.');
	}

/*	if(empty($author))
	{
		$author = '名無しさん';
	}

*/

	$title=htmlspecialchars($title);
	$url=strip_tags($url);
	$excerpt=strip_tags($excerpt);
	$excerpt=nl2br($excerpt);
	$excerpt=ereg_replace("[\n\r]","",$excerpt);
	$blog_name=htmlspecialchars($blog_name);
	$blog_tagline=htmlspecialchars($blog_tagline);
	$blog_url=strip_tags($blog_url);
	$author=htmlspecialchars($author);
	$vd=htmlspecialchars($vd);
	$logo=htmlspecialchars($logo);
	$logo_mini=htmlspecialchars($logo_mini);

	// 要約文の作成
	if(!empty($excerpt))
	{
		$excerpt=strip_tags(mb_strcut($excerpt,0,100,PUBLOG_INTERNAL_ENCODING)).'...';
	}
	$excerpt=cut_nrt($excerpt);

	$yyyy = date("Y");
	$mm = date("m");

	$now = now_w3c();
	
	if(!preg_match("/^[\/].+/",$vd))
	{
		$vd = '/'.$vd;
	}
	
	// vd の存在チェック
/*	if($vd != '/all')
	{
		$vd_src = file_get_contents(APATH_SCRIPT_DIR.'vd.txt');
		$vd_arr = explode("\n",$vd_src);
		$vd_exists = false;
		foreach($vd_arr as $vd_line)
		{
			$vd_line_arr = explode("\t",$vd_line);
			if($vd_line_arr[0] == $vd){
				$vd_exists = true;
				break;
			}
		}
		if(!$vd_exists)
		{
			tb_xml_msg(1,'vd not exists.');
		}
	}
*/
	if(!remote_file_exists($logo))
	{
		$logo = null;
	}
	if(!remote_file_exists($logo_mini))
	{
		$logo_mini = null;
	}
	$insdata=null;
	$insdata.=$now."\t";
	$insdata.=$vd."\t";
	$insdata.=$title."\t";
	$insdata.=$url."\t";
	$insdata.=$excerpt."\t";
	$insdata.=$blog_name."\t";
	$insdata.=$blog_tagline."\t";
	$insdata.=$author."\t";
	$insdata.=$logo."\t";
	$insdata.=$blog_url."\t";
	$insdata.=$logo_mini."\n";
//print_r($insdata);
	$vd_dir = OPEN_DATA_DIR.'vd'.$vd.'/';
	check_dir($vd_dir);

	$last_filename = $vd_dir.'last.txt';
	$month_filename = $vd_dir.$yyyy.$mm.'.txt';

	add_file($month_filename,$insdata);
	vd_file_add_line($last_filename,$url,$insdata,100,true);

	// 全部データ
	$vd_all_dir = OPEN_DATA_DIR.'vd/all/';
	check_dir($vd_all_dir);
	$vd_all_last_filename = $vd_all_dir.'last.txt';
	$month_all_filename = $vd_dir.$yyyy.$mm.'.txt';
	if($vd != '/test'){
		add_file($month_all_filename,$insdata);
		vd_file_add_line($vd_all_last_filename,$url,$insdata,100,true);
	}


	$last = 100;
	$out =& vd_disp_file($last_filename,$last,'mini');
	$vd_out = $vd_dir.'index.html';
	file_put_contents($vd_out,$out);

	$all_out =& vd_disp_file($vd_all_last_filename,$last,'mini');
	$vd_all_out = $vd_all_dir.'index.html';
	file_put_contents($vd_all_out,$all_out);

	tb_xml_msg(0,'');
	die;

}
?>
