<?php
// プロジェクト基本データ修正

require_once('class/xml.class.php');
require_once('class/publogxmldata.class.php');
require_once('class/projectdata.class.php');

require_once('class/publogdata.class.php');

function do_mod_proc_disp()
{
	global $vars, $retvars;
	global $smes,$pmes;
	global $logindat,$prjdat,$userdat;
	global $systpl;
	require('func/inc/vars_to_variable.inc.php');

	$er=FALSE;
	$ermes="";

	$prjname=ereg_replace("[\r\n\t]","",$prjname);
	$prjname=trim($prjname);

	$setsumei=ereg_replace("[\r\n\t]","",$setsumei);
	$setsumei=trim($setsumei);
	$setsumei=htmlspecialchars($setsumei, ENT_QUOTES);

	$status=ereg_replace("[\r\n\t]","",$status);
	$status=trim($status);

	$bbscode=ereg_replace("[\r\n\t]","",$bbscode);
	$bbscode=trim($bbscode);

	if(""==$prjname){
		$ermes.="<li>";
		$ermes.="プロジェクト名が空白です";
		$ermes.="</li>\n";
		$er=TRUE;
	}
	if(""==$status){
		$ermes.="<li>";
		$ermes.="プロジェクト状態が空白です";
		$ermes.="</li>\n";
		$er=TRUE;
	}
	if(""==$setsumei){
		$ermes.="<li>";
		$ermes.="説明が空白です";
		$ermes.="</li>\n";
		$er=TRUE;
	}
	if(PROJEDT_NAME_MAX_STRLEN<strlen($prjname)){
		$ermes.="<li>";
		$ermes.="プロジェクト名が長すぎます";
		$ermes.="</li>\n";
		$er=TRUE;
	}
	if(PROJECT_PROFILE_MAX_STRLEN<strlen($setsumei)){
		$ermes.="<li>";
		$ermes.="説明文が長すぎます";
		$ermes.="</li>\n";
		$er=TRUE;
	}
	if(!ereg("^[opx]$",$status)){
		$ermes.="<li>";
		$ermes.="状態設定がありえない値です";
		$ermes.="</li>\n";
		$er=TRUE;
	}
	if(ereg("<",$prjname) || ereg(">",$prjname) || ereg("&",$prjname)){
		$ermes.="<li>";
		$ermes.="プロジェクト名に&lt; &gt; &amp;は使えません";
		$ermes.="</li>\n";
		$er=TRUE;
	}
	if(ereg("<",$ownerhandlename) || ereg(">",$ownerhandlename) || ereg("&",$ownerhandlename)){
		$ermes.="<li>";
		$ermes.="オーナーハンドル名に&lt; &gt; &amp;は使えません";
		$ermes.="</li>\n";
		$er=TRUE;
	}
	// プロジェクトコード重複チェック
	if(prj_check_dup_prjcd($prjdat['cd'])){
		$ermes.="<li>";
		$ermes.="存在しないプロジェクトコードです";
		$ermes.="</li>\n";
		$er=TRUE;
	}
	if($er){
		$ermes="入力内容をもう一度確認してください<p><ul>".$ermes;
		$ermes.="</ul></p>前の画面に戻ってやりなおしてください";
		$retvars['usetpl']=false;
		return error_out($ermes);
	}
	// プロジェクトレコード更新
	prj_update_project_data($prjdat['cd'],$prjname,$setsumei,"",$status);

	// xml データ更新
	// データオブジェクト ====================
	$publogdata_conf = array(
				'project' => array(
					'cd' => $prjdat['cd']
				),
				'xml_file' => array(
					'sys_dir' => SYS_DIR,
					'base_dir' => APATH_HOME_DIR,
					'script_dir' => APATH_SCRIPT_DIR
				)
			);
	$publogdata = new PublogData($publogdata_conf);
	// プロジェクトファイルの生成(xml)
	$upd_project = array(
		'project' => array(
			'title' => $prjname,
			'tagline' => $setsumei
		)
	);

	$project =& $publogdata->load('project');
	$node =& $project->pxml->node_data['project'];
	$node['title'] = $prjname;
	$node['tagline'] = $setsumei;
	$project->_save("update");
	return;
}
?>
