<?php
// スタッフ参加登録(認証なし)

require_once('class/xml.class.php');
require_once('class/publogxmldata.class.php');
require_once('class/publogxmllistdata.class.php');
require_once('class/projectdata.class.php');

require_once('class/publogdata.class.php');


function do_mod_proc_disp()
{
	global $vars,$retvars;
	global $smes,$pmes;
	global $logindat,$prjdat,$userdat;
	global $systpl;
	require('func/inc/vars_to_variable.inc.php');

	// check
	$er=FALSE;
	$ermes=null;
	if(empty($project_cd))
	{
		$ermes.="<li>";
		$ermes.="プロジェクトコードが空白です";
		$ermes.="</li>\n";
		$retvars['usetpl']=false;
		$er=TRUE;
		return error_out($ermes);
	}
	if(""==$staff_name){
		$ermes.="<li>";
		$ermes.="名前が空白です";
		$ermes.="</li>\n";
		$er=TRUE;
	}
	if(2>strlen($staff_name)){
		$ermes.="<li>";
		$ermes.="名前が短かすぎます";
		$ermes.="</li>\n";
		$er=TRUE;
	}
	if(20<strlen($staff_name)){
		$ermes.="<li>";
		$ermes.="名前が長すぎます";
		$ermes.="</li>\n";
		$er=TRUE;
	}
	if(ereg("<",$staff_name) || ereg(">",$staff_name) || ereg("&",$staff_name)){
		$ermes.="<li>";
		$ermes.="名前に&lt; &gt; &amp;は使えません";
		$ermes.="</li>\n";
		$er=TRUE;
	}
	if(""==$staff_email){
		$ermes.="<li>";
		$ermes.="名前が入力されていないようです";
		$ermes.="</li>\n";
		$er=TRUE;
	}
	if(!is_email($staff_email)){
		$ermes.="<li>";
		$ermes.="メールアドレスがメールアドレスらしくありません";
		$ermes.="</li>\n";
		$er=TRUE;
	}

	if(""==$staff_pass){
		$ermes.="<li>";
		$ermes.="パスワードが入力されておりませぬ。これでは忍びの者に我々の情報が筒抜けでござろう…";
		$ermes.="</li>\n";
		$er=TRUE;
	}
	if(!ereg("^[a-zA-Z0-9]+$",$staff_pass)){
		$ermes.="<li>";
		$ermes.="殿、パスワードは半角英数でとあれほど申したではありませぬか…";
		$ermes.="</li>\n";
		$er=TRUE;
	}

	if(200<strlen($staff_comment)){
		$ermes.="<li>";
		$ermes.="コメントが長すぎです…ひとことでお願いします";
		$ermes.="</li>\n";
		$er=TRUE;
	}
	if($staff_pass!=$staff_pass_check){
		$ermes.="<li>";
		$ermes.="入力された２つのパスワード文字列がバラバラです";
		$ermes.="</li>\n";
		$er=TRUE;
	}
	if($er){
		$ermes="入力内容をもう一度確認してください<p><ul>".$ermes;
		$ermes.="</ul></p>前の画面に戻ってやりなおしてください";
		$retvars['usetpl']=false;
		return error_out($ermes);
	}

	// データオブジェクト ====================
	$publogdata_conf = array(
				'project' => array(
					'cd' => $project_cd
				),
				'xml_file' => array(
					'sys_dir' => SYS_DIR,
					'base_dir' => APATH_HOME_DIR,
					'script_dir' => APATH_SCRIPT_DIR
				)
			);
	$publogdata = new PublogData($publogdata_conf);
	// プロジェクトデータ取得
	$project =& $publogdata->load('project');
	if(!$project)
	{
		$retvars['usetpl']=false;
		return error_out("プロジェクトデータを取得できませんでした");
	}
	$project_data =& $project->get();
	
	$systpl->assign('project',$project_data);

	$default_css = 'skin/publog.css';
	$systpl->assign('default_css',$default_css);

	$staff_name=mb_convert_encoding($staff_name, "UTF-8","auto");
	$staff_name=ereg_replace("[\r\n\t]","",$staff_name);
	$staff_name=trim($staff_name);

	$staff_email=mb_convert_encoding($staff_email, "UTF-8","auto");
	$staff_email=ereg_replace("[\r\n\t]","",$staff_email);
	$staff_email=trim($staff_email);

	$staff_pass=mb_convert_encoding($staff_pass, "UTF-8","auto");
	$staff_pass=ereg_replace("[\r\n\t]","",$staff_pass);
	$staff_pass=trim($staff_pass);

	$staff_comment=htmlspecialchars($staff_comment, ENT_QUOTES);
	$staff_comment=mb_convert_encoding($staff_comment, "UTF-8","auto");
	$staff_comment=ereg_replace("[\r\n\t]","",$staff_comment);
	$staff_comment=trim($staff_comment);


	// データ重複チェック(スタッフキュー)
	if(file_exists(HIDDEN_DIR.$project_cd."/staffque.txt")){
		$staffque=load_file_table(HIDDEN_DIR.$project_cd."/staffque.txt");
		reset($staffque);
		while(list($key,$val) = each($staffque)){
			if($val[2]==$staff_email){
				$retvars['usetpl']=false;
				return error_out("現在プロジェクト管理者さんの承認待ちです。しばらくお待ちください。");
			}
		}
	}

	// データ重複チェック(本スタッフリスト)
	$allstafflist=stafflist_prj_get($project_cd);
	reset($allstafflist);
	while(list($key,$val) = each($allstafflist)){
		if($val[3]==$staff_email){
			$retvars['usetpl']=false;
			return error_out("既にスタッフとして登録済です。");
		}
	}

	$data="";
	$data.=gen_trip_matcha($staff_pass)."\t";
	$data.=$staff_name."\t";
	$data.=$staff_email."\t";
	$data.=$staff_comment."\t";
	$data.=date("YmdHis")."\n";

	add_file(HIDDEN_DIR.$project_cd."/staffque.txt",$data);



	$retvars['body_as_main']=true;
	return;
}
?>
