<?php
// スタッフ権限修正
function do_mod_proc_disp()
{
	global $authority;
	global $vars,$retvars;
	global $smes,$pmes;
	global $logindat,$prjdat,$userdat;
	global $systpl;
	require('func/inc/vars_to_variable.inc.php');

	$staff_authority=ereg_replace("[\r\n\t]","",$staff_authority);
	$staff_authority=trim($staff_authority);
	if(empty($staff_trip))
	{
		$ermes = 'スタッフトリップがありません';
		$retvars['usetpl']=false;
		return error_out($ermes);
	}
	if(empty($staff_email))
	{
		$ermes = 'スタッフメールアドレスがありません';
		$retvars['usetpl']=false;
		return error_out($ermes);
	}
	if(empty($staff_authority))
	{
		$ermes = 'スタッフ権限の指定がありません';
		$retvars['usetpl']=false;
		return error_out($ermes);
	}
	if(!array_key_exists($staff_authority,$authority))
	{
		$ermes = '存在しない権限が指定されました';
		$retvars['usetpl']=false;
		return error_out($ermes);
	}

	$staffdata=array();
	$staffdata=stafflist_get_staff_data($prjdat['cd'],$staff_trip,$staff_email);
	if(!is_array($staffdata))
	{
		$ermes = 'そのスタッフは存在しません';
		$retvars['usetpl']=false;
		return error_out($ermes);
	}
	if($staffdata[4]==$staff_authority)
	{
		$ermes = '権限が以前と同じです。修正はしませんでした';
		$retvars['usetpl']=false;
		return error_out($ermes);
	}
	$staffdata['authorityname'] = $authority[$staffdata[4]];
	$staffdata['new_authorityname'] = $authority[$staff_authority];
	$systpl->assign_by_ref('staff',$staffdata);

	// owner が 0 になるのを避ける処理
	if("owner"==$staffdata[4]){
		$allstafflist=stafflist_prj_get($prjdat['cd']);
		$ownercount=0;
		foreach($allstafflist as $val)
		{
			if($val[4]=="owner"){
				$ownercount++;
			}
		}
		if($ownercount<2)
		{
			$ermes = 'オーナーは必ず１名必要です。操作は中断しました';
			$retvars['usetpl']=false;
			return error_out($ermes);
		}
	}


	// スタッフリスト更新
	stafflist_update($prjdat['cd'],$staff_trip,$staff_email,$staffdata[1],$staffdata[2],$staffdata[3],$staff_authority);

	return;
}
?>
