<?php
/*
 * $Id: blog_data.class.php,v 1.3 2004/08/05 21:52:07 fukami Exp $
 * ブログ関連オブジェクトの生成とデータの読み込み
 */

class BlogData extends PublogData
{
	var $entrylist;
	var $entry;
	var $commentlist;
/*
	var $conf = array(
				'base' => array(
					'id' => null		// ex.) 'www.example.com/home/'
				),
				'project' => array(
					'cd' => null
				),
				'thread' => array(
					'id' => null
				),
				'entry' => array(
					'id' => null
				),
				'comment' => array(
					'id' => null
				),
				'xml_file' => array(
					'sys_dir' => null,
					'base_dir' => null
				)
			);
*/
	function BlogData($generator_conf = null)
	{
		parent::set_conf($generator_conf);
	}
	function gen_data_conf($name)
	{
		$xpath = null;	// xml file path
		$tpath = null;	// template file path
		$sd =& $this->conf['xml_file']['sys_dir'];
		$bd =& $this->conf['xml_file']['base_dir'];
		$scd =& $this->conf['xml_file']['script_dir'];
		switch ($name)
		{
			case 'thread':
				$xpath = $bd.$this->conf['project']['cd'].
					'/data/blog/'.$this->conf['thread']['id'].'/thread.xml';
				$tpath = $scd.'mod/thread/blog/xml_templates/thread_xml.tpl';
			break;
			case 'entrylist':
				$xpath = $bd.$this->conf['project']['cd'].
					'/data/blog/'.$this->conf['thread']['id'].'/entrylist.xml';
				$tpath = $scd.'mod/thread/blog/xml_templates/entrylist_xml.tpl';
			break;
			case 'entry':
				$xpath = $bd.$this->conf['project']['cd'].
					'/data/blog/'.$this->conf['thread']['id'].
					'/'.(substr($this->conf['entry']['id'],0,4)).	// ex.) 2004
					'/'.(substr($this->conf['entry']['id'],4,2)).	// ex.) 05
//					'/'.(substr($this->conf['entry']['id'],6,2)).	// ex.) 20
//					'/entry_'.$this->conf['entry']['id'].'.xml';	// entry_20040520123456.xml
					'/entry_'.(substr($this->conf['entry']['id'],6,2)).
					'_'.(substr($this->conf['entry']['id'],8)).
					'.xml';	// ex.) entry_20_123456.xml
				$tpath = $scd.'mod/thread/blog/xml_templates/entry_xml.tpl';
			break;
			case 'commentlist':
				$xpath = $bd.$this->conf['project']['cd'].
					'/data/blog/'.$this->conf['thread']['id'].
					'/'.(substr($this->conf['entry']['id'],0,4)).	// ex.) 2004
					'/'.(substr($this->conf['entry']['id'],4,2)).	// ex.) 05
//					'/'.(substr($this->conf['entry']['id'],6,2)).	// ex.) 20
//					'/commentlist_'.$this->conf['entry']['id'].'.xml';	// commentlist_20040520123456.xml
					'/commentlist_'.(substr($this->conf['entry']['id'],6,2)).
					'_'.(substr($this->conf['entry']['id'],8)).
					'.xml';	// ex.) entry_20_123456.xml
				$tpath = $scd.'mod/thread/blog/xml_templates/commentlist_xml.tpl';
			break;
			default:
				parent::gen_data_conf($name);
			return;
		}
		$data_conf = array(
			'xml_file' => array(
				'full_path' =>  $xpath
			),
			'data_template' => array(
				'full_path' => $tpath
			)
		);
		$data_conf = array_merge_recursive($data_conf,$this->conf);
		// set conf data
		$this->$name->set_conf($data_conf);
	}
}
?>
