<?php
// $Id: gozans_import.php,v 1.3 2004/09/18 12:55:14 fukami Exp $
// ゴザンスからのデータインポート


function &gozans_import($gozans_id,$project_cd,$thread_id)
{
$DEST_SERVER_NAME = PUBLOG_SERVER_NAME;
$DEST_OPEN_DIR = OPEN_DIR;
$DEST_HIDDEN_DATA_DIR = HIDDEN_DIR;

$SRC_DIR = 'http://writer.gozans.com/writer/';

	$goz_kijilist_string = file_get_contents($SRC_DIR.$gozans_id.'/kijilist.txt');
	$goz_kijilist_string = mb_convert_encoding($goz_kijilist_string,'UTF-8','SJIS');
	$goz_kiji = explode("\n",$goz_kijilist_string);

	$el_dat = null;
	$entry_count = 0;
	$import_list = array();
	foreach($goz_kiji as $line)
	{
		list($no,$gid,$date,$title,$author) = explode("\t",$line);
		if(null==$no)
			continue;
		$timestamp = strtotime($date);
		$w3c = date("Y-m-d",$timestamp);
		$w3c.= 'T';
		$w3c.= date("H:i:s",$timestamp);
		$w3c.= '+09:00';
		$title = htmlspecialchars($title);
		$author = htmlspecialchars($author);
		$entry_id = date("YmdHis",$timestamp);
//		print("no[$no] gid[$gid] date[$date] title[$title] author[$author] <br />");

		// 返り値の生成
		$import_list[] = $no.', '.$w3c.', '.$title.'('.$author.')';

// エントリーデータ
	$goz_kiji_string = file_get_contents($SRC_DIR.$gozans_id.'/'.$no.'.txt');
	$goz_kiji_string = mb_convert_encoding($goz_kiji_string,'UTF-8','SJIS');
	$goz_content_list = explode("\n",$goz_kiji_string);
	$honbun = false;
	$content_src = null;
	foreach($goz_content_list as $c_line)
	{
		if(!$honbun)
		{
			if(null == trim($c_line))
			{
				$honbun = true;
			}
			continue;
		}
		$content_src.= $c_line."\n";
	}
	$content = htmlspecialchars($content_src);
	$summary=strip_tags(mb_strcut($content_src,0,DESCRIPTION_CUT_STRLEN,PUBLOG_INTERNAL_ENCODING)).'...';
	$summary = htmlspecialchars($summary);

$el_dat.=<<<EOD
	<entry>
		<id>$entry_id</id>
		<title>$title</title>
		<link>test</link>
		<summary>$summary</summary>
		<issued>$w3c</issued>
		<modified>$date</modified>
		<author>
			<name>$author</name>
		</author>
	</entry>

EOD;


	$entry_id_yyyy = substr($entry_id,0,4);
	$entry_id_mm = substr($entry_id,4,2);
	$entry_id_dd = substr($entry_id,6,2);
	$entry_id_hour = substr($entry_id,8,2);
	$entry_id_min = substr($entry_id,10,2);
	$entry_id_sec = substr($entry_id,12,2);
	$entry_file_dir = $DEST_OPEN_DIR.'home/'.$project_cd.'/data/blog/'.$thread_id.'/'.
		$entry_id_yyyy.'/'.$entry_id_mm.'/';
	$entry_file_name = $entry_file_dir.'entry_'.$entry_id_dd.'_'.$entry_id_hour.$entry_id_min.$entry_id_sec.'.xml';
	$commentlist_file_name = $entry_file_dir.'commentlist_'.$entry_id_dd.'_'.$entry_id_hour.$entry_id_min.$entry_id_sec.'.xml';
$uri = "http://$DEST_SERVER_NAME/home/$project_cd/archives/blog/$thread_id/".
					$entry_id_yyyy.'/'.$entry_id_mm.'/'.$entry_id_dd.'_'.$entry_id_hour.$entry_id_min.$entry_id_sec.'.html';
$ed_dat=null;
$ed_dat=<<<EOD
<?xml version="1.0" encoding="UTF-8" ?>
<entry>
	<id>$entry_id</id>
	<uri>$uri</uri>
	<parent>
		<id>$thread_id</id>
	</parent>
	<title type="text/plain">$title</title>
	<input_format>x</input_format>
	<type>text</type>
	<format>text/plain</format>
	<language>jp</language>
	<summary>$summary</summary>
	<content>$content</content>
	<issued>$w3c</issued>
	<modified>$w3c</modified>
	<author>
		<name>$author</name>
	</author>
</entry>

EOD;

		$entry_count++;

//print($entry_file_name);
	check_dir($entry_file_dir);
		file_put_contents($entry_file_name,$ed_dat);
//		print($ed_dat);

// コメントリスト
$cl_dat=<<<EOD
<?xml version="1.0" encoding="UTF-8" ?>
<commentlist>
	<id>$entry_id</id>
	<parent>
		<id>$entry_id</id>
	</parent>
	<count>0</count>
</commentlist>

EOD;
		file_put_contents($commentlist_file_name,$cl_dat);


	}

$el_all=<<<EOD
<?xml version="1.0" encoding="UTF-8" ?>
<entrylist>
	<id>$thread_id</id>
	<count>$entry_count</count>
	<parent>
	<id>$project_cd</id>
	</parent>
	<title>thread_title</title>
$el_dat
</entrylist>
EOD;
	$entrylist_file_dir = $DEST_OPEN_DIR.'home/'.$project_cd.'/data/blog/'.$thread_id.'/';
	$entrylist_file_name = $entrylist_file_dir.'entrylist.xml';
	file_put_contents($entrylist_file_name,$el_all);
//	print($el_all);
	return $import_list;
}


?>
