<?php
/*
 * $Id: newthread.done.php,v 1.2 2004/07/21 15:41:42 fukami Exp $
 * 画像(gazo)スレッド新規作成
 *
 */

require_once('class/xml.class.php');
require_once('class/publogxmldata.class.php');
require_once('class/publogxmllistdata.class.php');
require_once('class/projectdata.class.php');
require_once('class/threadlistdata.class.php');
require_once('class/threaddata.class.php');


//require_once('class/publogdata.class.php');
require_once('mod/thread/gazo/gazodata.class.php');
require_once('mod/thread/gazo/gazo.func.php');

function do_mod_proc_disp()
{
	global $vars,$retvars;
	global $smes,$pmes;
	global $logindat,$prjdat,$userdat;
	require_once('func/ita.func.php');
	extract($vars);

	if($thread_title==""){
		error_exit("スレッドタイトルが空白です");
	}
	if(strlen($thread_comment) > BLOG_COMMENT_MAX_STRLEN_1){
		error_exit("スレッド説明が長すぎます");
	}
	if(strlen($name) > NAME_MAX_STRLEN){
		error_exit("名前が長すぎます");
	}
	if(strlen($thread_title) > THREADTITLE_MAX_STRLEN){
		error_exit("スレタイトルが長すぎます");
	}
	if(""!=$thread_id && !ereg("^[a-zA-Z0-9]+$", $thread_id)){
		error_exit("スレッドIDに使えない文字が含まれています");
	}
	if(strlen($thread_id)>THREADID_MAX_STRLEN){
		error_exit("スレッドID長すぎです");
	}

	$name=mb_convert_encoding($name,"UTF-8","auto");
	$thread_comment=mb_convert_encoding($thread_comment,"UTF-8","auto");
	$thread_title=mb_convert_encoding($thread_title,"UTF-8","auto");

	// クッキー書き込み
	header("Set-Cookie: FROM=".$name."; expires=Fri, 31-Dec-2030 23:59:59; path=/;");


	$name=strip_tags($name);
	$thread_comment=htmlspecialchars($thread_comment);
	$thread_title=htmlspecialchars($thread_title);

	$thread_comment=nl2br($thread_comment);

	$name=ereg_replace("[\t\n\r]","",$name);
	$thread_comment=ereg_replace("[\t\n\r]","",$thread_comment);
	$thread_title=ereg_replace("[\t\n\r]","",$thread_title);


	if(""==$thread_id)
	{
		// thread_idを新規生成
		$thread_id=base_convert(time(),10,36);
	}
	$name_list=sep_name_trip10($name);	// name, trip
	$now = now_w3c();


	// データオブジェクト ====================
	$publogdata_conf = array(
				'project' => array(
					'cd' => $prjdat['cd']
				),
				'thread' => array(
					'id' => $thread_id
				),
				'xml_file' => array(
					'sys_dir' => SYS_DIR,
					'base_dir' => APATH_HOME_DIR,
					'script_dir' => APATH_SCRIPT_DIR
				)
			);
	$publogdata = new GazoData($publogdata_conf);
/*
	// スレッドリストデータに追加 -----------
	$conf_threadlist = array(
		'xml_file' => array(
			'full_path' =>  APATH_HOME_DIR.$prjdat['cd'].'/sys/data/thread/threadlist.xml'
		),
		'data_template' => array(
			'full_path' => APATH_SCRIPT_DIR.'mod/thread/blog/xml_templates/threadlist_xml.tpl'
		)
	);
*/

	$ini_threadlist = array(
		'threadlist' => array(
			'id' => 'default',
			'parent' => array(
				'id' => $prjdat['cd']
			),
			'count' => 1,
			'thread' => array(
				'id' => $thread_id,
				'type' => 'gazo',
				'language' => LANG,
				'title' => $thread_title,
				'tagline' => mb_convert_encoding($thread_comment,'UTF-8',PUBLOG_INTERNAL_ENCODING),
				'issued' => $now,
				'modified' => $now,
				'author' => array(
						'name' => $name_list['name'],
						'trip' => $name_list['trip']
				)
			)
		)
	);
	$threadlist =& $publogdata->create('threadlist');
	if($threadlist->load('threadlist'))
	{
		$threadlist->add($ini_threadlist['threadlist']['thread']);
		$threadlist->_save();
	}else{
		$threadlist->new_xml_file($ini_threadlist);
	}

	if(!file_exists(APATH_HOME_DIR.$prjdat['cd'].'/data/gazo/'.$thread_id))
	{
		check_dir(APATH_HOME_DIR.$prjdat['cd'].'/data/gazo/'.$thread_id);
		mkdir(APATH_HOME_DIR.$prjdat['cd'].'/data/gazo/'.$thread_id, 0707);
	}
	
	// gazo.ini ファイルコピー
	check_dir(APATH_HOME_DIR.$prjdat['cd'].'/data/gazo/'.$thread_id);
	copy(APATH_SCRIPT_DIR.'mod/thread/gazo/default/gazo.ini', APATH_HOME_DIR.$prjdat['cd'].'/data/gazo/'.$thread_id.'/gazo.ini');
	chmod(APATH_HOME_DIR.$prjdat['cd'].'/data/gazo/'.$thread_id.'/gazo.ini',0707);
	$wif = new WriteIniFile(APATH_HOME_DIR.$prjdat['cd'].'/data/gazo/'.$thread_id.'/gazo.ini',true,true);
	$ini_data = array(
		'ini' => array(
			'title' => $thread_title,
			'tagline' => $thread_comment,
			'home' => 'http://'.$prjdat['homeurl']
		)
	);
	// gazo.ini ファイル初期化
	$wif->write_ini_file($ini_data);

	Gazo::mod_init($prjdat['cd'],$thread_id);
	Gazo::init($prjdat['cd'],$thread_id);

	// スレッドデータを新規作成 -----------

	$ini_thread = array(
		'thread' => array(
			'id' => $thread_id,
			'parent' => array(
				'id' => $prjdat['cd']
			),
			'title' => $thread_title,
			'tagline' => mb_convert_encoding($thread_comment,'UTF-8',PUBLOG_INTERNAL_ENCODING),
			'type' => 'gazo',
			'language' => LANG,
			'issued' => $now,
			'modified' => $now,
			'author' => array(
					'name' => $name_list['name'],
					'trip' => $name_list['trip']
			)
		)
	);
//	$thread =& new PublogXMLData($conf_thread);
	$thread =& $publogdata->create('thread');
	$thread->new_xml_file($ini_thread);


	// ページ更新
	Gazo::updatelog();


	$retvars['main_tpl']='thread_main.tpl';

	return;
}
?>
