<?
// publog.php
// パブログメイン

/*

■引数
prj : プロジェクトコード 
trd : スレッドＩＤ 
res : レスＩＤ 
lv : レベル(level:project,thread,res) 
mod : モジュール 
cmd : コマンド 
trans : 画面遷移(transition) 
tty : スレッドタイプ 
ln : 言語 
ie : 入力エンコード 
oe : 出力エンコード 

■base レベルモジュール(標準)
-login
-logout
-basic
 -trip : トリップ生成表示
 -phpinfo : phpinfo() の出力
 -ver : PUBLOG バージョン表示

-user
 -upd
 -del


■project レベルモジュール(標準)
-menu : プロジェクトツールメインメニュー

-project : プロジェクト管理
 -new
 -upd
 -del
 -list

-thread: スレッド管理ツール
 -new
 -upd
 -rmthread
 -rmthreadlump
 -rmres

-file : ファイルエディター(ファイル管理)
 -main
 -new
 -mkdir
 -cd
 -upd
 -rm
 -rmdir
 -mv
 -mvdir
 -upload

-staff : スタッフツール(スタッフ管理)
 -admit
 -new
 -upd
 -del
 -quereset
 -list

-design : デザインテーマの管理
 -change
 
|-desk : デスクツール(スレッド管理)
| -menu
| -resupd
| -resdel
| -trdupd
| -trddel
| -trdlump : まとめてスレッド削除


■thread レベルモジュール
●blog スレッドタイプ

-new : 新規レス投稿 
-upd : 投稿済レス再編集 
-del : レス削除 


---------------------
■project 操作コマンド

login:ログイン 
logout:ログアウト 
new:新プロジェクト作成 
edit:プロジェクト情報編集 

■thread 操作コマンド
new:新規スレッド作成 
edit:スレッド編集 
del:スレッド削除 

cmd 一覧(スレッド操作コマンド) 

tty=blog 
new:新規レス投稿 
edit:投稿済レス再編集 
del:レス削除 

*/

// ユーザー設定ファイル
$conf=parse_ini_file('publog_conf.ini',TRUE);
// 設定ファイル def 系
require_once("publog_def.ini");
// Smarty
// Smartyライブラリを読み込む
if(!file_exists(SMARTY_CLASS_FILE))
{
	require_once('Smarty.class.php');
}else{
	require_once(SMARTY_CLASS_FILE);
}
require_once("class/smarty.class.php");

// PUBLOG システム関数
require_once("func/mod.func.php");
require_once("func/error.func.php");
require_once("func/login.func.php");
require_once("func/project.func.php");
require_once("func/staff.func.php");
require_once("func/trip.func.php");
require_once("func/file.func.php");
require_once("func/html.func.php");
require_once("func/std.func.php");
require_once("func/publog.func.php");
require_once("func/ini.func.php");
require_once("func/base.func.php");

// include 配列
require_once('tpl/project/staff/authority.inc.php');

//////////
// global な変数たち

// login データセット
// user --- handle, email, authority, tripkey
// prj --- cd, name, exp, cat, status, homeurl
$logindat=array();
$prjdat=array();
$userdat=array();
// system データセット
$sysdat=array();
init_sysdat();

// メッセージデータ(言語メッセージ)
$smes=array();	// system message
$pmes=array();	// mod message

// ユーザーに戻す出力画面のデータ
// ret - title, body, header
$retvars=array();
$retvars['print']=true;
$retvars['body']="";
$retvars['usetpl']=true;
$retvars['tpl_enc']=PUBLOG_TPL_ENCODING;

// Smarty
$systpl = new Publog_Smarty;

// ファイルのエンコーディング
$file_enc=PUBLOG_FILE_ENCODING;


/////////////////////////////////////////////////
// 外部からくる変数をサニタイズ
$get    = psanitize($_GET);
$post   = psanitize($_POST);
$cookie = psanitize($_COOKIE);

// QUERY_STRINGを取得
// また、URI を urlencode せずに手打ちで入力した場合に対処する為
$arg = '';
if ($_SERVER['QUERY_STRING'] != '')
{
	$arg = $_SERVER['QUERY_STRING'];
}
else if (array_key_exists(0,$_SERVER['argv']))
{
	$arg = $_SERVER['argv'][0];
}

// サニタイズ (\0 除去)
$arg = psanitize($arg);

// URI 手打の場合、コード変換し、get[] に上書き
// mb_convert_variablesのバグ(?)対策 配列で渡さないと落ちる
$arg = array($arg);
mb_convert_variables(PUBLOG_INTERNAL_ENCODING,'auto',$arg);
$arg = $arg[0];

foreach (explode('&',$arg) as $tmp_string)
{
	if (preg_match('/^([^=]+)=(.+)/',$tmp_string,$matches)
		and mb_detect_encoding($matches[2]) != 'ASCII')
	{
		$get[$matches[1]] = $matches[2];
	}
}

$vars = array_merge($post,$get);
if(!empty($vars['lv'])) $vars['lv']=strip_tags($vars['lv']);
if(!empty($vars['mod'])) $vars['mod']=strip_tags($vars['mod']);
if(!empty($vars['cmd'])) $vars['cmd']=strip_tags($vars['cmd']);
if(!empty($vars['trans'])) $vars['trans']=strip_tags($vars['trans']);


// モジュール
if (!empty($vars['mod'])) {
	if (!exist_mod_action($vars['lv'],$vars['mod'])) {
		$s_mod = htmlspecialchars($vars['mod']);
		$msg = "mod=$s_mod is not implemented.";
		error_exit($msg);
	} else {
		$ret = do_mod_action($vars['lv'],$vars['mod']);
		if ($ret !== FALSE) {
			$base = array_key_exists('refer',$vars) ? $vars['refer'] : '';
		}
	}
}

header('Content-Type: text/html; charset='.PUBLOG_MIME_CHARSET);

// 画面作成
if($retvars['usetpl'])
{
	fetch_mod_tpl();

}
// 画面出力
print($retvars['body']);
flush();
exit;

?>
