<?php
/**
 * @author     lunt
 * @license    http://www.gnu.org/licenses/gpl.html GPL 2
 * @version    $Id: monobook_getlink.inc.php 120 2007-02-24 01:35:14Z lunt $
 */

function plugin_monobook_getlink($p_name, $message, $check_selected = FALSE)
{
	global $vars, $_LINK;
	global $do_backup, $function_freeze, $referer, $trackback, $defaultpage, $whatsnew, $help_page;
	static $cmd, $page, $is_page, $is_editable, $is_freeze;
	
	if (empty($cmd)) {
		$cmd = empty($vars['cmd']) ? $vars['plugin'] : $vars['cmd'];
		$page = empty($vars['page']) ? '' : $vars['page'];
		$is_page = is_page($vars['page']);
		$is_editable = is_editable($vars['page']);
		$is_freeze = is_freeze($vars['page']);
	}
	
	if ($p_name === 'special') {
		if ($cmd !== 'attach') {
			$p_name = $cmd;
		} elseif ($vars['pcmd'] === 'upload') {
			$p_name = 'upload';
		} elseif (empty($vars['refer'])) {
			$p_name = 'attachlistall';
		} else {
			$p_name = 'attachlist';
		}
	}
	
	$link = $title = '';
	$selected = 0;
	switch ($p_name) {
		case 'add' :
		case 'edit' :
			if (! PKWK_READONLY && $page && $is_editable) {
				$link = $_LINK[$p_name];
				$title = $message[$p_name];
			}
			break;
		
		case 'attach' :
		case 'upload' :
			if (! PKWK_READONLY && (bool)ini_get('file_uploads') && $is_page && $is_editable) {
				$link = $_LINK['upload'];
				$title = $message['upload'];
				if ($cmd === 'attach' && $vars['pcmd'] === 'upload') $selected = 1;
			}
			break;
		
		case 'attachlist' :
			if ($page) $link = get_script_uri() . '?plugin=attach&amp;pcmd=list&amp;refer=' . $page;
			elseif ($cmd === 'attach' && ! empty($vars['refer'])) {
				$link = get_script_uri() . strrchr($_SERVER['REQUEST_URI'], '?');
				$selected = 1;
			}
			$title = $message['attachlist'];
			break;
		
		case 'attachlistall' :
			$link = get_script_uri() . '?plugin=attach&amp;pcmd=list';
			$title = $message['attachlistall'];
			if ($cmd === 'attach' && empty($vars['refer'])) $selected = 1;
			break;
		
		case 'backlink' :
		case 'related' :
			if ($page) {
				$link = get_script_uri() . '?plugin=related&amp;page=' . rawurlencode($page);
				$title = $message['related'];
			}
			$p_name = 'related';
			break;
		
		case 'backup' :
			if ($do_backup && $page) {
				$link = $_LINK['backup'];
				$title = $message['backup'];
			}
			break;
		
		case 'copy' :
		case 'template' :
			if (PKWK_READONLY || ! $is_page) break;
			if ($page) $link = $_LINK['copy'];
			elseif ($cmd === 'template') {
				$link = get_script_uri() . strrchr($_SERVER['REQUEST_URI'], '?');
				$selected = 1;
			}
			$title = $message['copy'];
			break;
		
		case 'diff' :
		case 'reload' :
			if ($page) {
				$link = $_LINK[$p_name];
				$title = $message[$p_name];
			}
			break;
		
		case 'filelist' :
		case 'help' :
		case 'list' :
		case 'rdf' :
		case 'recent' :
		case 'rss' :
		case 'rss10' :
		case 'rss20' :
		case 'search' :
		case 'top' :
			$link = $_LINK[$p_name];
			$title = $message[$p_name];
			break;
		
		case 'freeze' :
		case 'unfreeze' :
			if (PKWK_READONLY || ! $function_freeze || ! $is_page || ! $page) break;
			if ($is_freeze) {
				$link = $_LINK['unfreeze'];
				$p_name = 'unfreeze';
			} else {
				$link = $_LINK['freeze'];
				$p_name = 'freeze';
			}
			$title = $message[$p_name];
			break;
		
		// for $p_name = 'special'
		case 'read' :
			$link = $_LINK['reload'];
			$title = $message['article'];
			break;
		
		case 'refer' :
		case 'referer' :
			if ($referer && $page) {
				$link = $_LINK['refer'];
				$title = $message['refer'];
			}
			$p_name = 'referer';
			break;
		
		case 'new' :
		case 'newpage' :
			if (! PKWK_READONLY) {
				$link = $_LINK['new'];
				$title = $message['new'];
			}
			$p_name = 'newpage';
			break;
		
		case 'rename' :
			if (PKWK_READONLY || ! $is_page) break;
			if ($page && $is_editable) $link = $_LINK['rename'];
			elseif (! $page && $cmd === 'rename' && ! empty($vars['refer']) && is_editable($vars['refer'])) {
				$link = get_script_uri() . strrchr($_SERVER['REQUEST_URI'], '?');
			}
			$title = $message['rename'];
			break;
		
		case 'source' :
			if ($page && $is_page) {
				$link = get_script_uri() . '?cmd=source&amp;page=' . rawurlencode($page);
				$title = $message['source'];
			}
			break;
		
		case 'trackback' :
			if ($trackback && $page) {
				$link = $_LINK['trackback'];
				$title = $message['trackback'];
			}
			break;
		
		case 'yetlist' :
			if (! PKWK_READONLY) {
				$link = get_script_uri() . '?plugin=yetlist';
				$title = $message['yetlist'];
			}
			break;
	}
	
	if ($link) $link = '<a href="' . $link . '">' . $title . '</a>';
	
	if (! $check_selected) return $link;
	
	if (($cmd !== 'attach' && $cmd !== 'template' && $cmd === $p_name) ||
		($page === $defaultpage && $p_name === 'top') ||
		($page === $whatsnew && $p_name === 'recent') ||
		($page === $help_page && $p_name === 'help'))
			$selected = 1;
	
	return array($link, $selected);
}
?>
