<?php
/**
 * CSS Style Plugin
 *  
 * @author     sonots <http://note.sonots.com>
 * @license    http://www.gnu.org/licenses/gpl.html    GPL
 * @link       http://note.sonots.com/?PukiWiki/style.inc.hp
 * @version    $Id: style.inc.php 442 2007-02-17 03:23:04Z sonots $
 * @package    style.inc.php
 */

function plugin_style_convert()
{
    $args = func_get_args();
    $end = end($args);
    if (substr($end, -1) == "\r") {
        $body = array_pop($args);
    }
    $options = array(
        'style' => '',
        'class' => '',
        'end'   => FALSE,
    );
    foreach ($args as $arg) {
        list($key, $val) = array_pad(explode('=', $arg, 2), 2, TRUE);
        if (isset($options[$key])) {
            $options[$key] = $val;
        }
    }
    if ($options['end']) return '</div>';
    $options['style'] = htmlspecialchars($options['style']);
    $options['class'] = htmlspecialchars($options['class']);

    $ret = '<div';
    $ret .= ($options['class'] != '') ? ' class="' . $options['class'] . '"' : '';
    $ret .= ($options['style'] != '') ? ' style="' . $options['style'] . '"' : '';
    $ret .= '>';

    if (isset($body)) {
        $body = str_replace("\r", "\n", $body);
        $body = convert_html($body);
        $ret .= "\n" . $body;
        $ret .= '</div>';
    }
    return $ret;
}
?>
