<?php
/**
 *  Tag Plugin
 *
 *  @author     sonots
 *  @license    http://www.gnu.org/licenses/gpl.html    GPL
 *  @link       http://note.sonots.com/?PukiWiki/tag.inc.php
 *  @version    $Id: tag.inc.php 459 2007-02-19 18:22:47Z sonots $
 *  @package    PluginTag
 */

class PluginTag
{
    ////// clean caches /////
    function action()
    {
        set_time_limit(0);
        global $vars;
        $body = '';
        //$deleted = $this->clean_pagecaches();
        //if (! empty($deleted)) {
        //    $body .= '<p>Following pages did not exist actually:</p>';
        //    $body .= '<p>' . implode("<br />\n", $deleted) . '</p>';
        //}
        $files = $this->get_existtagcaches();
        $files = array_merge($files, $this->get_existpagecaches());
        $files = array_merge(array_keys($files), array('tagcloud.tag'));
        foreach ($files as $file) {
            unlink(CACHE_DIR . $file);
        }
        $execed = $this->exec_existpages();
        if (! empty($execed)) {
            $body .= '<p>Following pages were executed to assure:</p>';
            $links = array_map('make_pagelink', $execed);
            $body .= '<p>' . implode("<br />\n", $links) . '</p>';
        }
        $body .= $this->view_tagcloud(NULL);
        return array('msg'=>'clean tag caches', 'body'=>$body);
    }
    
    function clean_pagecaches()
    {
        $pages = $this->get_existpagecaches();
        $deleted = array();
        foreach ($pages as $page) {
            if (is_page($page)) continue;
            $this->tagging($page, array());
            $deleted[] = $page;
        }
        return $deleted;
    }

    function exec_existpages()
    {
        $pages = get_existpages();
        $execed = array();
        global $vars, $get, $post;
        $tmp = $vars['page'];
        foreach ($pages as $page) {
            $vars['page'] = $get['page'] = $post['page'] = $page;
            $lines = get_source($page);
            $lines = preg_grep('/&tag\([^;]*\);/', $lines);
            if (! empty($lines)) {
                convert_html($lines);
                $execed[] = $page;
            }
        }
        $vars['page'] = $get['page'] = $post['page'] = $tmp;
        return $execed;
    }

    ////// tag cloud ////////
    function convert()
    {
        // option
        if (func_num_args() == 0) {
            $limit = 20;
        } else {
            $args = func_get_args();
            $limit = array_shift($args);
        }

        return $this->view_tagcloud($limit);
    }
    
    function view_tagcloud($limit = NULL)
    {
        $cloud_p = new TagCloud();
        $cloud_d = $this->read_tagcloud();//$limit);
        foreach ($cloud_d as $key => $val) {
            list($tag, $count) = $val;
            $url = get_script_uri() . '?' . 'cmd=lsx&amp;tag=' 
                . rawurlencode($tag);
            $cloud_p->add(htmlspecialchars($tag), $url, $count);
        }
        return $cloud_p->html($limit);
    }

    ////// tagging  ////////
    function inline()
    {
        if (func_num_args() == 0){
            return 'tag(): no argument(s). ';
        }
        global $vars, $defaultpage; 
        $page = isset($vars['page']) ? $vars['page'] : $defaultpage;
        $args = func_get_args(); array_pop($args); $tags = $args;

        if ($this->is_page_new($page)) {
            $error = $this->tagging($page, $tags);
            if (isset($error)) return $error;
        }
        return $this->view_tagging($tags);
    }

    function view_tagging($tags)
    {
        $tags = $this->get_uniqtags($tags);
        $ret = '<span class="tag">';
        $ret .= 'Tag: ';
        foreach ($tags as $tag) {
            $ret .= '<a href="' . get_script_uri() . '?cmd=lsx&amp;tag=' 
                . rawurlencode($tag) . '">' . htmlspecialchars($tag) . '</a> ';
        }
        $ret .= '</span>';

        global $head_tags;
        $head_tags[] = ' <meta name="keywords" content="' . 
            htmlspecialchars(implode(', ', $tags)) . '" />';

        return $ret;
    }

    function tagging($page, $tags)
    {
        if (! $this->check_tagnames($tags))
            return 'tag(): tag names are illegal. Do not use ^ and -. ';

        $oldtags = $this->read_pagecache($page);
        // renew pagecache
        if(($tags = $this->write_pagecache($page, $tags)) === FALSE) {
            return "tag(): Failed to renew cache for page $page.";
        }

        // renew tagcaches and tagcloud
        list($dels, $adds) = $this->my_array_diff($oldtags, $tags);
        $tagcloud = $this->read_tagcloud();
        foreach ($dels as $tag) {
            $pages = $this->read_tagcache($tag);
            $pages = array_diff($pages, array($page));
            if (($pages = $this->write_tagcache($tag, $pages)) === FALSE) {
                return "tag(): Failed to delete $page from cache for tag $tag. ";
            }
            $tagcloud[$this->get_tagkey($tag)] = array($tag, sizeof($pages));
        }
        foreach ($adds as $tag) {
            $pages = $this->read_tagcache($tag);
            $pages = array_unique(array_merge($pages, array($page)));
            if (($pages = $this->write_tagcache($tag, $pages)) === FALSE) {
                return "tag(): Failed to add $page from cache for tag $tag. ";
            }
            $tagcloud[$this->get_tagkey($tag)] = array($tag, sizeof($pages));
        }
        if ($this->write_tagcloud($tagcloud) === FALSE) {
            return "tag(): failed to write tag cloud cache. ";
        }
    }

    function get_taggedpages($tagtok = '')
    {
        $tags = array();
        $ops  = array();
        while (true) {
            $intersectpos = strpos($tagtok, '^');
            $diffpos      = strpos($tagtok, '-');
            if ($intersectpos === FALSE && $diffpos === FALSE) {
                break;
            } elseif ($diffpos === FALSE || $intersectpos < $diffpos) {
                $pos = $intersectpos;
                array_push($ops, 'intersect');
            } else {
                $pos = $diffpos;
                array_push($ops, 'diff');
            }
            array_push($tags, substr($tagtok, 0, $pos));
            $tagtok = substr($tagtok, $pos + 1);
        }
        array_push($tags, $tagtok);

        $tag = array_shift($tags);
        $pages = $this->read_tagcache($tag);
        foreach ($tags as $i => $tag) {
            $intersect  = array_intersect($pages, $this->read_tagcache($tag));
            switch ($ops[$i]) {
            case 'intersect':
                $pages = $intersect;
                break;
            case 'diff':
                $pages = array_diff($pages, $intersect);
                break;
            }
        }
        return $pages;
    }
    
    function read_tagcloud($limit = NULL)
    {
        $cache = CACHE_DIR . 'tagcloud.tag';
        if (! file_exists($cache)) return array();
        
        //if (isset($limit))
        //$lines = file_head($cache, $limit); // pukiwiki API
        //else 
        $lines = file($cache);
        
        if ($lines === FALSE) return array();
        $lines = array_map('rtrim', $lines);
        
        $tagcloud = array();
        foreach ($lines as $line) {
            list($tag, $count) = explode("\t", $line);
            $key = $this->get_tagkey($tag);
            $tagcloud[$key] = array($tag, $count);
        }
        return $tagcloud;
    }

    function write_tagcloud($tagcloud)
    {
        $cache = CACHE_DIR . 'tagcloud.tag';
        $contents = '';
        $tag_counts = array();
        ksort($tagcloud);
        foreach ($tagcloud as $key => $val) {
            list($tag, $count) = $val;
            if ($count == 0) continue;
            $contents .= $tag . "\t" . $count . "\n";
        }
        return $this->file_put_contents($cache, $contents);
    }

    function check_tagnames($tags)
    {
        // '^' and '-' are reserved keys. 
        foreach ($tags as $tag) {
            if (strpos($tag, '^') !== FALSE) return FALSE;
            elseif (strpos($tag, '-') !== FALSE) return FALSE;
        }
        return TRUE;
    }

    function write_pagecache($page, $tags)
    {
        $pagecachename = $this->get_pagecachename($page);
        $tags = $this->get_uniqtags($tags); // for safe
        if (empty($tags)) {
            if (file_exists($pagecachename)) {
                return unlink($pagecachename) ? $tags : FALSE;
            } else {
                return $tags;
            }
        }
        $contents = implode("\n", $tags) . "\n";
        return $this->file_put_contents($pagecachename, $contents) 
            ? $tags : FALSE;
    }
    function write_tagcache($tag, $pages)
    {
        $tagcachename = $this->get_tagcachename($tag);
        foreach ($pages as $i => $page) {
            if (! is_page($page)) unset($pages[$i]); // for safe
        }
        if (empty($pages)) {
            if (file_exists($tagcachename)) {
                return unlink($tagcachename) ? $pages : FALSE;
            } else {
                return $pages;
            }
        }
        $contents = implode("\n", $pages) . "\n";
        return $this->file_put_contents($tagcachename, $contents)
            ? $pages : FALSE;
    }

    function read_pagecache($page)
    {
        $pagecachename = $this->get_pagecachename($page);
        if (! file_exists($pagecachename)) return array();
        $tags = array_map('rtrim', file($pagecachename));
        return $tags;
    }

    function read_tagcache($tag)
    {
        $tagcachename = $this->get_tagcachename($tag);
        if (! file_exists($tagcachename)) return array();
        $pages = array_map('rtrim', file($tagcachename));
        return $pages;
    }

    function get_uniqtags($tags)
    {
        $uniqtags = array();
        foreach ($tags as $tag) {
            $uniqtags[$this->get_tagkey($tag)] = $tag;
        }
        if (isset($uniqtags[''])) unset($uniqtags['']);
        return array_values($uniqtags);
    }

    function get_tagkey($tag)
    {
        // if (extension_loaded('mbstring'))
        if (function_exists('mb_strtolower')) { 
            return mb_strtolower($tag, SOURCE_ENCODING);
        } else{
            return $tag;
        }
    }

    function get_existtagcaches()
    {
        return get_existpages(CACHE_DIR, '_tag.tag');
    }

    function get_existpagecaches()
    {
        return get_existpages(CACHE_DIR, '_page.tag');
    }

    function get_tagcachename($tag)
    {
        $key = $this->get_tagkey($tag);
        return  CACHE_DIR . encode($key) . '_tag.tag';
    }

    function get_pagecachename($page)
    {
        return CACHE_DIR . encode($page) . '_page.tag';
    }

    function is_page_new($page)
    {
        $pagestamp  = is_page($page) ? filemtime(get_filename($page)) : 0;
        $cache      = $this->get_pagecachename($page);
        $cachestamp = file_exists($cache) ? filemtime($cache) : 0;
        return $pagestamp > $cachestamp;
    }

    // PHP extension
    function my_array_diff(&$oldarray, &$newarray)
    {
        $common = array_intersect($oldarray, $newarray);
        $minus  = array_diff($oldarray, $common);
        $plus   = array_diff($newarray, $common);
        return array($minus, $plus);
    }

    // PHP5.0 has file_put_contents($file, $contents),  though
    function file_put_contents($file, $contents)
    {
        if (($fp = fopen($file, "w")) === FALSE) {
            return FALSE;
        }
        if (fwrite($fp, $contents) === FALSE) {
            fclose($fp);
            return FALSE;
        } 
        return fclose($fp);
    }
}

////////////////////////////////
/**
 * Generate An HTML Tag Cloud
 * @author astronote <http://astronote.jp/>
 */
class TagCloud
{
    var $counts;
    var $urls;
    
    function TagCloud()
    {
        $this->counts = array();
        $this->urls = array();
    }

    function add($tag, $url, $count)
    {
        $this->counts[$tag] = $count;
        $this->urls[$tag] = $url;
    }

    function css()
    {
        $css = '#htmltagcloud { text-align: center; line-height: 16px; }';
        for ($level = 0; $level <= 24; $level++) {
            $font = 12 + $level;
            $css .= "span.tagcloud$level { font-size: ${font}px;}\n";
            $css .= "span.tagcloud$level a {text-decoration: none;}\n";
        }
        return $css;
    }

    function html($limit = NULL)
    {
        $a = $this->counts;
        arsort($a);
        $tags = array_keys($a);
        if (isset($limit)) {
            $tags = array_slice($tags, 0, $limit);
        }
        $n = count($tags);
        if ($n == 0) {
            return '';
        } elseif ($n == 1) {
            $tag = $tags[0];
            $url = $this->urls[$tag];
            return "<div class=\"htmltagcloud\"><span class=\"tagcloud1\"><a href=\"$url\">$tag</a></span></div>\n"; 
        }
        
        $min = sqrt($this->counts[$tags[$n - 1]]);
        $max = sqrt($this->counts[$tags[0]]);
        $factor = 0;
        
        // specal case all tags having the same count
        if (($max - $min) == 0) {
            $min -= 24;
            $factor = 1;
        } else {
            $factor = 24 / ($max - $min);
        }
        $html = '';
        sort($tags);
        foreach($tags as $tag) {
            $count = $this->counts[$tag];
            $url   = $this->urls[$tag];
            $level = (int)((sqrt($count) - $min) * $factor);
            $html .=  "<span class=\"tagcloud$level\"><a href=\"$url\">$tag</a></span>\n"; 
        }
        $html = "<div class=\"htmltagcloud\">$html</div>";
        return $html;
    }

    function htmlAndCSS($limit = NULL)
    {
        $html = "<style type=\"text/css\">\n" . $this->css() . "</style>" 
            . $this->html($limit);
        return $html;
    }
}
/* test
$tags = array(
    array('tag' => 'blog', 'count' => 20),
    array('tag' => 'ajax', 'count' => 10),
    array('tag' => 'mysql', 'count'  => 5),
    array('tag' => 'hatena', 'count'  => 12),
    array('tag' => 'bookmark', 'count'  => 30),
    array('tag' => 'rss', 'count' => 1),
    array('tag' => 'atom', 'count' => 2),
    array('tag' => 'misc', 'count' => 10),
    array('tag' => 'javascript', 'count' => 11),
    array('tag' => 'xml', 'count' => 6),
    array('tag' => 'perl', 'count' => 32),
);

$cloud = new TagCloud();
foreach ($tags as $t) {
    $cloud->add($t['tag'], "http://<your.domain>/{$t['tag']}/", $t['count']);
}
print "<html><body>";
print $cloud->htmlAndCSS(20);
print "</body></html>";
*/

////////////////////////////////
function plugin_tag_init()
{
    global $plugin_tag;
    if (class_exists('PluginTagUnitTest')) {
        $plugin_tag = new PluginTagUnitTest();
    } elseif (class_exists('PluginTagUser')) {
        $plugin_tag = new PluginTagUser();
    } else {
        $plugin_tag = new PluginTag();
    }
}

function plugin_tag_inline()
{
    global $plugin_tag;
    $args = func_get_args();
    return call_user_func_array(array($plugin_tag, 'inline'), $args);
}

function plugin_tag_convert()
{
    global $plugin_tag;
    $args = func_get_args();
    return call_user_func_array(array($plugin_tag, 'convert'), $args);
}

function plugin_tag_action()
{
    global $plugin_tag;
    return call_user_func(array($plugin_tag, 'action'));
}

?>
