<?php
/**
 *  $Id: wikinote.inc.php 365 2007-01-25 21:02:13Z sonots $
 *  Wikipedia-like Note(Discussion) Plugin
 *
 *  @author     sonots
 *  @licence    http://www.gnu.org/licenses/gpl.html    GPL
 *  @link       http://note.sonots.com/?PukiWiki/wikinote.inc.php
 */

class PluginWikinote
{
    var $error   = '';
    var $plugin  = 'wikinote';
    var $options;
    var $dflt_options; // static
    var $def_wikinote;
    var $def_void;
    var $default_template_contents = "#comment\n";

    function PluginWikinote($args)
    {
        // Modify here for default values
        static $dflt_options = array();
        if (empty($dflt_options)) {
            $dflt_options['prefix']    = 'Note/';
            $dflt_options['except']    = '^$';
            $dflt_options['noauto']    = FALSE;
        }
        global $non_list;
        global $whatsnew;
        global $whatsdeleted;
        global $interwiki;
        global $menubar;
        global $sidebar;
        global $headarea;
        global $footarea;
        $this->def_void = $non_list . 
            '|^' . $whatsnew     . '$' .
            '|^' . $whatsdeleted . '$' .
            '|^' . $interwiki    . '$' .
            '|^' . $menubar      . '$' .
            '|(^|\/)template$' .         // i'm lazy
            '|^' . $sidebar      . '$' . // pukiwiki plus
            '|^' . $headarea     . '$' .
            '|^' . $footarea     . '$' .
            '|^' . 'Navigation'  . '$' .
            '|^' . 'Glossary'    . '$';
        // until here

        $this->dflt_options = & $dflt_options;
        $this->options = $this->dflt_options;
        $this->parse_options($args);
        $this->autocreate_wikinote();
    }
    // public
    function is_valid($page = '')
    {
        global $vars;
        $page = ($page === '') ? $vars['page'] : $page;
        static $is_valid = array();
        if (! isset($is_valid[$page])) {
            list($mainpage, $notepage) = $this->get_mainpage_notepage($page);
            if (! is_page($mainpage)) {
                $is_valid[$page] = FALSE;
            } else {
                $is_valid[$page] = ! preg_match('/' . $this->def_void . '/', $mainpage);
            }
        }
        return $is_valid[$page];
    }

    function show_links($cmds = array('main' => 'Article', 'note' => 'Comment'), $page = '')
    {
        global $vars;
        $page = ($page === '') ? $vars['page'] : $page;
        list($mainpage, $notepage) = $this->get_mainpage_notepage($page);
        $lis = array();
        foreach ($cmds as $cmd => $label) {
            $label = ($label === '') ? $cmd : $label;
            $label = make_link($label); // convert inline plugins
            switch ($cmd) {
            case 'main':
                $link  = make_pagelink($mainpage, $label);
                $selected = ($page === $mainpage) ? ' class="selected"' : '';
                break;
            case 'note':
                $link  = make_pagelink($notepage, $label);
                $selected = ($page === $notepage) ? ' class="selected"' : '';
                break;
            default:
                $href  = get_script_uri() . '?cmd=' . rawurlencode($cmd). '&amp;page=' . rawurlencode($vars['page']);
                $link = '<a href="' . $href . '">' . $label . '</a>';
                $selected = ($vars['cmd'] === $cmd) ? ' class="selected"' : '';
                break;
            }
            array_push($lis, '<li id="' . 'wn_' . htmlspecialchars($cmd) . '"' . $selected . '>' . $link . '</li>');
        }
        $html = '<ul class="wikinote">' . implode("\n", $lis) . '</ul>';
        return $html;
    }

    function is_wikinote($page = '')
    {
        global $vars;
        $page = ($page === '') ? $vars['page'] : $page;
        static $is_wikinote = array();
        if (! isset($is_wikinote[$page])) {
            $is_wikinote[$page] = preg_match('/' . $this->def_wikinote . '/', $page);
        }
        return $is_wikinote[$page];
    }

    // private
    function parse_options($args)
    {
        foreach ($args as $key => $val) {
            $this->options[$key] = $val;
        }
        if (strrpos($this->options['prefix'], '/') !== strlen($this->options['prefix']) - 1) {
            $this->options['prefix'] .= '/';
        }
        $this->def_wikinote = '^' . preg_quote($this->options['prefix'], '/') . '(.*)' . '$';
        $this->def_void     = $this->def_void . '|' . $this->options['except'];
    }


    function get_mainpage_notepage($page)
    {
        if ($this->is_wikinote($page)) {
            $notepage  = $page;
            $mainpage  = $this->get_pagename($page);
        } else {
            $mainpage  = $page;
            $notepage  = $this->get_wikinotename($page);
        }
        return array($mainpage, $notepage);
    }

    function get_wikinotename($mainpage)
    {
        return $this->options['prefix'] . $mainpage;
    }

    function get_pagename($notepage)
    {
        $matches = array();
        preg_match('/' . $this->def_wikinote . '/', $notepage, $matches);
        return $matches[1];
    }

    function autocreate_wikinote($page = '')
    {
        if ($this->options['noauto']) return;
        global $vars;
        $page = ($page === '') ? $vars['page'] : $page;
        list($mainpage, $notepage) = $this->get_mainpage_notepage($page);
        if (! $this->is_valid($mainpage)) return;
        if ($this->is_page($notepage)) return;

        $contents = auto_template($notepage);
        if ($contents == '') {
            $contents = $this->default_template_contents;
        }
        if ($this->file_put_contents(get_filename($notepage), $contents) === FALSE) {
            $this->error = "Wikinote page, $notepage, is not writable. ";
            return;
        }

        $this->update_recent($notepage);
    }

    function update_recent($mainpage = '')
    {
        if (is_page($mainpage) && function_exists('lastmodified_add')) {
            lastmodified_add($mainpage); // 1.4.7 or higher
        } elseif (function_exists('put_lastmodified')) {
            put_lastmodified();
        }
    }

    // PHP5.0 has file_put_contents($file, $contents),  though
    function file_put_contents($file, $contents)
    {
        if (($fp = fopen($file, "w")) === FALSE) {
            return FALSE;
        }
        if (fwrite($fp, $contents) === FALSE) {
            fclose($fp);
            return FALSE;
        } 
        return fclose($fp);
    }

    // Pukiwiki API
    function is_page($page)
    {
        return is_page($page);
    }

    // PHP API
    function file_get_contents($file)
    {
        return file_get_contents($file);
    }
}

?>
