////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// PB_ESTK.v
// Copyright(C) 2009 OHSAWA Naotaka. All rights reserved.
// 
// $Rev$
// $Date$
// $Author$

`include "defs.vh"

////////////////////////////////////////////////////////////////////////////////
// PB_ESTK
// Evaluation Stack
module PB_ESTK
(
        input                                  CLK,
        input                                  RSTn,

        input                                  INIT,

	// Stack Push/Pop Request
        input                                  EREQ,
        input  [`PB_ES_LBITS-1:0]              ELEN,
        input  [`PB_DS_BITS-1:0]               EWD,
        input  [`PB_DS_BITS-1:0]               EWD_1,
	
	// Stack Status & TOP Values
        output [`PB_ES_ABITS-1:0]              ENUM,
        output                                 EVF,
        output [`PB_DS_BITS-1:0]               ETOP,
        output [`PB_DS_BITS-1:0]               ETOP_1,
        output [`PB_DS_BITS-1:0]               ETOP_2,

	// Stack Control from Slave I/F
        input                                  ESREQ,
        input  [`PB_ES_ABITS-1:0]              ESA,
        output [`PB_DS_BITS-1:0]               ESRD
);

	///////////////////////////////////////////////////
	// Stack Pointer
	reg [`PB_ES_ABITS-1:0]	ptr;
	always @(posedge CLK `RST_TYPE) begin
		if(!RSTn) begin
						ptr <= {`PB_ES_ABITS{1'b0}};
		end else if(INIT) begin
						ptr <= `TPD{`PB_ES_ABITS{1'b0}};
		end else if(EREQ) begin
			case(ELEN)
			`PB_ES_LEN_PUSH:	ptr <= `TPD ptr + 'b1;
			`PB_ES_LEN_POP1:	ptr <= `TPD ptr - 'b1;
			`PB_ES_LEN_POP2:	ptr <= `TPD ptr - 'h2;
			`PB_ES_LEN_POP3_PUSH2:	ptr <= `TPD ptr - 'b1;
			`PB_ES_LEN_POP1_PUSH1:	ptr <= `TPD ptr;
			`PB_ES_LEN_SETUP_CAR:	ptr <= `TPD {{`PB_ES_ABITS-2{1'b0}}, 2'h3};
			`PB_ES_LEN_SETUP_CDR:	ptr <= `TPD {{`PB_ES_ABITS-1{1'b0}}, 1'b1};
			default:		ptr <= `TPD {`PB_ES_ABITS{1'bx}};
			endcase
		end
	end

	assign	ENUM	= ptr;

	///////////////////////////////////////////////////
	// Overflow Flag
	reg ovflow;
	always @(posedge CLK `RST_TYPE) begin
		if(!RSTn) begin
			ovflow <= 1'b0;
		end else if(INIT) begin
			ovflow <= `TPD 1'b0;
		end else if(EREQ && ELEN == `PB_ES_LEN_PUSH
				 && ptr  == {`PB_ES_ABITS{1'b1}}) begin
			ovflow <= `TPD 1'b1;
		end
	end

	assign	EVF = ovflow;

	///////////////////////////////////////////////////
	// Stack Data
	reg [`PB_DS_BITS-1:0]	stk[0:(1<<`PB_ES_ABITS)-1];
	always @(posedge CLK) begin
		if(EREQ && ELEN == `PB_ES_LEN_PUSH) begin
			stk[ptr]	<= `TPD EWD;
		end else if(EREQ && ELEN == `PB_ES_LEN_POP3_PUSH2) begin
			stk[ptr-'h2]	<= `TPD EWD;
			stk[ptr-'h3]	<= `TPD EWD_1;
		end else if(EREQ && ELEN == `PB_ES_LEN_POP1_PUSH1) begin
			stk[ptr-'h1]	<= `TPD EWD;
		end else if(EREQ && ELEN == `PB_ES_LEN_SETUP_CAR) begin
			stk['b0]	<= `TPD {`PB_DS_ZERO, `PB_DS_TAG_NUM};
			stk['b1]	<= `TPD {`PB_DS_N, `PB_DS_TAG_SYM};
			stk['h2]	<= `TPD {`PB_DS_K, `PB_DS_TAG_SYM};
		end else if(EREQ && ELEN == `PB_ES_LEN_SETUP_CDR) begin
			stk['b0]	<= `TPD {`PB_DS_ZERO, `PB_DS_TAG_CONS};
		end
	end

	assign	ETOP	= stk[ptr-'b1];
	assign	ETOP_1	= stk[ptr-'h2];
	assign	ETOP_2	= stk[ptr-'h3];

	///////////////////////////////////////////////////
	// Slave control
	assign	ESRD	= stk[ESA];

endmodule

////////////////////////////////////////////////////////////////////////////////
// END OF IMPLEMENTATION
////////////////////////////////////////////////////////////////////////////////
