////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// PB_FPM.v
// Copyright(C) 2009 OHSAWA Naotaka. All rights reserved.
// 
// $Rev$
// $Date$
// $Author$

`include "defs.vh"

////////////////////////////////////////////////////////////////////////////////
// PB_FPM
// Free Pointer management module without GC.
module PB_FPM
(
        input                                  CLK,
        input                                  RSTn,

        input                                  INIT,

	// Free Pointer request interface
        input                                  FPREQ,
        output [`PB_DS_BITS-1:0]               FPA,
        output                                 FPVF,
        input                                  FPSREQ,
        input  [`PB_DS_BITS-1:0]               FPSWD
);

	///////////////////////////////////////////////////
	// Free Pointer
	reg [`PB_DS_BITS-3:0]	fp;
	always @(posedge CLK `RST_TYPE) begin
		if(!RSTn) begin
			fp <= {`PB_DS_BITS-2{1'b0}};
		end else if(INIT) begin
			fp <= `TPD {`PB_DS_BITS-2{1'b0}};
		end else if(FPREQ) begin
			fp <= `TPD fp + 'b1;
		end else if(FPSREQ) begin
			fp <= `TPD FPSWD[`PB_DS_BITS-1:`PB_DS_TAG_BITS];
		end
	end

	assign	FPA	= {fp, `PB_DS_TAG_CONS};

	///////////////////////////////////////////////////
	// Overflow flag
	reg	overflow;
	always @(posedge CLK `RST_TYPE) begin
		if(!RSTn) begin
			overflow <= 1'b0;
		end else if(INIT) begin
			overflow <= 1'b0;
		end else if(FPREQ && fp == {`PB_DS_BITS-2{1'b1}}) begin
			overflow <= 1'b1;
		end
	end

	assign	FPVF	= overflow;


endmodule

////////////////////////////////////////////////////////////////////////////////
// END OF IMPLEMENTATION
////////////////////////////////////////////////////////////////////////////////
