////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// PUZZLE_BOX.v
// Copyright(C) 2009 OHSAWA Naotaka. All rights reserved.
// 
// $Rev$
// $Date$
// $Author$

`include "defs.vh"

////////////////////////////////////////////////////////////////////////////////
// PUZZLE_BOX
// PUZZLE_BOX CORE module.
module PUZZLE_BOX (
        input                                  CLK,
        input                                  RSTn,
        input                                  SREQ,
        input                                  SWRITE,
        input  [`PB_SI_ABITS-1:0]              SA,
        input  [`PB_SI_DBITS-1:0]              SWD,
        output [`PB_SI_DBITS-1:0]              SRD,
        output                                 MAREQ,
        input                                  MABSY,
        output                                 MAWRITE,
        output [`PB_MI_ABITS-1:0]              MAA,
        output [`PB_MI_DBITS-1:0]              MAD,
        output [`PB_MI_DBITS/8-1:0]            MAS,
        input                                  MRREQ,
        output                                 MRBSY,
        input  [`PB_MI_DBITS-1:0]              MRD,
        output                                 ISREQ,
        input                                  ISBSY,
        input                                  ISLAST,
        input  [`PB_NUM_BITS-1:0]              ISD,
        output                                 OSREQ,
        input                                  OSBSY,
        output                                 OSLAST,
        output [`PB_NUM_BITS-1:0]              OSD
);

        wire                                 INIT;
        wire                                 ESREQ;
        wire [`PB_ES_ABITS-1:0]              ESA;
        wire [`PB_DS_BITS-1:0]               ESRD;
        wire                                 FPSREQ;
        wire [`PB_DS_BITS-1:0]               FPSWD;
        wire                                 RUN;
        wire                                 LAZYK;
        wire                                 CONT;
        wire                                 SET_CDR;
        wire [`PB_DS_BITS-1:0]               SET_CDR_D;
        wire                                 BUSY;
        wire [`PB_DS_BITS-1:0]               CAR;
        wire [`PB_DS_BITS-1:0]               CDR;
        wire                                 EREQ;
        wire [`PB_ES_LBITS-1:0]              ELEN;
        wire [`PB_DS_BITS-1:0]               EWD;
        wire [`PB_DS_BITS-1:0]               EWD_1;
        wire [`PB_ES_ABITS-1:0]              ENUM;
        wire                                 EVF;
        wire [`PB_DS_BITS-1:0]               ETOP;
        wire [`PB_DS_BITS-1:0]               ETOP_1;
        wire [`PB_DS_BITS-1:0]               ETOP_2;
        wire                                 FPREQ;
        wire [`PB_DS_BITS-1:0]               FPA;
        wire                                 FPVF;
        PB_SLAVE PB_SLAVE (
                .CLK                     ( CLK ),
                .RSTn                    ( RSTn ),
                .SREQ                    ( SREQ ),
                .SWRITE                  ( SWRITE ),
                .SA                      ( SA ),
                .SWD                     ( SWD ),
                .SRD                     ( SRD ),
                .INIT                    ( INIT ),
                .RUN                     ( RUN ),
                .LAZYK                   ( LAZYK ),
                .CONT                    ( CONT ),
                .SET_CDR                 ( SET_CDR ),
                .SET_CDR_D               ( SET_CDR_D ),
                .BUSY                    ( BUSY ),
                .CAR                     ( CAR ),
                .CDR                     ( CDR ),
                .ESREQ                   ( ESREQ ),
                .ESA                     ( ESA ),
                .ESRD                    ( ESRD ),
                .ENUM                    ( ENUM ),
                .EVF                     ( EVF ),
                .FPSREQ                  ( FPSREQ ),
                .FPSWD                   ( FPSWD ),
                .FPA                     ( FPA ),
                .FPVF                    ( FPVF )
        );
        PB_LAS PB_LAS (
                .CLK                     ( CLK ),
                .RSTn                    ( RSTn ),
                .INIT                    ( INIT ),
                .RUN                     ( RUN ),
                .LAZYK                   ( LAZYK ),
                .CONT                    ( CONT ),
                .SET_CDR                 ( SET_CDR ),
                .SET_CDR_D               ( SET_CDR_D ),
                .BUSY                    ( BUSY ),
                .CAR                     ( CAR ),
                .CDR                     ( CDR ),
                .EREQ                    ( EREQ ),
                .ELEN                    ( ELEN ),
                .EWD                     ( EWD ),
                .EWD_1                   ( EWD_1 ),
                .ENUM                    ( ENUM ),
                .EVF                     ( EVF ),
                .ETOP                    ( ETOP ),
                .ETOP_1                  ( ETOP_1 ),
                .ETOP_2                  ( ETOP_2 ),
                .MAREQ                   ( MAREQ ),
                .MABSY                   ( MABSY ),
                .MAWRITE                 ( MAWRITE ),
                .MAA                     ( MAA ),
                .MAD                     ( MAD ),
                .MAS                     ( MAS ),
                .MRREQ                   ( MRREQ ),
                .MRBSY                   ( MRBSY ),
                .MRD                     ( MRD ),
                .FPREQ                   ( FPREQ ),
                .FPA                     ( FPA ),
                .FPVF                    ( FPVF ),
                .ISREQ                   ( ISREQ ),
                .ISBSY                   ( ISBSY ),
                .ISLAST                  ( ISLAST ),
                .ISD                     ( ISD ),
                .OSREQ                   ( OSREQ ),
                .OSBSY                   ( OSBSY ),
                .OSLAST                  ( OSLAST ),
                .OSD                     ( OSD )
        );
        PB_ESTK PB_ESTK (
                .CLK                     ( CLK ),
                .RSTn                    ( RSTn ),
                .INIT                    ( INIT ),
                .EREQ                    ( EREQ ),
                .ELEN                    ( ELEN ),
                .EWD                     ( EWD ),
                .EWD_1                   ( EWD_1 ),
                .ENUM                    ( ENUM ),
                .EVF                     ( EVF ),
                .ETOP                    ( ETOP ),
                .ETOP_1                  ( ETOP_1 ),
                .ETOP_2                  ( ETOP_2 ),
                .ESREQ                   ( ESREQ ),
                .ESA                     ( ESA ),
                .ESRD                    ( ESRD )
        );
        PB_FPM PB_FPM (
                .CLK                     ( CLK ),
                .RSTn                    ( RSTn ),
                .INIT                    ( INIT ),
                .FPREQ                   ( FPREQ ),
                .FPA                     ( FPA ),
                .FPVF                    ( FPVF ),
                .FPSREQ                  ( FPSREQ ),
                .FPSWD                   ( FPSWD )
        );

endmodule

////////////////////////////////////////////////////////////////////////////////
// END OF IMPLEMENTATION
////////////////////////////////////////////////////////////////////////////////
