////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// defs.vh
// Copyright(C) 2009 OHSAWA Naotaka. All rights reserved.
// 
// $Rev$
// $Date$
// $Author$

///////////////////////////////////////
// PUZZLE_BOX configurations

// 1. CAF size (16bit or 32bit)
`define PB_DS_BITS_16BIT
//`define PB_DS_BITS_32BIT


// 2. stack size (2^n)
`define PB_ES_ABITS		10




///////////////////////////////////////
// PUZZLE_BOX Internal definitions: don't touch em all.

`define TPD 			#1
`define RST_TYPE		or negedge RSTn

`define	PB_SI_ABITS		8
`define	PB_SI_DBITS		32

`ifdef PB_DS_BITS_16BIT
  `define PB_DS_BITS		16
  `define SLV_PAD_DS(X)		{{`PB_SI_DBITS-`PB_DS_BITS{1'b0}}, X}
`else
  `define PB_DS_BITS		32
  `define SLV_PAD_DS(X)		X
`endif

`define	PB_DS_TAG_BITS		2
`define	PB_DS_DBITS		(`PB_DS_BITS-`PB_DS_TAG_BITS)

`define PB_ES_LBITS		3

`define	PB_MI_ABITS		(`PB_DS_BITS-`PB_DS_TAG_BITS)
`define	PB_MI_DBITS		(`PB_DS_BITS*2)


`define PB_NUM_BITS		8






`define PB_DS_TAG_NUM		2'h0
`define PB_DS_TAG_SYM		2'h1
`define PB_DS_TAG_CONS		2'h3

`define PB_DS_S			{{`PB_DS_DBITS-4{1'b0}}, 4'h0}
`define PB_DS_K			{{`PB_DS_DBITS-4{1'b0}}, 4'h1}
`define PB_DS_I			{{`PB_DS_DBITS-4{1'b0}}, 4'h2}
`define PB_DS_L			{{`PB_DS_DBITS-4{1'b0}}, 4'h3}	// LazyRead
`define PB_DS_N			{{`PB_DS_DBITS-4{1'b0}}, 4'h4}	// Inc

`define PB_DS_ZERO		{`PB_DS_DBITS{1'b0}}

`define	PB_DS_CHURHC_NUM_256	{{`PB_DS_DBITS-9{1'b0}}, 9'h100}
`define PB_DS_CONS		{{`PB_DS_DBITS-9{1'b0}}, 9'h101}

`define PB_ES_LEN_PUSH		3'h0
`define PB_ES_LEN_POP1		3'h1
`define PB_ES_LEN_POP2		3'h2
`define PB_ES_LEN_POP3_PUSH2	3'h3
`define PB_ES_LEN_POP1_PUSH1	3'h4
`define PB_ES_LEN_SETUP_CAR	3'h5
`define PB_ES_LEN_SETUP_CDR	3'h6


////////////////////////////////////////////////////////////////////////////////
// END OF IMPLEMENTATION
////////////////////////////////////////////////////////////////////////////////
