////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// trans.h
// Copyright(C) 2009 OHSAWA Naotaka. All rights reserved.
//
// $Rev$
// $Date$
// $Author$

#ifndef _trans_h_
#define _trans_h_

#include <systemc>
#include <iostream>
#include "conf.h"

using namespace sc_core;

#ifdef PB_DS_BITS_16BIT
  typedef uint32_t	emd_t;
#else
  typedef uint64_t	emd_t;
#endif

class trans_s : public sc_module {
    public:
	sc_in_clk			CLK;

	sc_out < bool >			SREQ;
	sc_out < bool >			SWRITE;
	sc_out < uint32_t >		SA;
	sc_out < uint32_t >		SWD;
	sc_in  < uint32_t >		SRD;

    public:
	trans_s(sc_module_name n) : sc_module(n) { }
	void	end_of_elaboration(void) {
		sc_module :: end_of_elaboration();
		SREQ = false;
	}

    public:
	uint32_t read(uint32_t a);
	void     write(uint32_t a, uint32_t d);
};


class trans_m : public sc_module {
    public:
	sc_in_clk			CLK;

	sc_in  < bool >			MAREQ;
	sc_out < bool >			MABSY;
	sc_in  < bool >			MAWRITE;
	sc_in  < uint32_t >		MAA;
	sc_in  < emd_t >		MAD;
	sc_in  < uint32_t >		MAS;

	sc_out < bool >			MRREQ;
	sc_in  < bool >			MRBSY;
	sc_out < emd_t >		MRD;

    private:
	emd_t				*m_data;
	sc_fifo < emd_t >		m_fifo;

    public:
	SC_HAS_PROCESS(trans_m);
	trans_m(sc_module_name n) : sc_module(n), m_fifo("rd", 32) {
		m_data = (emd_t*)malloc(sizeof(emd_t)* (1 << PB_MEM_MAX_BITS));
		SC_THREAD(process_a);
		sensitive << CLK.pos();
		SC_THREAD(process_r);
		sensitive << CLK.pos();
	}

    public:
	emd_t& operator[] (uint32_t a) { return m_data[a]; }

    private:
	void process_a(void);
	void process_r(void);
};

class trans_is : public sc_module {
    public:
	sc_in_clk			CLK;

	sc_in  < bool >			ISREQ;
	sc_out < bool >			ISBSY;
	sc_out < bool >			ISLAST;
	sc_out < uint32_t >		ISD;

    private:
	sc_fifo < uint32_t >		m_fifo;

    public:
	SC_HAS_PROCESS(trans_is);
	trans_is(sc_module_name n) : sc_module(n), m_fifo(256) {
		SC_THREAD(proc);
		sensitive << CLK.pos();
	}

    public:
	void write(uint32_t data);

    private:
	void proc(void);
};


class trans_os : public sc_module {
    public:
	sc_in_clk			CLK;

	sc_in  < bool >			OSREQ;
	sc_out < bool >			OSBSY;
	sc_in  < bool >			OSLAST;
	sc_in  < uint32_t >		OSD;

    public:
	trans_os(sc_module_name n) : sc_module(n) { }
	void	end_of_elaboration(void) {
		sc_module :: end_of_elaboration();
		OSBSY = true;
	}

    public:
	uint32_t read(void);
};


#endif	// _trans_h_
////////////////////////////////////////////////////////////////////////////////
// END OF IMPLEMENTATION
////////////////////////////////////////////////////////////////////////////////
