<?php
// props, MVC style web application framework
//
// Copyright (C) Haruki Setoyama <props@planewave.org>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// $Id: Controller.php,v 1.5 2003/06/14 10:35:56 haruki Exp $
/**
* props, MVC style web application framework
*
* @author Haruki Setoyama  <props@planewave.org>
* @package props
**/
/**
* propsController, main Controller object
*
* @access public
**/
class propsController
{
    /**
    * $_request propsRequest object
    * $_form    propsForm object
    * @access private
    **/
    var $_request;
    var $_form;

    /**
    * constructor
    **/
    function propsController()
    {
        $this->current_module = basename(dirname($_SERVER['SCRIPT_NAME']));
    }

    /**
    * setCurrentModule()
    * @access public
    **/
    function setCurrentModule($current_module)
    {
        $this->current_module = $current_module;
    }
    var $current_module;

    /**
    * setDefaultOperation()
    * @access public
    **/
    function setDefaultOperation($op)
    {
        $this->default_operation = $op;
    }
    var $default_operation = '';

    /**
    * setOperationPrefix()
    * @access public
    **/
    function setOperationPrefix($prefix)
    {
        $this->operation_prefix = $prefix;
    }
    var $operation_prefix = '';

    /**
    * main processer
    *
    * @access public
    **/
    function process(&$request)
    {
        $this->_request =& $request;

        if(! is_dir(PROPS_OPERATION_ROOT_DIR.'/'.$this->current_module))
        {
            $this->_trigger_error(
                'readMapping()::Invalid module ('.$operation.')',
                E_USER_NOTICE
            );
            return false;
        }

        $operation = $this->_request->getParameter(PROPS_OPERATION_PARAMETER);
        if(false === $operation)
            $operation = $this->default_operation;
        else
        {
            $operation = preg_replace('[^a-zA-Z0-9_]', '', $operation);
            if($this->operation_prefix != '')
                $operation = $this->operation_prefix.'.'.$operation;
        }

        return $this->processOperation($operation);
    }

    /**
    * operation processer
    * @param string $operation
    * @access public
    * @return bool
    **/
    function processOperation($operation)
    {
        $mapping = $this->readMapping($operation);
        if($mapping === false) return false;

        return $this->processMapping($mapping);
    }

    /**
    * read the array of mapping in operation file
    * @param string $operation
    * @access public
    * @return array mapping
    **/
    function readMapping($operation)
    {
        $path = PROPS_OPERATION_ROOT_DIR.'/'.$this->current_module
                    .PROPS_OPERATION_DIRNAME.'/'.$operation.PROPS_PHP_EXT;
        if(! file_exists($path))
        {
            $this->_trigger_error(
                'readMapping()::Invalid operation ('.$operation.')',
                E_USER_NOTICE
            );
            return false;
        }
        unset($mapping);
        include($path);
        if(! isset($mapping))
        {
            $this->_trigger_error(
                'readMapping()::Invalid operation file ('.$path.')',
                E_USER_WARNING
            );
            return false;
        }
        return $mapping;
    }

    /**
    * processMapping
    * @access public
    * @return void
    **/
    function processMapping($mapping)
    {
        // propsForm
        if(isset($mapping['FORM']) && empty($this->_form))
        {
            $this->processForm($mapping['FORM']);
        }

        // COMBINATION - propsAction and propsView Combo
        if(isset($mapping['COMBINATION']))
        {
            $response = $this->processCombination($mapping['COMBINATION']);
        }
        elseif(isset($mapping['COMBINATIONS']) && isset($mapping['ASSEMBLE']))
        {
            $responses = array();
            foreach($mapping['COMBINATIONS'] as $combinaton)
            {
                $responses[] = $this->processCombination($combinaton);
            }
            $response = $this->processAssemble($mapping['ASSEMBLE'], $response);
        }
        else
        {
            $response = new propsResponse;
        }

        // propsDisplay
        if(isset($mapping['DISPLAY']))
        {
            return $this->processDisplay($mapping['DISPLAY'], $response);
        }
        else
        {
            return $this->processDisplay(array('NAME' => PROPS_DEFAULT_DISPLAY), $response);
        }
    }

    /**
    * processComponent
    * @access public
    * @return propsRespponse object
    **/
    function processCombination($mapping)
    {
        if(!isset($mapping['VIEW'])) return new propsResponse;

        if(isset($mapping['CACHE']) && isset($mapping['ACTION']))
        {
            if(!isset($mapping['ACTION']['MODULE']))
                $mapping['ACTION']['MODULE'] = $this->current_module;

            $class = $this->_load_module_class($mapping['ACTION'], PROPS_ACTION_ROOT_DIR, PROPS_ACTION_DIRNAME);
            if($class === false) return new propsResponse;
            $action = new $class;
            $cacheKey = $action->getCacheKey($this->_request);
            if($cacheKey != '')
            {
                if(!isset($mapping['VIEW']['MODULE']))
                    $mapping['VIEW']['MODULE'] = $this->current_module;
                $cache_path = $mapping['VIEW']['MODULE'].'/';
                $cache_path .= $mapping['VIEW']['NAME'].'.';
                if(isset($mapping['CACHE']['ID']))
                    $cache_path .= $mapping['CACHE']['ID'].'.'.$cacheKey;
                else
                    $cache_path .= $mapping['ACTION']['NAME'].'_'.$mapping['ACTION']['MODULE'].'.'.$cacheKey;

                $view_response = new propsResponse;
                $cacheExpire = $action->getCacheExpire($this->_request);
                $ok = $view_response->loadCache($cache_path, $cacheExpire);
                if($ok)
                    return $view_response;

                $view_response = $this->_process_combination($mapping);
                if(isset($mapping['CACHE']['VALIDITY']))
                    $mapping['CACHE']['VALIDITY'] = PROPS_CACHE_VALIDITY;
                $view_response->saveCache($cache_path, $mapping['CACHE']['VALIDITY']);
                return $view_response;
            }
        }

        return $this->_process_combination($mapping);
    }

    /**
    * processComponent
    * @access private
    * @return propsRespponse object
    **/
    function _process_combination($mapping)
    {
        $action_response = new propsResponse;
        if(isset($mapping['ACTION']))
        {
            $class = $this->_load_module_class($mapping['ACTION']
                                , PROPS_ACTION_ROOT_DIR, PROPS_ACTION_DIRNAME);
            if($class === false) return new propsResponse;

            $action = new $class;
            $action->execute($this->_request, $mapping['ACTION']['COMMAND'], $action_response);
        }

        $class = $this->_load_module_class($mapping['VIEW']
                                    , PROPS_VIEW_ROOT_DIR, PROPS_VIEW_DIRNAME);
        if($class === false) return new propsResponse;

        $view = new $class;
        $view_response = new propsResponse;
        $view->makeView($this->_request
                                , $action_response
                                , $mapping['VIEW']['COMMAND']
                                , $view_response);

        return $view_response;
    }

    /**
    * processAssemble
    * @access public
    * @return propsRespponse object
    **/
    function processAssemble($mapping, $response)
    {
        $class = $this->_load_module_class($mapping
                                    , PROPS_ASSEMBLER_ROOT_DIR
                                    , PROPS_ASSEMBLER_DIRNAME);
        if($class === false) return new propsResponse;

        $new_response = new propsResponse;
        $obj = new $class;
        return $obj->assemble($this->_request
                                , $response
                                , $mapping['COMMAND']
                                , $new_response);
        return $new_response;
    }

    /**
    * processDisplay
    * @access public
    * @return bool
    **/
    function processDisplay($mapping, $response)
    {
        if(isset($mapping['NAME']))
        {
            $class = $this->_load_class($mapping['NAME'], PROPS_DISPLAY_DIR);
            if($class === false) return false;

            $obj = new $class;
            return $obj->display($this->_request, $response, $mapping['COMMAND']);
        }
        else
        {
            foreach($mapping as $sub_mapping)
            {
                if(isset($mapping['NAME']))
                {
                    $class = $this->_load_class($mapping['NAME'], PROPS_DISPLAY_DIR);
                    if($class === false) return false;
            
                    $obj = new $propsClassName;
                    if(false !== $obj->display($this->_request, $response, $mapping['COMMAND']))
                    {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /**
    * processForm
    * @access public
    * @return bool
    **/
    function processForm($mapping)
    {
        $class = $this->_load_module_class($mapping
                                        , PROPS_FORM_ROOT_DIR, PROPS_FORM_DIRNAME);
        if($class === false)
        {
            return false;
        }

        $this->_form = new $class;
        if(isset($mapping['OPEN']))
        {
            $this->_form->open($mapping['SCOPE'], $mapping['ID']);
        }
        $this->_request->setForm($this->_form, $mapping['COMMAND']);

        if(isset($mapping['VALIDATE']))
        {
            $ret = $this->_request->validate($mapping['VALIDATE']['COMMAND']);
            if(! $ret)
            {
                if(isset($mapping['VALIDATE']['OPERATION']))
                {
                    $this->processOperation($mapping['VALIDATE']['OPERATION']);
                    exit();
                }
            }
        }
        return true;
    }

//////////////// private functions

    /**
    * _load_module_class
    * @access private
    * @return string    class name
    **/
    function _load_module_class($mapping, $root, $dir)
    {
        //static $classes;

        if(isset($mapping['NAME']))
        {
            $name = $mapping['NAME'];
            $module = isset($mapping['MODULE']) ? $mapping['MODULE'] : $this->current_module;


            if(! isset($this->modclasses[$module][$dir][$name]))
            {
                $path = $root.'/'.$module
                        .$dir.'/'.$name.PROPS_PHP_EXT;

                unset($class);
                include($path);
                if(!isset($class) || !class_exists($class))
                {
                    $this->_trigger_error(
                        '_load_module_class()::Invalid class file ('.$path.')',
                        E_USER_WARNING
                    );
                    return false;
                }
                $this->modclasses[$module][$dir][$name] = $class;
            }

            return $this->modclasses[$module][$dir][$name];
        }
    }

    /**
    * _load_module_class
    * @access private
    * @return string    class name
    **/
    function _load_class($name, $root)
    {
        //static $classes;

        if(! isset($this->mainclasses[$name]))
        {
            $path = $root.'/'.$name.PROPS_PHP_EXT;

            unset($class);
            include($path);
            if(!isset($class) || !class_exists($class))
            {
                $this->_trigger_error(
                    '_load_class()::Invalid class file ('.$path.')',
                    E_USER_WARNING
                );
                return false;
            }
            $this->mainclasses[$name] = $class;
        }
        return $this->mainclasses[$name];
    }

    /**
    * _trigger_error
    * @access private
    **/
    function _trigger_error($msg, $type)
    {
        trigger_error(get_class($this).'::'.$msg, $type);
    }
}
?>