<?php
// props, MVC style web application framework
//
// Copyright (C) Haruki Setoyama <props@planewave.org>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// $Id: Form.php,v 1.4 2003/06/14 10:35:56 haruki Exp $
/**
* props, MVC style web application framework
*
* @author Haruki Setoyama  <props@planewave.org>
* @package props
**/
/**
* propsForm
*
* @access abstruct & interface
**/
class propsForm
{
    var $_factory;
    var $_id;

    /**
    * load values externaly , ex. from session
    * @return bool
    **/
    function open($scope =null, $id ='')
    {
        if(isset($scope) )
        {
            $class = 'propsFormFactory_'.strtolower($scope);
            if(! class_exists($class))
            {
                $this->_trigger_error(
                    'open()::Invalid scope ('.$scope.')',
                    E_USER_WARNING
                );
                return false;
            }
            $this->_factory = new $class;
            $this->_factory->open($this, $id);
            $this->_id = $id;
        }
        return true;
    }

    /**
    * save values
    * @return bool
    **/
    function close()
    {
        if(isset($this->_factory))
            $this->_factory->close($this, $this->_id);
    }

    function setValues(&$request, $command ='')
    {
    }

    function setValue($name, $value)
    {
    }

    function removeValue($name)
    {
    }

    function getValue($name)
    {
        return false;
    }

    function getValueNames()
    {
        return array();
    }

    function validate($command)
    {
        return true;
    }

    function getError($name)
    {
        return '';
    }

    function getErrorNames()
    {
        return array();
    }

    function _trigger_error($msg, $type)
    {
        trigger_error(get_class($this).'::'.$msg, $type);
    }
}


/**
* propsDynaForm
*
* @access abstruct
**/
class propsDynaForm
{
    var $_values = array();
    var $_params = array();
    var $_error = array();

    function setValues(&$request, $command ='')
    {
        foreach($this->_params as $param)
        {
            $value = $request->getParameter($param);
            if($val !== false) $this->setValue($param, $value);
        }
        $this->_process_value();
    }

    function setValue($name, $value)
    {
        $this->_values[$name] = $value;
    }

    function removeValue($name)
    {
        unset($this->_values[$name]);
    }

    function getValue($name)
    {
        return isset($this->_values[$name]) ? $this->_values[$name] : false;
    }

    function getValueNames()
    {
        return array_keys($this->_values);
    }

    function getError($name)
    {
        return $this->_error[$name];
    }

    function getErrorNames()
    {
        return array_keys($this->_error);
    }

    function _setError($name, $error)
    {
        $this->_error[$name] = $error;
    }

    /////

    function validate($command)
    {
        return true;
    }

    function _process_value()
    {

    }
}

/**
* propsFormLoader
*
* @access interface
**/
class propsFormFactory
{
    function open(&$form, $id){}

    function close(&$form, $id){}
}

/**
* propsFormFactory_request
*
* @access public
**/
class propsFormFactory_request extends propsFormFactory
{
    // Do nothing
}

/**
* propsFormFactory_session
*
* @access public
**/
class propsFormFactory_session extends propsFormFactory
{
    function open(&$form, $id)
    {
        $sesskey = $this->_sesskey($form, $id);
        if(!isset($_SESSION[$sesskey]))
            return false;

        $rets = $_SESSION[$sesskey];
        foreach($rets as $key => $val)
        {
            $form->setValue($key, $val);
        }
        unset($_SESSION[$sesskey]);
        return true;
    }

    function close(&$form, $id)
    {
        $sesskey = $this->_sesskey($form, $id);
        $valnames = $form->getValueNames();
        $values = array();
        foreach($valnames as $name)
        {
            $values[$name] = $form->getValue($name);
        }
        $_SESSION[$sesskey] = $values;
    }

    function _sesskey(&$form, $id)
    {
        $formname = get_class($form);
        $key = 'propsForm_'.$formname;
        if(strlen($id) > 0)
            $key .= '_'.$id;
        return $key;
    }
}
?>