<?php
// props, MVC style web application framework
//
// Copyright (C) Haruki Setoyama <props@planewave.org>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// $Id: Response.php,v 1.2 2003/06/14 10:35:56 haruki Exp $
/**
* props, MVC style web application framework
*
* @author Haruki Setoyama  <props@planewave.org>
* @package props
**/
/**
* propsResponse
*
* @access public
**/
class propsResponse
{
    var $_data = array();

    /**
    * append Data
    * @access public
    * @return void
    **/
    function appendData($name, $value)
    {
        $this->_data[$name][] = $value;
    }

    /**
    * get Data
    * @access public
    * @return mixed
    **/
    function getData($name)
    {
        if(! isset($this->_data[$name])) return false;
        if(list($key, $val) = each($this->_data[$name]))
            return $val;
        else
            return false;
    }

    /**
    * reset pointer of data
    * @access public
    * @return void
    **/
    function reset($name)
    {
        reset($this->_data[$name]);
    }

    /**
    * reverse order of data
    * @access public
    * @return void
    **/
    function reverse($name)
    {
        $this->_data[$name] = array_reverse($this->_data[$name]);
    }

    /**
    * returns nomber of data
    * @access public
    * @return int
    **/
    function getDataNum($name)
    {
        return count($this->_data[$name]);
    }

    /**
    * remove Data
    * @access public
    * @return void
    **/
    function removeData($name)
    {
        unset($this->_data[$name]);
    }

    /**
    * remove all Data
    * @access public
    * @return void
    **/
    function removeAll()
    {
        $this->_data = array();
    }

    /**
    * return names of data
    * @access public
    * @return array
    **/
    function getDataNames()
    {
        return array_keys($this->_data);
    }

    /**
    * merge another propsResponse object to this object
    * @access public
    * @return array
    **/
    function merge($response)
    {
        $names = array_keys($response->_data);
        foreach($names as $name){
            $this->_data[$name] = array_merge($this->_data[$name], $response->_data[$names]);
        }
    }

    /**
    * save data as cache to $path
    * @access public
    * @return bool
    **/
    function saveCache($path, $validity =604800)
    {
        $fp = fopen (PROPS_CACHE_ROOT_DIR.'/'.$path.PROPS_PHP_EXT, 'w');
        if($fp === false) {
            trigger_error(get_class($this).'::endCache()::fail to open '.$path
                            ,  E_USER_WARNING);
            return false;
        }
        fwrite($fp, '<?php'."\n"
                    .'$propsCacheData = '.var_export($this->_cached_data, true).';'."\n"
                    .'$propsCachedAt = '.time().';'."\n"
                    .'$propsCacheExpire = '.time()+intval($validity).';'."\n"
                    .'?>'); // <?
        fclose($fp);
        return true;
    }

    /**
    * save data from cache at $path
    * @access public
    * @return bool
    **/
    function loadCache($path, $expire =0)
    {
        if(! file_exists(PROPS_CACHE_ROOT_DIR.'/'.$path.PROPS_PHP_EXT)){
            return false;
        }
        unset($propsCacheData);
        unset($propsCachedAt);
        unset($propsCacheExpire);

        @include(PROPS_CACHE_ROOT_DIR.'/'.$path.PROPS_PHP_EXT);

        if(! isset($propsCacheData)) {
            trigger_error(get_class($this).'::appendDataFromCache()::Invalid cache file'
                            ,  E_USER_WARNING);
            return false;
        }

        if($propsCacheExpire < time()){
            return false;
        }

        if($propsCachedTime < intval($expire)){
            return false;
        }

        foreach($propsCacheData as $name => $data){
            $this->_data[$name] = array_merge($this->_data[$name], $data);
        }
        return true;
    }
}
?>