<?php
// $Id: sqlcondition.php,v 1.1 2003/06/14 10:40:43 haruki Exp $
//
// RdbObject and its Manager
//
// Copyright (C) Haruki Setoyama <pwaf.haruki@planewave.org>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
/**
* sqlCondition, where-clause handling classes for the RdbObject Manager
*
* @auther Haruki Setoyama <pwaf.haruki@planewave.org>
* @lisence LGPL
* @since 2003.06
*/
/**
* sqlCondition
*
* @access public
*/
class sqlCondition extends sqlComparisons
{
    var $limit;
    var $start;
    var $orderby = array();
    var $groupby = array();
    var $where;
    var $having;

    function setHaving($comparison)
    {
        $this->having = $comparison;
    }

    function setLimit($limit=0)
    {
        $this->limit = intval($limit);
    }

    function setStart($start=0)
    {
        $this->start = intval($start);
    }

    function addOrderby($field, $order='ASC')
    {
        if(! $this->_check_order($order)) return;
        $this->orderby[] = array($field, ' '.$order);
    }

    function addGroupby($group, $order='ASC')
    {
        if(! $this->_check_order($order)) return;
        $this->orderby[] = array($group, ' '.$order);
    }

    function _check_order($order)
    {
        if(! in_array($order, array('ASC', 'DESC')))
        {
            trigger_error(
                get_class($this).'::invalid order ('.$order.')'
                , E_USER_NOTICE
            );
            return false;
        }
        return true;
    }

    function render($obj, $where = true)
    {
        $ret = '';
        if(!empty($this->comparisons))
        {
            foreach($this->comparisons as $comparison)
            {
                $cmp[] = $comparison->render($obj, false);
            }
            $ret .= ((! $where) ? '' : 'WHERE ')
                    .'( '.implode($this->logical_operator, $cmp).' )';
        }
        if(!empty($this->groupby)) $ret .= 'GROUPBY '.$obj->renderGroup($this->groupby);
        if(!empty($this->having)) $ret .= 'HAVING '.$this->having->render($obj);
        if(!empty($this->orderby)) $ret .= 'ORDERBY '.$obj->renderOrder($this->orderby);
        return $ret;
    }
}
/**
* sqlComparison
*
* @access public
*/
class sqlComparison
{
    var $variable;
    var $value;
    var $operator;

    function sqlComparison($variable, $value='', $operator='=')
    {
        $this->set($variable, $value, $operator);
    }

    function set($variable, $value='', $operator='=')
    {
        if(! in_array($operator, array('=','>','<','>=','<=','!=','<>','LIKE')))
        {
            return;
        }
        $this->variable = $variable;
        $this->value = $value;
        $this->operator = $operator;
    }

    function render($obj, $where = true)
    {
        return ((! $where) ? '' : 'WHERE ')
                .$obj->renderComparison($this->variable, $this->value, $this->operator);
    }
}
/**
* sqlComparisons
*
* @access public
*/
class sqlComparisons
{
    var $comparisons = array();
    var $logical_operator = ' AND ';

    function sqlComparisons($ope='AND')
    {
        $this->operator($ope);
    }

    function add($variable, $value='', $operator='=')
    {
        if(is_a($variable, 'sqlComparisons') || is_a($variable, 'sqlComparison'))
            $this->comparisons[] = $variable;
        else
            $this->comparisons[] = new sqlComparison($variable, $value, $operator);
    }

    function operator($ope)
    {
        if(! in_array($ope, array('AND', 'OR'))) return;
        $this->logical_operator = ' '.$ope.' ';
    }

    function render($obj, $where = true)
    {
        $ret = array();
        foreach($this->comparisons as $comparison)
        {
            $ret[] = $comparison->render($obj, false);
        }
        return ((! $where) ? '' : 'WHERE ')
                .'( '.implode($this->logical_operator, $ret).' )';
    }
}

?>