<?php
/**
 * RdbObject and its Manager
 * class for manupulating data stored in relational database server.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * @author Haruki Setoyama <haruki@planewave.org> 
 * @copyright Copyright &copy; 2003, Haruki SETOYAMA <haruki@planewave.org>
 * @license http://www.opensource.org/licenses/lgpl-license.php LGPL
 * @package rdbObject
 * @since 2003.06
 * @version 0.2 $Id: rdbobjectmanager.firebird.php,v 1.4 2003/11/24 15:18:35 haruki Exp $
 * @link http://www.planewave.org/rdbobject/
 */
/**
 * rdbObjectManager_mysql
 * 
 * @access public 
 */
class rdbObjectManager_firebird extends rdbObjectManager {
	var $_generator;

	function _init($rdbObjectClass, $columns)
    {
		$this->_generator = strtoupper($this->_table);
		parent::_init($rdbObjectClass, $columns);
		$this->_column = array_map('strtoupper', $this->_column);
		$this->_pkey_column = strtoupper($this->_pkey_column);
	}

    function _query($sql)
    {
		if (isset($this->logger)) {
			$this->_log($sql); 
		} 
		return ibase_query($this->_linkid, $sql); 
    } 

    function _query_error($sql = '')
    {
		$msg = '<b>Query error</b>: ';
		$msg .= ibase_errmsg()."<br>\n";
		$msg .= $sql."<br>\n";
        return $this->raiseError($msg, RDBOBJECT_ERROR_INTERNAL);
    } 

    function _fetch($result)
    {
        //if(! ($arr = ibase_fetch_object($result))) return false;
		//return get_object_vars($arr);
		return ibase_fetch_assoc($result);
    }

    function _compose_limit_sql($condition)
    {
		// "SELECT FIRST $limit SKIP $start
        $limit = '';
		if (isset($condition->limit)) {
            $limit .= ' FIRST '.abs(intval($condition->limit));
        }
        if (isset($condition->start)) {
            $limit .= ' SKIP '.abs(intval($condition->start));
        } 
        return $limit;
    }
	
	function _compose_select_sql($select, $from, $condition, $order = true, $group =null)
	{
		$where = '';
		$limit = '';
		if (isset($condition)) {
			$where = $condition->render();
			if (isset($group)) {
			    $where .= ' GROUP BY '.$group;
			}
			$limit = $this->_compose_limit_sql($condition);
		}
		$sql = 'SELECT'.$limit.' '.$select.' FROM '.$from.$where;
		return $sql;
	}   

    function _insert(&$object)
    {
		$id = $this->_gen_id();
		if ($id === false) {
		    return false;
		}
		$object->_dbRawData[$this->_pkey_column] = $id;

		$fields = array();
        $data = array();
        foreach ($this->_column as $varname => $column) {
            $fields[] = $this->_column_quoted[$varname];
            $data[] = $this->_quote($object->_dbRawData[$column], $varname);
        } 
        $sql = sprintf("INSERT INTO %s ( %s ) VALUES ( %s )" 
						, $this->_table
						, implode(', ', $fields)
						, implode(', ', $data));
        $result = $this->_query($sql);
        if ($result === false) {
            $this->_query_error($sql);
			return false;
        }  

        $object->change = array();
        $this->_cache[$id] = &$object;
        return $id;
    }
	
	function _gen_id()
	{
		$sql = 'SELECT GEN_ID('.$this->_generator.', 1) FROM RDB$GENERATORS WHERE RDB$GENERATOR_NAME=\''.$this->_generator.'\'';
        $result = $this->_query($sql);
        if (! $result) {
			return $this->_create_generator();
            //$this->_query_error($sql);
			//return false;
        }
        $row = ibase_fetch_row($result);
        if ($row === false) {
           return false;
        }
		return intval($row[0]);
		
	}

	function _create_generator()
	{
		$sql = 'SELECT COUNT(*) FROM '.$this->_table;
		$result = $this->_query($sql);
        if ($result === false) {
            $this->_query_error($sql);
			return false;
        }
		$row = ibase_fetch_row($result);
		if ($row[0] == 0) {
		    $num = 1;
		} else {
			$sql = 'SELECT MAX('.$this->_column_quoted[$this->_pkey].') FROM '.$this->_table;
			$result = $this->_query($sql);
	        if ($result === false) {
	            $this->_query_error($sql);
				return false;
	        }
			$row = ibase_fetch_row($result);
	        $num = intval($row[0])+1;
		}

		$sql = 'CREATE GENERATOR '.$this->_table;
		$result = $this->_query($sql);
        if ($result === false) {
            $this->_query_error($sql);
			return false;
        }

		$sql = 'SET GENERATOR '.$this->_generator.' TO '.$num;
		$result = $this->_query($sql);
        if ($result === false) {
            $this->_query_error($sql);
			return false;
        }
		return $num;
	}

    function _quote($value, $varname)
    {
        if ($value === null) {
            return 'NULL';
        } elseif (!($this->_type[$varname] & RDBOBJECT_ELEMENT_NUMERIC)) {
            return '\''.str_replace('\'', '\'\'', $value).'\'';
        } elseif (!is_numeric($value)) {
            return '\''.str_replace('\'', '\'\'', $value).'\'';
        }else {
            return $value;
        } 
    } 

    function _quote_column($column)
    {
        return '"' . strtoupper($column) . '"';
    } 
	
    function _quote_table($table) 
	{
        return '"' . strtoupper($table) . '"';;
	}

} 

?>