<?php
/**
 * singleton class manager
 * 
 * @author Haruki Setoyama <haruki@planewave.org>
 * @copyright Copyright &copy; 2003, Haruki SETOYAMA <haruki@planewave.org>
 * @license http://www.opensource.org/licenses/lgpl-license.php LGPL
 * @version 2.1 $Id: singleton.php,v 1.6 2003/11/13 10:08:19 haruki Exp $
 * @access public 
 */
if (! class_exists('singleton')) {
	/**
	 * require
	 */
	require_once 'PEAR.php';
	/**
	 * define
	 */
	define('SINGLETON_ERROR_INVALID_CLASS', 1);
	/**
	 * @global array $_SINGLETON
	 */
    if (!defined('_SINGLETON_GLOBAL')) { 
		define('_SINGLETON_GLOBAL', '_SINGLETON');
	}
	$GLOBALS[_SINGLETON_GLOBAL] = array();
	
	/**
	 * singleton
	 * 
	 * @access public
	 * @static 
	 */
    class singleton extends PEAR 
	{
        /**
         * singleton::getInstance()
         * 
         * @param string $name  class name that you want to make singleton.
         * @param bool $getInstance true when useing getInstance() function for initialize
         * @return object|PEARError
         * @access public 
         */
        function &getInstance($name, $getInstance = true)
        {
            $name = trim(strtolower($name));
            if (! isset($GLOBALS[_SINGLETON_GLOBAL][$name])) {
                if (! class_exists($name)) {
                    return singleton::raiseError("Class '$name' does not exists." , SINGLETON_ERROR_INVALID_CLASS);
                } 

                $obj = new $name;
                if ($getInstance != false && is_callable(array($obj, 'getInstance'))) {
                    $obj = &$obj->getInstance();
                } 

                if (! is_object($obj)) {
                    return singleton::raiseError("fail to instanciate the class '$name'." , SINGLETON_ERROR_INVALID_CLASS);
                } elseif (PEAR::isError($obj)) {
                    return $obj;
                } 

                $GLOBALS[_SINGLETON_GLOBAL][$name] = $obj;
            } 
            return $GLOBALS[_SINGLETON_GLOBAL][$name];
        } 

        /**
         * singleton::isInstanciated()
         * 
         * @param string $name  class name that you want to make singleton.
         * @return bool 
         * @access public 
         */
        function isInstanciated($name)
        {
            $name = trim(strtolower($name));
            return (! isset($GLOBALS[_SINGLETON_GLOBAL][$name])) ? false : true;
        } 

        /**
         * singleton::deleteInstance()
         * 
         * @param string $name  class name that you want to make singleton.
         * @return void 
         * @access public 
         */
        function deleteInstance($name)
        {
            $name = trim(strtolower($name));
            $GLOBALS[_SINGLETON_GLOBAL][$name] = null;
        } 
    } 
} 

?>