import anydbm
import datetime

class UnreadFilter:
    def __init__(self, config, environ):
        dbpath = config.setdefault("path", None)
        if not dbpath:
            self.db = {}
        else:
            self.db = anydbm.open(dbpath, "c")

    def execute(self, content):
        entries = []
        for entry in content["entries"]:
            link = entry["link"]
            updated = entry["parsed_updated"]
            if not self.db.has_key(link):
                entries.append(entry)
                self.db[link] = updated
        if hasattr(self.db, "sync"):
            self.db.sync()
        content["entries"] = entries
        return content



def create(config, environ):
    return UnreadFilter(config, environ)
