from xml.sax.saxutils import escape
RSS_HEADER = """<?xml version="1.0" encoding="utf-8"?>
<rss version="2.0">
<channel>
  <title>%(title)s</title>
  <link>%(link)s</link>
"""

RSS_FOOTER = """</channel>
</rss>"""

ITEM = """
  <item>
    <title>%(title)s</title>
    <link>%(link)s</link>
    <pubDate>%(published)s</pubDate>
    <description>%(description)s</description>
  </item>
"""


class RssFeeder(object):
    def __init__(self, config, environ):
        self.config = config
        self.environ = environ
        self.data = {}
        config.setdefault("title", "habu rss")
        config.setdefault("link", "http://localhost/")
        self.out_path = config.get("file", "./rss")
        
    def execute(self, content):
        allEntries = self.data.setdefault("entries", [])
        allEntries.extend(content.get("entries", []))
        self._dump()
        
        return content
        
    def _dump(self):
        f = open(self.out_path, "w")
        f.write(RSS_HEADER %
                {"title": self._enc(self.config["title"]),
                 "link": self._enc(self.config["link"])
                 }
                )
        for entry in self.data["entries"]:
            f.write(ITEM % self._extract(entry))
        f.write(RSS_FOOTER)
        f.close()

    def _extract(self, entry):
        d = {}
        d["title"] = self._enc(entry["title"])
        d["link"] = self._enc(entry["link"])
        d["description"] = self._enc(entry["summary"])
        if d.has_key("published"):
            d["published"] = self._enc(entry["published"])
        else:
            d["published"] = self._enc(entry["updated"])

        
        return d

        

    def _enc(self, s):
        if type(s) == unicode:
            s = s.encode("utf-8")

        return escape(s)
        

def create(config, environ):
    return RssFeeder(config, environ)
