
from twisted.mail import pop3client
from twisted.internet import reactor, defer, protocol
from twisted.python import log
from twisted.python.failure import Failure
import email
import email.Header
import time
import sys



def _date2struct_time(datestring):
    parsed_date = email.Utils.parsedate(datestring)
    return time.struct_time(parsed_date)

def _parse(source):
    source = "\r\n".join(source)
    message = email.message_from_string(source)

    # header extraction
    messageId = message.get("message-id").replace("<", "").replace(">", "")
    published = message.get("date")
    published_parsed = _date2struct_time(published)

    subj = email.Header.decode_header(message.get("subject"))
    decodedSubj = []
    for e in subj:
        encoding = "us-ascii"
        if e[1]:
            encoding = e[1]
        decodedSubj.append(unicode(e[0], encoding))
    subject = u" ".join(decodedSubj)

    body = u""
    attachments = []
    for part in message.walk():
        if part.get_content_maintype() == "multipart":
            continue
        partType = part.get_content_type()
        if not body and partType == "text/plain":
            body = part.get_payload(decode=True).decode(part.get_charsets()[0])
        elif partType.find("image") == 0:
            filename = part.get_filename()
            fileBody = part.get_payload(decode=True)
            info = dict(title = filename,
                        value = fileBody,
                        type = partType)
            attachments.append(info)

    return dict(messageId = messageId,
                published = published,
                published_parsed = published_parsed,
                subject = subject,
                body = body,
                attachments = attachments)

def _parsedMail2Feed(parsedData, config):
    entries = []
    feed = {"entries": entries}
    author = config.setdefault("author", "habu")
    for data in parsedData:
        entry = {}
        entry["author"] = author
        entry["author_detail"] = {"name": author}
        entry["author_detail"] = {"name": author}
        entry["link"] = "mail://" + data["messageId"]
        entry["updated"] = entry["published"] =  data["published"]
        entry["updated_parsed"] = data["published_parsed"]
        entry["published_parsed"]= data["published_parsed"]
        entry["file"] = data["attachments"]
        entry["summary"] = data["body"]
        entry["summary_detail"] = {"base": "",
                                   "type": "text/plain",
                                   "language": None,
                                   "value": data["body"]}
        entry["title"] = data["subject"]
        entry["title_detail"] = {"base": "",
                                 "type": "text/plain",
                                 "language": None,
                                 "value": data["subject"]}
        entries.append(entry)

    return feed


class POP3Client(pop3client.POP3Client):
    # allowInsecureLogin = True
    # startedTLS = True
    @defer.deferredGenerator
    def serverGreeting(self, greeting):
        try:
            pop3client.POP3Client.serverGreeting(self, greeting)
            wfd = defer.waitForDeferred(
                self.login(self.factory.username, self.factory.password))
            yield wfd
            result = wfd.getResult()

            wfd = defer.waitForDeferred(self.listSize())
            yield wfd
            sizes = wfd.getResult()
            messageData = []
            for i in xrange(len(sizes)):
                wfd = defer.waitForDeferred(self.retrieve(i))
                yield wfd
                result = wfd.getResult()
                messageData.append(result)

            wfd = defer.waitForDeferred(self.quit())
            yield wfd
            result = wfd.getResult()

            parsed_data = [_parse(source) for source in messageData]
            content = _parsedMail2Feed(parsed_data, self.factory.config)
            self.factory.deferred.callback(content)
        except Failure, f:
            self.factory.deferred.errback(f)

        
class POP3ClientFactory(protocol.ClientFactory):
    protocol = POP3Client
    def __init__(self, username, password):
        self.username = username
        self.password = password
        self.deferred = defer.Deferred()

    def clientConnectionFailed(self, connection, reason):
        log.msg("subscription.mail : " + str(reason))
        self.deferred.errback(reason)

class MailSubscription(object):
    def __init__(self, config, environ):
        self.config = config
        self.environ = environ
    
    def execute(self, content=None):
        factory = POP3ClientFactory(self.config["user"],
                                    self.config["password"])
        factory.config = self.config
        reactor.connectTCP(self.config["server"], 110, factory)

        return factory.deferred

def create(config, environ):
    return MailSubscription(config, environ)


if __name__ == "__main__":
    def success(results):
        print results
        reactor.stop()
    server, username, password = sys.argv[1:4]
    factory = POP3ClientFactory(username, password)
    factory.deferred.addCallback(success)
    reactor.connectTCP(server, 110, factory)
    reactor.run()
