#ifndef _INCLUDE_MATCHED_H_
#define _INCLUDE_MATCHED_H_

#include "opm_param.h"
#include "xym.h"

#define MATCHED_SINGLE 0
#define MATCHED_MULTI 1

typedef struct _matched *matched;

#define MATCHED_FORMAT_OUT "%5d %8.2f %8.2f %7.2f %7.2f %7.3f  %5d %7.2f %7.2f %7.3f %d\n"
#define MATCHED_FORMAT_IN "%d %lf %lf %lf %lf %lf  %d %lf %lf %lf %d"

int output_matched_result(FILE *flog, char *output, int nobj, xym *data_obj, int nref, xym *data_ref, double *coef, opm_param *setting);
void print_matched(FILE *fp, matched p);
matched malloc_matched(void);
matched *load_matched(char *file, int *ndata);
void destroy_matched(int ndata, matched *data);
void print_output_coef(FILE *fp, double *coef);
void xym_to_matched(xym obj, xym ref, int flag, matched p);
int get_matched_id1(matched p);
void get_matched_dxdy(int ndata, matched *data, double *dx, double *dy);
double get_matched_x1org(matched p);
double get_matched_y1org(matched p);
double get_matched_x1(matched p);
double get_matched_y1(matched p);
double get_matched_m1(matched p);
int get_matched_id2(matched p);
double get_matched_x2(matched p);
double get_matched_y2(matched p);
double get_matched_m2(matched p);
int get_matched_flag(matched p);
Boolean read_matched_coef(char *file, double *coef);
void get_refmag_delta(int ndata, matched *data, double *refmag, double *delta);
double get_matched_magdelta(int ndata, matched *data);
void get_matched_xy1org(int ndata, matched *data, double *x1org, double *y1org);
void get_matched_xy1(int ndata, matched *data, double *x1, double *y1);
void get_matched_xy2(int ndata, matched *data, double *x2, double *y2);

#endif
