#ifndef _INCLUDE_TMAT_H_
#define _INCLUDE_TMAT_H_

/*
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <stddef.h>
#include <string.h>
*/ 

#define NDIM 3
#define NROW 3
#define NCOLUMN 3
/* 
	a(m, n) = a(NROW, NCOLUMN)  
		m: number of rows    (horizontal) 
		n: number of columns (vertical) 
*/ 
/* 
	in calculation 
		a(i, j) = a[i][j] 
			= a[ n x i + j] 
			i = 0, 1, .... , m-1  
			j = 0, 1, .... , n-1  
	matrix a 
		a[0],      a[1],        a[2],    a[3],    ..., a[n-1] 
		a[n],      a[n+1],      a[n+2],  a[n+3],  ..., a[n+n-1] 
		a[2n],     a[2n+1],     a[2n+2], a[2n+3], ..., a[2n+n-1] 
		             .....
		a[(m-1)n], a[(m-1)n+1], a[(m-1)n+2],      ..., a[(m-1)n+n-1] 
*/ 

/* 
	Input matrix elements into rotation matrix ; 
		around	x-axis for iaxis = 1 
			y-axis           = 2 
			z-axis           = 3 
		input theta : rotation angle in radian, output matrix r[NDIM][NDIM] 
		rotmat( iaxis, theta, r ) ; 
*/ 
void rotmat( int iaxis, double theta, double *r ) ;

/* 
	Transformation from spherical angular variable, Xi, Eta ( radian ) 
		to rectangular variable, X, Y, Z 
		txexyz( xi, eta, x ) ; 
*/ 
void txexyz( double xi, double eta, double *x ) ;

/* 
	Matrix multiplication  No. 1 
		vector y[NDIM] = matrix r[NDIM][NDIM] * vector x[NDIM] 
		mult0( r, x, y ) 
*/ 
void mult0( double *r, double *x, double *y ) ;

#endif
