#ifndef _INCLUDE_TRIANGLE_H_
#define _INCLUDE_TRIANGLE_H_

#include <stdio.h>
#include <stdlib.h>
#include "xym.h"
#include "boolean.h"

typedef struct _triangle *triangle;

triangle make_new_triangle(double ratio, double metric, xym a, xym b, xym c);
void destroy_triangle(triangle p);
void destroy_triangle_array(int ndata, triangle *p);
void print_triangle(FILE *fp, triangle p);
double get_triangle_ratio(triangle p);
double get_triangle_metric(triangle p);
xym get_triangle_a(triangle p);
xym get_triangle_b(triangle p);
xym get_triangle_c(triangle p);
triangle *make_triangle_array(int ndata, xym *data);
void sort_triangles_ratio(int narray, triangle *array);
void sort_triangles_ratiometric(int narray, triangle *array);
int binsearch_triangles_ratio(double ratio, int narray, triangle *array);
Boolean pre_verif(triangle p, triangle q, double *coef, double limit);

#endif
