#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "file.h"
#include "opm_param.h"

void usage(void);

int main(int argc, char *argv[]){
   if(argc!=2) usage();
   opm_param setting;
   char output[FILE_LENGTH];
   FILE *fp;
   strcpy(output,argv[1]);
   if(file_exist(output)==TRUE){
      fprintf(stderr,"%s already exists! Please edit it by hand!\n",output);
      exit(1);
   }
   fp=fileopen(output,"w");
   get_opm_param_default(&setting);
   print_opm_param_file(fp,&setting);
   fclose(fp);
   fprintf(stderr,"# %s was created!\n",output);
   return 0;
}

void usage(void){
   fprintf(stderr,"Usage -> get_default_param output\n"); exit(1);
}
