#ifndef _INCLUDE_ORIGINAL_DATA_H_
#define _INCLUDE_ORIGINAL_DATA_H_

#include "xym.h"
#include "opm_param.h"

typedef struct _original_data {
   char id[30], flag[3];
   double x, y, mag[3], merr[3];
} *original_data;

original_data *load_original_data(char *file, int *ndata);
void destroy_original_data(int ndata, original_data *data);
xym *set_original_xym(int ndata, original_data *data);
original_data get_xym_original_data(xym p);
int output_matched_result_original(FILE *flog, char *output, int nobj, xym *data_obj, int nref, xym *data_ref, double *coef, opm_param *setting);

#endif
