#include <stdio.h> 
#include <stdlib.h> 
#include <string.h>
#include <math.h>

#include "file.h"
#include "graphics.h"
#include "matched.h"

void usage(void);
void set_windows(double xmin, double xmax, double xtic, double ymin, double ymax, double ytic);
void get_range(int ndata, double *data, double *min, double *max, double *tic);

int main(int argc, char *argv[]){
   int i, ndata, symbol;
   float xp, yp;
   double *refmag, *delta, mean, xmax, xmin, xtic, ymax, ymin, ytic;
   matched *data;
   if(argc<2) usage();
   if((data=load_matched(argv[1],&ndata))==NULL){
      fprintf(stderr,"Failed to load matched from %s\n",argv[1]); exit(1);
   }
   refmag=malloc(ndata*sizeof(double));
   delta=malloc(ndata*sizeof(double));
   get_refmag_delta(ndata,data,refmag,delta);
   if(argc==6){
      xmin=atof(argv[2]); xmax=atof(argv[3]); frametic(3,&xmin,&xmax,&xtic);
      ymin=atof(argv[4]); ymax=atof(argv[5]); frametic(3,&ymin,&ymax,&ytic);
   } else {
      get_range(ndata,refmag,&xmin,&xmax,&xtic);
      get_range(ndata,delta,&ymin,&ymax,&ytic);
   }
   cpgstart("?",7.0,0.6);
   set_windows(xmin,xmax,xtic,ymin,ymax,ytic);
   for(i=0;i<ndata;i++){
      xp=refmag[i]; yp=delta[i];
      if(get_matched_flag(data[i])==MATCHED_SINGLE) symbol=17;
      else symbol=5;
      cpgpt(1,&xp,&yp,17);
   }
   mean=get_matched_magdelta(ndata,data);
   fprintf(stderr,"delta=%.3f\n",mean);
   cpgmove(xmin,mean); cpgdraw(xmax,mean);
   free(refmag); free(delta);
   destroy_matched(ndata,data);
   cpgfinish() ; 
   return 0 ; 
}

void usage(void){
   fprintf(stderr,"Usage -> plot_magdel matched_file  (xmin xmax ymin ymax)\n");
   exit(1);
}

void set_windows(double xmin, double xmax, double xtic, double ymin, double ymax, double ytic){
   int nwin;
   double vpx0=0.20, vpx1=0.90, vpy0=0.20, vpy1=0.90;
   char xlabel[]="M\\dref\\u", ylabel[]="M\\dobj\\u-M\\dref\\u";
   nwin=1;
   setvp(nwin,vpx0, vpx1, vpy0, vpy1);
   setwin(nwin, xmin, xmax, ymin, ymax);
   set_tic(nwin,AXIS_X_LOW,xmin,xmax,xtic,FORMAT_G);
   set_tic(nwin,AXIS_X_UP,xmin,xmax,xtic,FORMAT_G);
   change_tic_lab_flag(nwin,AXIS_X_UP,FALSE);
   set_axis_label(nwin,AXIS_X_LOW,xlabel);
   set_tic(nwin,AXIS_Y_LEFT,ymin,ymax,ytic,FORMAT_G);
   set_tic(nwin,AXIS_Y_RIGHT,ymin,ymax,ytic,FORMAT_G);
   set_axis_label(nwin,AXIS_Y_LEFT,ylabel);
   change_tic_lab_flag(nwin,AXIS_Y_RIGHT,FALSE);
   change_tic_off(nwin,AXIS_X_LOW,-0.05);
   change_tic_off(nwin,AXIS_Y_LEFT,-0.02);
   change_axis_lab_off(nwin,AXIS_X_LOW,-0.12);
   change_axis_lab_off(nwin,AXIS_Y_LEFT,-0.12);
   change_tic_ch_lw(nwin,AXIS_X_LOW,1.5,1);
   change_tic_ch_lw(nwin,AXIS_Y_LEFT,1.5,1);
   change_axis_lab_ch_lw(nwin,AXIS_X_LOW,1.5,1);
   change_axis_lab_ch_lw(nwin,AXIS_Y_LEFT,1.5,1);
   mkframe(nwin);
}

void get_range(int ndata, double *data, double *min, double *max, double *tic){
   int i;
   double value, maxtmp, mintmp;
   maxtmp=data[0]; mintmp=data[0];
   for(i=1;i<ndata;i++){
      value=data[i];
      if(value>maxtmp) maxtmp=value;
      if(value<mintmp) mintmp=value;
   }
   *max=maxtmp; *min=mintmp;
   frametic(0,min,max,tic);
}

