#include <stdio.h> 
#include <stdlib.h> 
#include <string.h>
#include <math.h>

#include "file.h"
#include "graphics.h"
#include "matched.h"

void usage(void);
void set_windows(double xmin, double xmax, double xtic, double ymin, double ymax, double ytic);
void get_range(int ndata, double *data, double *min, double *max, double *tic);

int main(int argc, char *argv[]){
   int i, ndata, symbol;
   float xp, yp;
   double *x1, *y1, *x2, *y2;
   double xcen, ycen, halfsize, xmax, xmin, xtic, ymax, ymin, ytic;
   matched *data;
   if(argc<2) usage();
   if((data=load_matched(argv[1],&ndata))==NULL){
      fprintf(stderr,"Failed to load matched from %s\n",argv[1]); exit(1);
   }
   x1=malloc(ndata*sizeof(double)); y1=malloc(ndata*sizeof(double));
   x2=malloc(ndata*sizeof(double)); y2=malloc(ndata*sizeof(double));
   get_matched_xy1(ndata,data,x1,y1);
   get_matched_xy2(ndata,data,x2,y2);
   if(argc==5){
      xcen=atof(argv[2]); ycen=atof(argv[3]); halfsize=atof(argv[4]);
      xmin=xcen-halfsize; xmax=xcen+halfsize; frametic(3,&xmin,&xmax,&xtic);
      ymin=ycen-halfsize; ymax=ycen+halfsize; frametic(3,&ymin,&ymax,&ytic);
   } else {
      get_range(ndata,x1,&xmin,&xmax,&xtic);
      get_range(ndata,y1,&ymin,&ymax,&ytic);
   }
   cpgstart("?",6.0,1.0);
   set_windows(xmin,xmax,xtic,ymin,ymax,ytic);
   cpgsci(1);
   for(i=0;i<ndata;i++){
      if(get_matched_flag(data[i])==MATCHED_SINGLE) symbol=23;
      else symbol=5;
      xp=x1[i]; yp=y1[i]; cpgpt(1,&xp,&yp,symbol);
   }
   cpgsci(2);
   for(i=0;i<ndata;i++){
      if(get_matched_flag(data[i])==MATCHED_SINGLE) symbol=23;
      else symbol=5;
      xp=x2[i]; yp=y2[i]; cpgpt(1,&xp,&yp,symbol);
   }
   free(x1); free(y1);
   free(x2); free(y2);
   destroy_matched(ndata,data);
   cpgfinish() ; 
   return 0 ; 
}

void usage(void){
   fprintf(stderr,"Usage -> plot_magdel matched_file  (xcen ycen halfsize)\n");
   exit(1);
}

void set_windows(double xmin, double xmax, double xtic, double ymin, double ymax, double ytic){
   int nwin;
   float xp, yp;
   double vpx0=0.20, vpx1=0.90, vpy0=0.20, vpy1=0.90;
   char xlabel[]="x", ylabel[]="y", label[LINE_LENGTH];
   nwin=0;
   setvp(nwin,vpx0,vpx1,vpy1+0.01,vpy1+0.08);
   setwin(nwin,0,1,0,1);
   window(nwin);
   cpgsci(2);
   xp=0.3; yp=0.25; cpgpt(1,&xp,&yp,23);
   xp=0.3; yp=0.75; cpgpt(1,&xp,&yp,5);
   cpgsci(1);
   sprintf(label,"ref (flag=%d)",MATCHED_SINGLE); cpgptxt(0.33,0.15,0,0,label);
   sprintf(label,"ref (flag=%d)",MATCHED_MULTI);  cpgptxt(0.33,0.65,0,0,label);
   xp=0.7; yp=0.25; cpgpt(1,&xp,&yp,23);
   xp=0.7; yp=0.75; cpgpt(1,&xp,&yp,5);
   sprintf(label,"obj (flag=%d)",MATCHED_SINGLE); cpgptxt(0.73,0.15,0,0,label);
   sprintf(label,"obj (flag=%d)",MATCHED_MULTI);  cpgptxt(0.73,0.65,0,0,label);
   nwin=1;
   setvp(nwin,vpx0, vpx1, vpy0, vpy1);
   setwin(nwin, xmin, xmax, ymin, ymax);
   set_tic(nwin,AXIS_X_LOW,xmin,xmax,xtic,FORMAT_G);
   set_tic(nwin,AXIS_X_UP,xmin,xmax,xtic,FORMAT_G);
   change_tic_lab_flag(nwin,AXIS_X_UP,FALSE);
   set_axis_label(nwin,AXIS_X_LOW,xlabel);
   set_tic(nwin,AXIS_Y_LEFT,ymin,ymax,ytic,FORMAT_G);
   set_tic(nwin,AXIS_Y_RIGHT,ymin,ymax,ytic,FORMAT_G);
   set_axis_label(nwin,AXIS_Y_LEFT,ylabel);
   change_tic_lab_flag(nwin,AXIS_Y_RIGHT,FALSE);
   change_tic_off(nwin,AXIS_X_LOW,-0.04);
   change_tic_off(nwin,AXIS_Y_LEFT,-0.02);
   change_axis_lab_off(nwin,AXIS_X_LOW,-0.08);
   change_axis_lab_off(nwin,AXIS_Y_LEFT,-0.10);
   change_tic_ch_lw(nwin,AXIS_X_LOW,1.0,1);
   change_tic_ch_lw(nwin,AXIS_Y_LEFT,1.0,1);
   change_axis_lab_ch_lw(nwin,AXIS_X_LOW,1.0,1);
   change_axis_lab_ch_lw(nwin,AXIS_Y_LEFT,1.0,1);
   mkframe(nwin);
}

void get_range(int ndata, double *data, double *min, double *max, double *tic){
   int i;
   double value, maxtmp, mintmp;
   maxtmp=data[0]; mintmp=data[0];
   for(i=1;i<ndata;i++){
      value=data[i];
      if(value>maxtmp) maxtmp=value;
      if(value<mintmp) mintmp=value;
   }
   *max=maxtmp; *min=mintmp;
   frametic(0,min,max,tic);
}

