#ifndef _INCLUDE_THDRAD_H_
#define _INCLUDE_THDRAD_H_

#include "boolean.h"

/* Conversion from '+-' h m s to a value of radian ( 0 =< radian < 2 PI ) */
double h60rad( char sign, int h, int m, double s );

/* Conversion from '+-' d m s to a value of radian (-2*PI < radian < 2*PI) */
double d60rad( char sign, int d, int m, double s );

/* Conversion from radian to + h m s   ( return only positive value ) */
void radh60( double radh, char *sign, int *h, int *m, double *s );

/* Conversion from radian to +- d m s */
void radd60( double radd, char *sign, int *d, int *m, double *s );

/* transformation from RA and Dec (hh:dd:ss.s (+/-)dd:mm:ss.s) *
 *   to alpha and delta in radian                              */
void alpha_delta(char RA[], char Dec[], double *alpha, double *delta);

/* transformation from alpha and delta in radian    *
 *   to RA and Dec (hh:dd:ss.s (+/-)dd:mm:ss.s)     */
void RA_Dec(double alpha, double delta, char RA[], char Dec[]);

Boolean check_alpha_delta(double alpha, double delta);

#endif
