#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "./gethead.c"
#include "./mkheader.c"
#include "./swapfloat.c"
#include "./swapshort.c"

/*
  mkbadmask.c 
  for pyIRSF
*/


void swapfloat(float *f);
void swapshort(short *shrt);
int gethead(char *fname);
void mkheader(char *header, int sorf);

int main (int argc, char**argv)
{
  float *data;
  int   *data2, *data3;
  short *data4;
  FILE  *fp;
  int   i, xynum = 1024 * 1024;
  int   datanum = ((int)(xynum*sizeof(float)/2880)+1)*2880/sizeof(float);
  int   datanums = ((int)(xynum*sizeof(short)/2880)+1)*2880/sizeof(short);
  int   headsize, hfact;
  char  *header;
  int   ix, iy;
  int   bvalue = -32000;

  if (argc<4){
    fprintf(stderr, "usage : mkbadmask input.fits mask.fits clean[0 or 1]\n");
    return 0;
  }

/*
header size
*/
  hfact = gethead(argv[1]);
  headsize = hfact*2880;

/*
read the data
*/
  data=(float*)malloc(datanum*sizeof(float));
  fp=fopen(argv[1], "rb");
  fseek(fp, headsize, SEEK_SET);
  fread(data, sizeof(float), datanum, fp);
  fclose(fp);

  for (i=0; i<datanum; i++){
    swapfloat(&data[i]);
  }

  data2=(int*)malloc(xynum*sizeof(int));
  for (i=0; i<xynum; i++){
    if (data[i] < 0.5 || data[i] > 2){
      data2[i] = -1;
    } else {
      data2[i] = 0;
    }
  }

  data4=(short*)malloc(datanums*sizeof(short));

  if (atoi(argv[3]) == 1){

    /*                                                               */
    /*  a clean process ; if a good pixel is isolated                */
    /*  or associated with only one good pixel, it will be masked.   */
    /*                                                               */

    data3=(int*)malloc(xynum*sizeof(int));
    
    for (i=0; i<xynum; i++){
      ix = i % 1024;
      iy = i / 1024;
      if (ix == 0){
	if (iy == 0){
	  if (data2[1] + data2[1024] + data2[1025] < -1){
	    data3[i] = -1;
	  } else {
	    data3[i] = 0;
	  }
	} else if (iy == 1023){
	  if (data2[i-1024] + data2[i-1023] + data2[i+1] < -1){
	    data3[i] = -1;
	  } else {
	    data3[i] = 0;
	  }
	} else {
	  if (data2[i-1024] + data2[i-1023] + data2[i+1] + data2[i+1024] + data2[i+1025] < -3){
	    data3[i] = -1;
	  } else {
	    data3[i] = 0;
	  }
	}
      } else if (ix == 1023){
	if (iy == 0){
	  if (data2[i-1] + data2[i+1023] + data2[i+1024] < -1){
	    data3[i] = -1;
	  } else {
	    data3[i] = 0;
	  }
	} else if (iy == 1023){
	  if (data2[i-1025] + data2[i-1024] + data2[i-1] < -1){
	    data3[i] = -1;
	  } else {
	    data3[i] = 0;
	  }
	} else {
	  if (data2[i-1025] + data2[i-1024] + data2[i-1] + data2[i+1023] + data2[i+1024] < -3){
	    data3[i] = -1;
	  } else {
	    data3[i] = 0;
	  }
	}
      } else {
	  if (data2[i-1025] + data2[i-1024] + data2[i-1023] + data2[i-1] + data2[i+1] + data2[i+1023] + data2[i+1024] + data2[i+1025] < -6){
	    data3[i] = -1;
	  } else {
	    data3[i] = 0;
	  }
      }
    }
    
    for (i=0; i<xynum; i++){
      if(data2[i] + data3[i] < 0){
	data4[i] = bvalue;
      } else {
	data4[i] = 0;
      }
    }
    free(data3);

  } else {
    for (i=0; i<xynum; i++){
      if(data2[i] < 0){
	data4[i] = bvalue;
      } else {
	data4[i] = 0;
      }
    }
  }  /* end of an if-clause of the clean process ; argv[3]= 1 or not */

  free(data2);
  free(data);

  for (i=0; i<datanums; i++){
     swapshort(&data4[i]);
  }

  header=(char*)malloc(2880*sizeof(char)+1);
  mkheader(header, 2);  /* 2 for short */
  fp=fopen(argv[2], "wb");
  fwrite(header, sizeof(char), 2880, fp);
  fwrite(data4, sizeof(short), datanums, fp);
  fclose(fp);
  free(header);

  free(data4);

  return 0;

}


