#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "./swapfloat.c"
#include "./gethead.c"
#include "./getxynum.c"


/*
spmkix.c 
2013.4.30  improved the calculation of datanum 
*/

void swapfloat(float *f);
int gethead(char *fname);
void mkheader(char *header);
void getxynum(char *fname, int *xsize, int *ysize);
void edithead(char *header, int wx, int wy);

int main (int argc, char**argv)
{
  float  *data1,*data2,*data3,*data4,*data5;
  char   *header;
  FILE   *fp;
  int    i,xsize,ysize,xynum;
  int    datanum;
  int    headsize1,headsize2;
  int    hfact;

  if (argc < 5){
    fprintf(stderr, "usage : spmkix fname1 fname2 fname3 fname4 fname5\n");
    return 0;
  }


/*
header size for frame1
*/
  hfact=gethead(argv[1]);
  headsize1=hfact*2880;

  getxynum(argv[1],&xsize,&ysize);
  xynum=xsize*ysize;
  /* datanum=((int)(xynum*sizeof(float)/2880)+1)*2880/sizeof(float); */

  /* improved 2013.4.30 */
  if (xynum*sizeof(float)%2880 == 0){
    datanum = xynum;
  } else {
    datanum = (xynum*sizeof(float)/2880+1)*2880/sizeof(float);
  }


/*
read the data 
*/

  fp=fopen(argv[1],"rb");
  data1=(float*)malloc(xynum*sizeof(float));
  fseek(fp,headsize1,SEEK_SET);
  fread(data1,sizeof(float),xynum,fp);
  for (i=0; i<xynum; i++){
    swapfloat(&data1[i]);
  }
  fclose(fp);

  hfact=gethead(argv[2]);
  headsize2=hfact*2880;

  fp=fopen(argv[2],"rb");
  data2=(float*)malloc(xynum*sizeof(float));
  fseek(fp,headsize2,SEEK_SET);
  fread(data2,sizeof(float),xynum,fp);
  for (i=0; i<xynum; i++){
    swapfloat(&data2[i]);
  }
  fclose(fp);

  hfact=gethead(argv[3]);
  headsize2=hfact*2880;

  fp=fopen(argv[3],"rb");
  data3=(float*)malloc(xynum*sizeof(float));
  fseek(fp,headsize2,SEEK_SET);
  fread(data3,sizeof(float),xynum,fp);
  for (i=0; i<xynum; i++){
    swapfloat(&data3[i]);
  }
  fclose(fp);

  hfact=gethead(argv[4]);
  headsize2=hfact*2880;

  fp=fopen(argv[4],"rb");
  data4=(float*)malloc(xynum*sizeof(float));
  fseek(fp,headsize2,SEEK_SET);
  fread(data4,sizeof(float),xynum,fp);
  for (i=0; i<xynum; i++){
    swapfloat(&data4[i]);
  }
  fclose(fp);


/*
calculation of I
*/

  data5=(float*)malloc(datanum*sizeof(float));
  for (i=0; i<xynum; i++){
    data5[i]=0.5*(data1[i]+data2[i]+data3[i]+data4[i]);
  }


  for (i=0; i<datanum; i++){
    if (i>=xynum){
      data5[i]=0.0;
    }
    swapfloat(&data5[i]);
  }

  header=(char*)malloc(2880*sizeof(char)+1);
  mkheader(header);
  edithead(header,xsize,ysize);

  fp=fopen(argv[5],"wb");
  fwrite(header,sizeof(char),2880,fp);
  fwrite(data5,sizeof(float),datanum,fp);
  fclose(fp);

  free(data1);
  free(data2);
  free(data3);
  free(data4);
  free(data5);
  free(header);

  return 0;

}


void mkheader(char *header)
{

  int       ih;
  char      fheader[2881]="SIMPLE  =                    T / Fits standard                                  BITPIX  =                  -32 / Bits per pixel                                 NAXIS   =                    2 / Number of axes                                 NAXIS1  =                 1024 / Axis length                                    NAXIS2  =                 1024 / Axis length                                    EXTEND  =                    F / File may contain extensions                    END                                                                             ";
  char      nn[2]=" ";

  for(ih=0; ih<560; ih++){
    header[ih]=fheader[ih];
  }
  for(ih=560; ih<2880; ih++){
    header[ih]=nn[0];
  }


}



void edithead(char *header, int wx, int wy)
{

  int    ixd4,ixd3,ixd2,ixd1;
  int    iyd4,iyd3,iyd2,iyd1;
  char   cxd4[2],cxd3[2],cxd2[2],cxd1[2];
  char   cyd4[2],cyd3[2],cyd2[2],cyd1[2];

  ixd4=wx/1000;
  ixd3=(wx-ixd4*1000)/100;
  ixd2=(wx-ixd4*1000-ixd3*100)/10;
  ixd1=wx-ixd4*1000-ixd3*100-ixd2*10;
  
  sprintf(cxd4, "%d", ixd4);
  sprintf(cxd3, "%d", ixd3);
  sprintf(cxd2, "%d", ixd2);
  sprintf(cxd1, "%d", ixd1);

  iyd4=wy/1000;
  iyd3=(wy-iyd4*1000)/100;
  iyd2=(wy-iyd4*1000-iyd3*100)/10;
  iyd1=wy-iyd4*1000-iyd3*100-iyd2*10;

  sprintf(cyd4, "%d", iyd4);
  sprintf(cyd3, "%d", iyd3);
  sprintf(cyd2, "%d", iyd2);
  sprintf(cyd1, "%d", iyd1);

  header[266]=cxd4[0];
  header[267]=cxd3[0];
  header[268]=cxd2[0];
  header[269]=cxd1[0];

  header[346]=cyd4[0];
  header[347]=cyd3[0];
  header[348]=cyd2[0];
  header[349]=cyd1[0];

}
