#ifndef _INCLUDE_GRAPHICS_H_
#define _INCLUDE_GRAPHICS_H_

#include "boolean.h"
//#include "/usr/local/pgplot/cpgplot.h"
#include "cpgplot.h"

#define NWINMAX 64
#define NLABEL_IN_WIN 16
#define CPG_LABEL_LEN 300
#define CPG_TIC_LEN 20
#define NPOLYMAX 32
#define CIMAX 88 
#define CIMIN 1e-4

typedef enum {
   FORMAT_AUTO=-1, FORMAT_D, FORMAT_1F, FORMAT_2F, FORMAT_3F, FORMAT_4F,
   FORMAT_G, FORMAT_1E, FORMAT_2E
} FORMAT_TYPE ;

typedef enum {
   WIN_VPX0=0, WIN_VPX1, WIN_VPY0, WIN_VPY1,
   WIN_RANGE_VPX, WIN_RANGE_VPY,
   WIN_WX0,    WIN_WX1,  WIN_WY0,  WIN_WY1,
   WIN_RANGE_WX, WIN_RANGE_WY,
   N_WIN_PARAM_TYPE
} WIN_PARAM_TYPE ;

typedef enum {
   AXIS_X_LOW=0, AXIS_X_UP, AXIS_Y_LEFT, AXIS_Y_RIGHT,
   CPG_NAXIS
} AXIS_TYPE ;


/* ***************************** */
/*  start and finish the system  */
/* ***************************** */

void cpgstart(char *dev, double width, double aspect);
void free_axis(int nwin, int naxis);
void free_label(int nwin, int id);
void cpgfinish(void);


/* ******************************* */
/*  setting parameters of windows  */
/* ******************************* */

  /* graph_window */
Boolean check_nwin(int nwin, char *func);
double window_param( int nwin, WIN_PARAM_TYPE type );
void setvp(int nwin, double x0, double x1, double y0, double y1);
void setwin(int nwin, double x0, double x1, double y0, double y1);
void set_title(int nwin, const char *title);
void change_title_ch_lw(int nwin, double ch, int lw);
void change_title_off(int nwin, double off);
void change_frame_lw(int nwin, int lw);
int get_current_window(void);
void window(int nwin);
void undef_graph_vp(int nwin);
void undef_graph_win(int nwin);

  /* graph_axis */
Boolean check_axis(int axis, char *func);
void change_tic_lab_flag(int nwin, int axis, Boolean flag);
void change_tic_size(int nwin, int axis, double size);
void change_subtic_size(int nwin, int axis, double size);
void change_tic_ch_lw(int nwin, int naxis, double ch, int lw);
void change_subtic_lw(int nwin, int naxis, int lw);
void change_grid_lw(int nwin, int naxis, int lw);
void change_grid_ls(int nwin, int axis, int ls);
void change_axis_lab_ch_lw(int nwin, int naxis, double ch, int lw);
void change_tic_off(int nwin, int naxis, double off);
void change_axis_lab_off(int nwin, int naxis, double off);
void change_tic_ang_fjust(int nwin, int naxis, double ang, double fjust);
void change_axis_lab_ang_fjust(int nwin, int naxis, double ang, double fjust);
//void change_tic_format(int nwin, int naxis, FORMAT_TYPE type);
void frametic(int flag, double *min, double *max, double *tic);
void set_tic(int nwin, int axis, double min, double max, double step, FORMAT_TYPE type);
void set_axis_label(int nwin, int axis, const char *lab);
void copy_tic(int nwin, int axis, int ntic, const double *tic, FORMAT_TYPE type);
void copy_tic_with_lab(int nwin, int axis, int ntic, const double *tic, const char **lab);
void set_subtic(int nwin, int axis, double min, double max, double step);
void copy_subtic(int nwin, int axis, int nsubtic, double *subtic);
void set_grid(int nwin, int axis, double min, double max, double step);
void copy_grid(int nwin, int axis, int ngrid, double *grid);

  /* graph_label */
Boolean check_label_id(int id, char *func);
void set_label(int nwin, int id, double x, double y, const char *label);
void change_label_xy(int nwin, int id, double x, double y);
void change_label_ang_fjust(int nwin, int id, double ang, double fjust);
void change_label_ch_lw(int nwin, int id, double ch, int lw);
void change_label_lab(int nwin, int id, const char *label);
void switch_label_disp(int nwin, int id, Boolean flag);

  /* graph_window */
void mkframe(int nwin);

  /*  plot utility  */
void xyplot (int num, double x[], double y[], int symbol);
void xyplot_ex (int num, double x[], double y[], double xe[], int symbol);
void xyplot_ey (int num, double x[], double y[], double ye[], int symbol);
void xyplot_exy (int num, double x[], double y[], double xe[], double ye[], int symbol);
void draw_error_bar(double xcen, double ycen, double xerror, double yerror);
void plcurve(double x0, double x1, double step, double (*pfunc)(double x));
void drawline(double a, double b, double x0, double x1);
void drawpara(double a, double b, double c, double x0, double x1, double dx);
void plot_polygon_line (int ndata, double x[], double y[]);
void plot_histogram (int ndata, double x[], double y[]);

   /*  geometry condition  */
int inside( double xp, double yp, int num, double x[], double y[] );
int online( double x0, double y0, double xp, double yp, double x1, double y1);
int sideLR( double xp, double yp, double x0, double y0, double x1, double y1 );
int concave( int num, double x[], double y[]);
/* return 0 if (xp,yp) is within the window, 1 otherwise */
Boolean in_window_or_not(int nwin, double xp, double yp);

   /*  utility for setting color  */
void set_graph_cimax(int cimax);
void set_colorfunc(int colorfunc);
void setcolors(int nstep);
void setgrays(int nstep);
int colorscale(double scale);
void colorlegend(int nwin, double vmin, double vmax);
void askcolorscale(void);
void setcolorscale(double value, double vmin, double vmax);

   /*  interactive utility  */
#define NMAX_SELECT_FIELD 10
#define NMAX_SELECT_KEY 20
char mouse_get_coo( int nwin, double *x, double *y);
int mouse_get_points( int nwin, int get[], int ndata, double x[], double y[], double tolerance, int ndatamax);
int mouse_put_points( int nwin, double x[], double y[] , int ndatamax);
int mkpolygon( double x[], double y[], void (*plotpgbg)(void));
void set_select_field ( int nwin, int num_select, int align,
                       double x0, double x1, double y0, double y1 );
int set_select_field_key ( int field, char key[] );
int mouse_select_field( int nwin );


#endif
