#ifndef _INCLUDE_OPM_PARAM_H_
#define _INCLUDE_OPM_PARAM_H_

#include <stdio.h>
#include "boolean.h"

typedef struct _opm_param {
   Boolean mirror, rotate, cut1, cut2;
   double magnify, angle, xcen, ycen, size;
   double pv_limit, radius, epsilon, matching, mag_cut1, mag_cut2;
   int nset, nverify, niter;
} opm_param;

void set_opm_param(opm_param *p, char *file);
void set_opm_param1(int mode, opm_param *p, char *item);
void get_opm_param_default(opm_param *p);
Boolean get_opm_mirror(opm_param *p);
double get_opm_magnify(opm_param *p);
Boolean get_opm_rotate(opm_param *p);
double get_opm_angle(opm_param *p);
double get_opm_xcen(opm_param *p);
double get_opm_ycen(opm_param *p);
double get_opm_size(opm_param *p);
Boolean get_opm_cut1(opm_param *p);
double get_opm_mag_cut1(opm_param *p);
Boolean get_opm_cut2(opm_param *p);
double get_opm_mag_cut2(opm_param *p);
int get_opm_nset(opm_param *p);
int get_opm_nverify(opm_param *p);
double get_opm_pv_limit(opm_param *p);
double get_opm_epsilon(opm_param *p);
double get_opm_radius(opm_param *p);
double get_opm_matching(opm_param *p);
int get_opm_niter(opm_param *p);
void print_opm_param(FILE *fp, opm_param *p);
void print_opm_param_file(FILE *fp, opm_param *p);

#endif
