#ifndef _INCLUDE_WCS_H_
#define _INCLUDE_WCS_H_

/* ---------------------------------------------------------------------
	World Coordinate System 
		calc_xy : calculate (x, y) on the plotted frame 
			from (alpha, delta) and (alpha_c, delta_c) 
			This is the same as wcs (x, y) 
		wcs_xy : calculate wcs (x, y) 
			from (alpha, delta) and (alpha_c, delta_c) 
		wcs : calculate (alpha, delta) 
			from (alpha_c, delta_c) and wcs (x, y) 
*---------------------------------------------------------------------- */

void calc_xy( double alpha_c, double delta_c, double alpha, double delta, double *wcs_x, double *wcs_y );
/* ---------------------------------------------------------------------
 Calculate x and y from alpha and deta 
	alpha_c	: ceter of Right Ascention (radian) 
	delta_c	: ceter of Decrination  (radian) 
	alpha	: Right Ascention (radian) of object 
	delta	: Decrination (radian) of object 
	wcs_x	: relative x value from the center on the plotted image 
		  East (left) is + and West (right) is -
	wcs_y	: relative y value from the center on the plotted image 
		  North is + and South is - 
		written on 11/02/2000 by T. Tanabe 
*----------------------------------------------------------------------
*/ 

/* Angular distance of 2 position, (alpha1, delta1) (alpha2, delta2) */
double adist( double alpha1, double delta1, double alpha2, double delta2 );

#endif
