#ifndef _INCLUDE_XYM_H_
#define _INCLUDE_XYM_H_

#include <stdio.h>
typedef struct _xym *xym;

#define FORMAT_XYM_IN "%lf %lf %lf"
#define FORMAT_XYM_OUT "%10.3f %10.3f %10.3f\n"

xym *load_xym(char *file, int *num);
xym malloc_xym(void);
void set_xym(xym p, int id, double x, double y, double m, void *data);
void destroy_xym(int ndata, xym *p);
void print_xym(FILE *fp, xym p);
int get_xym_id(xym p);
double get_xym_x(xym p);
double get_xym_y(xym p);
double get_xym_m(xym p);
double get_xym_xorg(xym p);
double get_xym_yorg(xym p);
double get_xym_morg(xym p);
void *get_xym_data(xym p);
void scale_xym(int ndata, xym *data, double scale);
void mirror_xym_x(int ndata, xym *data);
void mirror_xym_y(int ndata, xym *data);
void xym_tran(int ndata, xym *data, double *coef);
void sort_xym_x(int ndata, xym *data);
void sort_xym_m(int ndata, xym *data);
int binsearch_xym_m(double m, int ndata, xym *data);

#endif
