# coding: utf-8

from numpy import array
from framework import Component, Port, Variable, Frame, iscontain
from framework import DoubleVar, IntVar, StringVar, BooleanVar
from widgets import GridPane, Menu
from inspect import getmembers, stack, getargvalues
import Tkinter

class EasyComponent(Component):
    PLOTTER = None
    def __init__(self,master):
        Component.__init__(self,master)
        self.colcount = 0
        self._menu    = None
        self.sig_out  = Port(Variable(array([])))
    def gui(self,master,pltcnf={},cnf={},**kw):
        frm = Frame(master)
        if not self.PLOTTER == None:
            v = self.__class__.PLOTTER(frm,pltcnf); v.plot(); v.show(); v.pack()
            setattr(frm,'plotter',v)
            self.sig_out.insertlink(0,v.sig_in);
        o = EasyGrid(frm,self); o.pack()
        return frm
    def menu(self,master,cnf={},**kw):
        if self._menu == None:
            return None
        else:
            menu = EasyMenu(master,list=self._menu,cnf=cnf,**kw)
            return menu

class EasyPort(Port):
    def __init__(self,variable,label=None,var=None,key=None):
        Port.__init__(self,variable);
        if label == None:
            self.label = ''
        else:
            self.label = label
        if var == None:
            if type(variable.get()) == float:
                self.tkvar = DoubleVar(self)
            elif type(variable.get()) == int:
                self.tkvar = IntVar(self)
            elif type(variable.get()) == bool:
                self.tkvar = BooleanVar(self)
            else:
                self.tkvar = StringVar(self)
        else:
            self.tkvar = var(self)
        if key == None:
            caller       = self._caller()
            caller.colcount += 1
            self.sortkey = caller.colcount
        else:
            self.sortkey = key
    def _caller(self):
        '''
        下記ブログに掲載されていたコードを使わせてもらった
        http://d.hatena.ne.jp/Kazumi007/20090914/1252915940
        '''
        try:
            framerecords = stack()
            framerecord  = framerecords[2]
            frame        = framerecord[0]
            arginfo      = getargvalues(frame)
            return arginfo.locals['self'] if 'self' in arginfo.locals else None
        finally:
            del frame
        return None

class EasyGrid(GridPane):
    def __init__(self,master,component,cnf={},**kw):
        GridPane.__init__(self,master,cnf,**kw)
        ms = getmembers(component,lambda x:iscontain(x,EasyPort))
        ms.sort(lambda x,y:cmp(x[1].sortkey,y[1].sortkey))
        for m,o in ms:
            self.entry(o.label,o.tkvar)
            # self.append(o.label,Entry(self,textvariable=o.tkvar))

class EasyMenu(Menu):
    def __init__(self,master=None,list=None,cnf={},**kw):
        Menu.__init__(self,master,cnf,**kw)
        for m in list: self.add_children(self,m)
    def add_children(self,parent,children):
        if type(children[1]) == list:
            cascade = Tkinter.Menu(parent)
            parent.add_cascade(label=children[0],menu=cascade)
            for m in children[1:]: self.add_children(cascade,m)
        else:
            label,func = children
            parent.add_command(label=label,command=func)

