# coding: utf-8

import Tkinter

def popcnf(key,cnf):
    item = None
    if cnf.has_key(key):
        item = cnf[key]
        del cnf[key]
    return item

def root(title='tk'):
    root = Tkinter.Tk()
    root.title(title)
    return root

def toplevel(master=None,title='tk',cnf={},**kw):
    if kw: cnf = Tkinter._cnfmerge((cnf,kw))
    top = Tkinter.Toplevel(master,cnf)
    top.title(title)
    return top

def popup_button(master,command,label='',title='tk',cnf={},**kw):
    if kw: cnf = Tkinter._cnfmerge((cnf,kw))
    popup = lambda: command(toplevel(master,title,cnf)).pack()
    return Tkinter.Button(master,text=label,command=popup)

class Entry(Tkinter.Entry):
    def __init__(self,master=None,cnf={},**kw):
        if kw: cnf = Tkinter._cnfmerge((cnf,kw))
        if cnf.has_key('textvariable'):
            v = cnf['textvariable']
            del cnf['textvariable']
            Tkinter.Entry.__init__(self,master,cnf)
            self.config(textvariable=v)
            self.bind('<Return>',v.fixed)
            self.bind('<Leave>',v.update)
        else:
            Tkinter.Entry.__init__(self,master,cnf)

class Menu(Tkinter.Menu):
    def __init__(self,master=None,cnf={},**kw):
        if kw: cnf = Tkinter._cnfmerge((cnf,kw))
        popup = popcnf('popup',cnf)
        Tkinter.Menu.__init__(self,master,cnf)
        self.cbname_ctrl_b1 = None
        self.cbname_b3 = None
        if popup:
            self.cbname_ctrl_b1 = master.bind("<Control-Button-1>", self._rclicked)
            self.cbname_b3 = master.bind(self._right_button(), self._rclicked)
    def _rclicked(self,e):
        self.tk_popup(e.x_root, e.y_root)
    def _right_button(self):
        import platform
        if platform.system() == 'Darwin':
            rbtn = '<Button-2>'
        else:
            rbtn = '<Button-3>'
        return rbtn
    def destroy(self):
        if not self.cbname_ctrl_b1 == None:
            self.master.unbind('<Control-Button-1>',self.cbname_ctrl_b1)
        if not self.cbname_b3 == None:
            self.master.unbind(self._right_button(),self.cbname_b3)
        Tkinter.Menu.destroy(self)

class TriggerButton(Tkinter.Button):
    def __init__(self,master=None,cnf={},**kw):
        if kw: cnf = Tkinter._cnfmerge((cnf,kw))
        if cnf.has_key('variable'):
            v = cnf['variable']
            del cnf['variable']
            Tkinter.Button.__init__(self,master,cnf)
            self.config(command=v.fixed)
        else:
            Tkinter.Button.__init__(self,master,cnf)

class PopupButton(Tkinter.Button):
    def __init__(self,master=None,command=None,label='',title='tk',cnf={},**kw):
        if kw: cnf = Tkinter._cnfmerge((cnf,kw))
        popup = lambda: command(toplevel(master,title)).pack()
        Tkinter.Button.__init__(self,master,cnf)
        self.config(text=label,command=popup)

class TriggerCheckbutton(Tkinter.Checkbutton):
    def __init__(self,master=None,cnf={},**kw):
        if kw: cnf = Tkinter._cnfmerge((cnf,kw))
        if cnf.has_key('variable'):
            Tkinter.Checkbutton.__init__(self,master,cnf)
            self.config(command=cnf['variable'].fixed)
        else:
            Tkinter.Checkbutton.__init__(self,master,cnf)
    
# Checkbuttonは必ずしも決まったトリガの使い方ではないのでオーバーライドしない。
# Checkbutton(master,variable=comp.port.variable)

class GridPane(Tkinter.Frame):
    def entry(self,label='',*variables):
        widgets = [Entry(self,textvariable=v) for v in variables]
        self.append(label,*widgets)
    def trigger(self,label='',*variables):
        widgets = [TriggerButton(self,text=label,variable=v) for v in variables]
        row = self.grid_size()[1]
        for i,w in enumerate(widgets): w.grid(row=row,column=i+1,sticky='EW')
    def popup(self,label='',command=None,title='tk',cnf={},**kw):
        if kw: cnf = Tkinter._cnfmerge((cnf,kw))
        popup = lambda: command(toplevel(self.master,title,cnf)).pack()
        widget = Tkinter.Button(self,text='console',command=popup)
        self.append(label,widget)
    def entry_with_tcb(self,label,booleanvar,*variables):
        row = self.grid_size()[1]
        frm = Tkinter.Frame(self)
        TriggerCheckbutton(frm,variable=booleanvar).pack(side=Tkinter.LEFT)
        Tkinter.Label(frm,text=label).pack(side=Tkinter.LEFT)
        frm.grid(row=row,column=0)
        widgets = [Entry(self,textvariable=v) for v in variables]
        for i,w in enumerate(widgets): w.grid(row=row,column=i+1)
    def triggered_checkbutton(self,label,booleanvar):
        row = self.grid_size()[1]
        TriggerCheckbutton(self,variable=booleanvar,text=label).grid(row=row,column=0)
#        Tkinter.Label(self,text=label).grid(row=row,column=1)
    def append(self,label='',*widgets):
        row = self.grid_size()[1]
        Tkinter.Label(self,text=label).grid(row=row,column=0)
        for i,w in enumerate(widgets): w.grid(row=row,column=i+1)
    #
    def wappend(self,*widgets):
        row = self.grid_size()[1]
        for i,w in enumerate(widgets): w.grid(row=row,column=i)
    def wtrigger(self,*labelvariables):
        return [TriggerButton(self,text=l,variable=v) for l,v in labelvariables]

class Projection:
    @classmethod
    def db(cls):
        from scipy import log10
        return {'forward'  : lambda x: 10*log10(x),
                'backward' : lambda x: 10**(x/10.)}
