# coding: utf-8
import inst
import term
import utils
import Tkinter
import tkFileDialog
import ttk
import inspect
import os
import os.path
import imp
import weakref
import random
import numpy
import uuid
import functools
import xml.dom.minidom as minidom
import sys
import types

def get_chef(master):
    while master.master.__class__ is not Chef: master = master.master
    return master.master

class Chef(ttk.Frame):
    class Menu(Tkinter.Menu):
        def __init__(self,master=None,obj=None,cnf={},**kw):
            Tkinter.Menu.__init__(self,master,cnf,**kw)
            filemenu = Tkinter.Menu(self,tearoff=0)
            filemenu.add_command(label='Load',command=master.load)
            filemenu.add_command(label='Save',command=master.save)
            #filemenu.add_separator()
            #filemenu.add_command(label='Reload',command=master.reload)
            filemenu.add_separator()
            filemenu.add_command(label='Clear',command=master.clear)
            self.add_cascade(label='File',menu=filemenu)
    def __init__(self,master=None,**kw):
        ttk.Frame.__init__(self,master,**kw)
        self.pylaf = imp.load_module('pylafii',*imp.find_module('pylafii'))
        Canvas(self,name='note',width=640,height=400).pack(side=Tkinter.LEFT,anchor=Tkinter.NE,fill=Tkinter.BOTH,expand=True)
        ModuleManager(self,name='mmanage').pack(anchor=Tkinter.NE,fill=Tkinter.Y,expand=True)
        master.config(menu=self.Menu(self,name='menu'))
    def pick_component(self):
        return self.children['mmanage'].component
    def invoke_commander(self):
        pass
    def load(self):
        filename = tkFileDialog.askopenfilename(filetypes=[('netlist','*.xml'),])
        if not filename:
            return
        file = open(filename,'r')
        netlist = file.read()
        self.load_netlist(netlist)
    def load_netlist(self,netlist):
        canvas = self.children['note']
        xdoc = minidom.parseString(netlist)
        module_elements = xdoc.getElementsByTagName('module')
        for element in module_elements:
            name = element.getAttribute('name')
            self.children['mmanage'].import_modules(name)
        #
        mytypes = {u"<type 'complex'>":types.ComplexType,
                   u"<type 'int'>":types.IntType,
                   u"<type 'bool'>":types.BooleanType,
                   u"<type 'float'>":types.FloatType,
                   u"<type 'str'>":types.StringType,
                   u"<type 'numpy.float64'>":numpy.float64}
        logic_elements = xdoc.getElementsByTagName('logic')
        for element in logic_elements:
            name = element.getAttribute('name')
            module_name = element.getAttribute('module')
            cls_name = element.getAttribute('cls')
            cls = sys.modules[module_name].__dict__[cls_name]
            locx = element.getAttribute('locx')
            locy = element.getAttribute('locy')
            logic = cls(canvas.root,name=name)
            if isinstance(logic,self.pylaf.AutoTrigger):
                logic.new_widget(self)
            for terminal_element in element.childNodes:
                name = str(terminal_element.getAttribute('name'))
                type = terminal_element.getAttribute('type')
                value = mytypes[type](terminal_element.getAttribute('value'))
                logic.__class__.__dict__[name].get_attribute(logic).node.value = value
            canvas._buffer_location[logic] = (int(locx),int(locy))
        #
        node_elements = xdoc.getElementsByTagName('node')
        for element in node_elements:
            terminals = []
            for terminal_element in element.childNodes:
                owner = terminal_element.getAttribute('owner')
                name = terminal_element.getAttribute('name')
                terminals.append((canvas.root.children[owner],name))
            self.pylaf.connect(*terminals)
        #print(xdoc.toxml())
    def save(self):
        netlist = self.save_netlist()
        filename = tkFileDialog.asksaveasfilename()
        file = open(filename,'w')
        file.write(netlist)
    def save_netlist(self):
        impl = minidom.getDOMImplementation()
        xdoc = impl.createDocument(None, 'netlist', None)
        root = xdoc.documentElement
        canvas = self.children['note']
        logics = canvas.following_logics
        #
        xml_modules = {}
        for logic in logics:
            module = inspect.getmodule(logic)
            name = module.__name__
            filename = module.__file__
            package_name = module.__package__
            xml_modules[package_name] = None
        #
        xml_logics = []
        for logic in logics:
            ct = canvas.following_logics[logic]()
            values = {}
            xml_logics.append(({'name':logic.name,
                               'module':inspect.getmodule(logic).__name__,
                               'cls':logic.__class__.__name__,
                               'locx':'%d' % ct.loc[0],
                               'locy':'%d' % ct.loc[1]
                               },values))
            for item in ct._canvas_terminals:
                value = item().attribute.node.value
                type_value = type(value)
                #types.FloatType
                if not (value is None or
                        type_value == types.InstanceType or
                        type_value == numpy.ndarray or
                        type_value == types.TupleType or
                        type_value == types.ListType):
                    values[item().name] = (str(type_value),str(value))
        #
        xml_nodes = []
        for item in canvas.following_nodes.itervalues():
            if len(item()._canvas_links) > 1:
                xml_node = []
                links = [o() for o in item()._canvas_links]
                for link in links:
                    terminal = link._canvas_terminal()
                    owner = terminal.attribute.owner()
                    xml_node.append({'name':terminal.name,'owner':owner.name})
                    # print terminal,owner,owner.name,terminal.name
#                xml_node.append(terminal.attribute.node.value)
                xml_node.append('')
                xml_nodes.append(xml_node)
        # compose xml
        for name in xml_modules:
            e = xdoc.createElement('module')
            e.setAttribute('name',name)
            root.appendChild(e)
        for attributes,values in xml_logics:
            e = xdoc.createElement('logic')
            for k,v in attributes.iteritems():
                e.setAttribute(k,v)
            root.appendChild(e)
            for k,v in values.iteritems():
                t,vl = v
                c = xdoc.createElement('terminal')
                c.setAttribute('name',k)
                c.setAttribute('type',t)
                c.setAttribute('value',vl)
                e.appendChild(c)
        for node in xml_nodes:
            terminals,value = node[:-1],node[-1]
            e = xdoc.createElement('node')
            e.setAttribute('value',value)
            for property in terminals:
                c = xdoc.createElement('terminal')
                for k,v in property.iteritems():
                    c.setAttribute(k,v)
                e.appendChild(c)
            root.appendChild(e)
        return xdoc.toxml()
        #e = xdoc.createTextNode('test')
        #root.appendChild(e)
#        print(xdoc.toxml())
    def clear(self):
        canvas = self.children['note']
        canvas.clear()
    def reload(self):
        canvas = self.children['note']
        canvas.reload()
        
class ModuleManager(ttk.Treeview):
    def __init__(self,master=None,**kw):
        ttk.Treeview.__init__(self,master,selectmode='browse',**kw)
        self.components = {}
        self.extract_components(self.chef.pylaf)
        self.modules = []
        self.load_package_id = self.insert('','end',text='load package ...')
        self.working_dir = ''
        self.bind('<<TreeviewSelect>>', self.selected)
        self.loop()
    @property
    def chef(self):
        return get_chef(self)
    @property
    def component(self):
        id = self.selection()
        if id:
            for k,v in self.components.iteritems():
                if v == id[0]:
                    return k
            return # module was selected
        else:
            return
    def selected(self,e):
        id = self.selection()[0]
        if id == self.load_package_id:
            self.select_package()
    def select_package(self):
        cwd = tkFileDialog.askdirectory(initialdir=self.working_dir)
        if not cwd:
            return
        cwd,name = os.path.split(cwd)
        self.import_modules(name)
    def import_modules(self,name):
        name = name.replace('.py','')
#        try:
#            m = imp.load_module(name,*imp.find_module(name))
#        except SyntaxError: print 'Syntax Error', name
#        except ImportError: print 'Import Error', name
#        except AttributeError: print 'Attribute Error', name
        m = imp.load_module(name,*imp.find_module(name))
        self.extract_components(m)
    def extract_components(self,module):
        items = inspect.getmembers(module,lambda x:inspect.isclass(x))
        for key,cls in items:
            for c in inspect.getmro(cls):
                if c is inst.Logic or c is self.chef.pylaf.Logic:
                    if cls not in self.components:
                        self.components[cls] = None
    def loop(self):
        self.populate()
        self.after(500,self.loop)
    def populate(self):
        for cls,nodeid in self.components.iteritems():
            if nodeid:
                continue
            path = cls.__module__.split('.')
            parent = self.populate_module(path)
            items = [self.item(id)['text'] for id in self.get_children(parent)]
            self.components[cls] = self.insert(parent,0,text=cls.__name__)
    def populate_module(self,path,parent=''):
        if not path:
            return parent
        items = [self.item(id)['text'] for id in self.get_children(parent)]
        if path[0] not in items:
            parent = self.insert(parent,0,text=path[0])
        else:
            for id in self.get_children(parent):
                if path[0] == self.item(id)['text']:
                    parent = id
                    break
        return self.populate_module(path[1:],parent)
        
class Event(object):
    @term.event()
    def _event(self):
        self.new_callbacks()
        sequence,e = self._event
        if sequence in self._callbacks:
            self._callbacks[sequence](e)
    def bind(self,sequence,func):
        self.new_callbacks()
        self._callbacks[sequence] = func
    def generate(self,sequence,e=None):
        self._event = (sequence,e)
    def join(self,event):
        term.connect((event,'_event'),(self,'_event'))
    def new_callbacks(self):
        try:
            self._callbacks
        except AttributeError:
            self._callbacks = {}
        
class CanvasItem(object):
    def __init__(self,canvas,tag=None,loc=None):
        canvas._items.append(self)
        self._canvas = weakref.ref(canvas)
        self._tkevent_id = {}
        self._items = []
        if tag:
            self.tag = tag
        else:
            self.tag = str(uuid.uuid4())
        if loc:
            self.loc = loc
        else:
            self.loc = [200*random.random()+100,200*random.random()+50]
        self.event = Event()
        self.event.join(canvas.canvas_event)
    @property
    def canvas(self):
        return self._canvas()
    def draw(self,shape):
        for cmd,args,kwargs in shape:
            if cmd is 'rectangle':
                loc = numpy.array(self.loc)
                start,end = args
                self._items.append(self.canvas.create_rectangle(*(list(loc+start)+list(loc+end)),tags=self.tag,**kwargs))
            elif cmd is 'text':
                x,y = self.loc
                ox,oy = args
                self._items.append(self.canvas.create_text(x+ox,y+oy,tags=self.tag,**kwargs))
            elif cmd is 'oval':
                loc = numpy.array(self.loc)
                start,end = args
                self._items.append(self.canvas.create_oval(*(list(loc+start)+list(loc+end)),tags=self.tag,**kwargs))
            elif cmd is 'line':
                loc = numpy.array(self.loc)
                coords = []
                for arg in args:
                    x,y = loc+arg
                    coords.append(x)
                    coords.append(y)
                self._items.append(self.canvas.create_line(*coords,tags=self.tag,**kwargs))
            elif cmd is 'polygon':
                loc = numpy.array(self.loc)
                coords = []
                for arg in args:
                    x,y = loc+arg
                    coords.append(x)
                    coords.append(y)
                self._items.append(self.canvas.create_polygon(*coords,tags=self.tag,**kwargs))
            elif cmd is 'window':
                x,y = self.loc
                ox,oy = args
                self._items.append(self.canvas.create_window(x+ox,y+oy,tags=self.tag,**kwargs))
    def bind(self,sequence,func):
        self._tkevent_id[sequence] = self.canvas.tag_bind(self.tag,sequence,func)
    def move(self,dx,dy):
        for tag in self._items:
            self.canvas.move(tag,dx,dy)
        x,y = self.loc
        self.loc = (x+dx,y+dy)
    def destroy(self):
#        del self.event
        self.event = None
        for sequence,id in self._tkevent_id.iteritems():
            self.canvas.tag_unbind(self.tag,sequence,id)
        if self in self.canvas._items: # CanvasLinkの廃棄処理が完了する前にもう一度呼び出されてしまうバグへの応急処置
            self.canvas._items.remove(self)
    def erase(self):
        for id in self._items:
            self.canvas.delete(id)
        del self._items[:]
    def __del__(self):
        # イベントをバインドした状態だとオブジェクトが消去されないことに注意
        self.erase()
        # print 'removed', self.__class__.__name__
        
class CanvasLogic(CanvasItem):
    class Menu(Tkinter.Menu):
        def __init__(self,master=None,obj=None,cnf={},**kw):
            Tkinter.Menu.__init__(self,master,cnf,**kw)
            self.add_command(label='remove',command=obj.remove_logic)
    def __init__(self,canvas,logic,tag=None,loc=None):
        if logic in canvas._buffer_location:
            loc = canvas._buffer_location[logic]
            del canvas._buffer_location[logic]
        CanvasItem.__init__(self,canvas,tag,loc)
        self._logic = weakref.ref(logic)
        self._canvas_terminals = utils.weakvaluelist.WeakValueList()
        self.draw(self.shape)
        self.generate_canvas_terminals()
        self.bind('<Button1-Motion>',self.leftdrag)
        self.bind('<Double-Button-1>',self.popup_equipment)
        self.bind('<Button-2>',lambda e:self.canvas.rmenu_queue.append((self.Menu,self,e)))
        self.event.bind('<<CheckModel>>',self.check_model)
#    def draw(self,shape):
#        print self.logic,shape
#        CanvasItem.draw(self,shape)
    def leftdrag(self,e):
        try:
            self._start
        except AttributeError:
            self._start = None
        if self._start is None:
            self._start = [e.x,e.y]
            return
        x0,y0 = self._start
        dx,dy = e.x-x0,e.y-y0
        self._start = [e.x,e.y]
        self.move(dx,dy)
        for item in self._canvas_terminals:
            item().move(dx,dy)
    @property
    def shape(self):
        cmd = [('rectangle',((-50,-20),(50,20)),{'width':1,'fill':'#FFFFF0'}),
               ('text',(0,-8),{'text':self.logic.name}),
               ('text',(0,8),{'text':self.logic.__class__.__name__})]
        return cmd
    @property
    def logic(self):
        return self._logic()
    @property
    def terminals(self):
        terminals = {}
        for cls in inspect.getmro(self.logic.__class__):
            for k in cls.__dict__:
                v = cls.__dict__[k]
                if isinstance(v,self.canvas.chef.pylaf.Terminal):
                    if not k in terminals: terminals[k] = v
        return terminals
    def generate_canvas_terminals(self):
        def generate(terminals,xoffset=0,yoffset=0,direction=Tkinter.LEFT):
            yoffset = -16 * (len(terminals) - 1) / 2
            for tname,terminal in terminals.iteritems():
                attr = terminal.attr(self.logic)
                canvas_terminal = CanvasTerminal(self.canvas,attr,direction=direction,tag=self.tag,loc=(x+xoffset,y+yoffset),name=tname)
                self.canvas.following_terminals[attr] = weakref.ref(canvas_terminal)
                self._canvas_terminals.append(canvas_terminal)
                yoffset += 16
        x,y = self.loc
        lterminals,rterminals = {},{}
        for tname,terminal in self.terminals.iteritems():
            if isinstance(terminal,self.canvas.chef.pylaf.Rule):
                rterminals[tname] = terminal
            else:
                lterminals[tname] = terminal
        generate(lterminals,-50,direction=Tkinter.LEFT)
        generate(rterminals,50,direction=Tkinter.RIGHT)
    # for Canvas Event
    def check_model(self,e): # <<CheckModel>>
        if not self.logic:
            self.destroy()
    # for Tk Event
    def popup_equipment(self,e):
        chef = self.canvas.chef
        if isinstance(self.logic,chef.pylaf.Arrange):
            arrange = self.logic
        else:
            for key,logic in self.logic.children.iteritems():
                if isinstance(logic,chef.pylaf.Arrange):
                    arrange = logic
                    break
            else:
                chef.pylaf.Equipment(Tkinter.Toplevel(chef),self.logic.__class__,mount=False).mount(self.logic)
                return
        chef.pylaf.create_window(Tkinter.Toplevel(chef),arrange)
    # for Popup Menu
    def remove_logic(self):
        self.logic.destroy()
        
class CanvasTerminal(CanvasItem):
    class Menu(Tkinter.Menu):
        def __init__(self,master=None,obj=None,cnf={},**kw):
            Tkinter.Menu.__init__(self,master,cnf,**kw)
            self.add_command(label='disconnect',command=obj.disconnect_terminal)
    def __init__(self,canvas,attribute,direction=Tkinter.LEFT,tag=None,loc=None,name=None):
        CanvasItem.__init__(self,canvas,'%s:%s' % (tag,name),loc)
        self._attribute = weakref.ref(attribute)
        self.ishilighted = False
        self.isstayed = False
        self.name = name
        self.direction = direction
        self.draw(self.shape)
        self.generate_canvas_nodes()
        self.bind('<Button-1>',self.check_terminal)
        self.bind('<Button-2>',lambda e:self.canvas.rmenu_queue.append((self.Menu,self,e)))
        self.bind('<Enter>',self.enter)
        self.bind('<Leave>',self.leave)
        self.event.bind('<<CheckModel>>',self.check_model)
    def highlight(self):
        self.canvas.itemconfig(self._items[0],width=2)
        self.ishilighted = True
    def lowlight(self):
        self.canvas.itemconfig(self._items[0],width=1)
        self.ishilighted = False
    def enter(self,e):
        self.highlight()
        self.isstayed = True
    def leave(self,e):
        self.lowlight()
        self.isstayed = False
    @property
    def attribute(self):
        return self._attribute()
    @property
    def shape(self):
        if self.direction == Tkinter.LEFT:
            return [('oval',((-3,-3),(3,3)),{'width':1,'fill':'#FFFFFF'}),
                    ('text',(-6,0),{'text':self.name,'anchor':Tkinter.E})]
        else:
            return [('oval',((-3,-3),(3,3)),{'width':1,'fill':'#FFFFFF'}),
                    ('text',(6,0),{'text':self.name,'anchor':Tkinter.W})]
    def generate_canvas_nodes(self):
        node = self.attribute.node
        if node not in self.canvas.following_nodes:
            canvas_node = CanvasNode(self.canvas,node)
            self.canvas.following_nodes[node] = weakref.ref(canvas_node)
    def check_model(self,e):
        if not self.isstayed:
            if not self.ishilighted and self.attribute in self.canvas._buffer_link:
                self.highlight()
            if self.ishilighted and self.attribute not in self.canvas._buffer_link:
                self.lowlight()
        if not self.attribute:
            self.destroy()
    def check_terminal(self,e):
        #print self.attribute.owner(),self.name
        self.canvas._buffer_link.append(self.attribute)
        self.canvas.link()
    # for Popup Menu
    def disconnect_terminal(self):
        # 切断するターミナルを参照しているCanvasLinkインスタンスを廃棄する
        node = self.attribute.node
        canvas_node = self.canvas.following_nodes[node]()
        for canvas_link in canvas_node._canvas_links:
            if self is canvas_link()._canvas_terminal():
                canvas_node._canvas_links.remove(canvas_link())
                canvas_link().destroy()
                break
        # node を複製してすり替える
        new_node = self.canvas.chef.pylaf.Node(node.value)
        self.attribute.unregister()
        self.attribute.register(new_node)
        # 新しくCanvasNodeインスタンスを生成して関連づける
        self.generate_canvas_nodes()
        
class CanvasNode(CanvasItem):
    def __init__(self,canvas,node,tag=None,loc=None):
        CanvasItem.__init__(self,canvas,tag,loc)
        self._node = weakref.ref(node)
        self._canvas_links = utils.weakvaluelist.WeakValueList()
        self.event.bind('<<CheckModel>>',self.check_model)
    @property
    def node(self):
        return self._node()
    def check_model(self,e):
        if self.node == None:
            if self not in self.canvas.removing_candidate: # CanvasLinkを生成するときに余分にイベントを発行してしまうバグの影響で複数回リストへ登録してしまうことがあるので緊急対処
                self.canvas.removing_candidate.append(self)
            return
#        self.check_node()
        self.check_link()
#    def check_node(self):
#        # Node がすり替わっていれば node を更新する
#        if self.node is not None:
#            print self.node.get_observers()
#        if self.node == None:
#            self.destroy()
#        if len(self._canvas_links) > 1:
#            print self,self.node,self.node in [o for o in self.canvas.following_nodes.iterkeys()]
#        if self.node == None:
#            if self._canvas_links:
#                # 生存しているターミナルのうちひとつを canvas_terminal とする
#                canvas_terminals = [o().canvas_terminal for o in self._canvas_links]
#                for canvas_terminal in canvas_terminals:
#                    if canvas_terminal:
#                        # print canvas_terminal
#                        break
#                if canvas_terminal:
#                    self._node = weakref.ref(canvas_terminal.attribute.node)
#                else:
#                    self.destroy()
    def check_link(self):
        node = self.node
#        if node == None: return
        # フォローしているターミナルのリストを作成する
        canvas_terminals = []
        for attr in node.observers_:
            if attr not in self.canvas.following_terminals:
                continue
            canvas_terminals.append(self.canvas.following_terminals[attr]())
        # ターミナルの重心をノード位置に指定
        loc = numpy.zeros(2)
        for cterm in canvas_terminals:
            loc += numpy.array(cterm.loc)
        self.loc = loc / len(canvas_terminals)
        #
        for canvas_terminal in canvas_terminals:
            self._canvas_links.cleanup()
#            if len(self._canvas_links) > 1:
#                print canvas_terminal, [canvas_link()._canvas_terminal() for canvas_link in self._canvas_links]
            if canvas_terminal not in [canvas_link()._canvas_terminal() for canvas_link in self._canvas_links]:
                try:
                    self.__check_recursive
                except AttributeError:
                    self.__check_recursive = None
                else:
                    del self.__check_recursive
                    return
                canvas_link = CanvasLink(self.canvas,self,canvas_terminal)
                self._canvas_links.append(canvas_link)
#        if len(self._canvas_links) > 1:
#            print self._canvas_links[0]()._canvas_terminal().attribute.owner(),self._canvas_links
    def destroy(self):
        # 関連する link を先に破壊する
        for link in self._canvas_links:
            if link():
                link().destroy()
        CanvasItem.destroy(self)

class CanvasLink(CanvasItem):
    def __init__(self,canvas,canvas_node,canvas_terminal,tag=None,loc=(0,0)):
        CanvasItem.__init__(self,canvas,tag,loc)
        self._canvas_node = weakref.ref(canvas_node)
        self._canvas_terminal = weakref.ref(canvas_terminal)
        self.sx, self.sy = self.canvas_node.loc
        self.ex, self.ey = self.canvas_terminal.loc
        self.draw(self.shape)
        self.event.bind('<<CheckModel>>',self.check_model)
    @property
    def canvas_node(self):
        return self._canvas_node()
    @property
    def canvas_terminal(self):
        return self._canvas_terminal()
    @property
    def shape(self):
        return [('line',((self.sx,self.sy),(self.sx,self.ey)),{'width':1}),
                ('line',((self.sx,self.ey),(self.ex,self.ey)),{'width':1})]
    def check_model(self,e):
        if self.canvas_terminal == None:
            self.canvas.removing_candidate.append(self)
            return
        sx,sy = self.canvas_node.loc
        ex,ey = self.canvas_terminal.loc
        if not (self.sx == sx and self.sy == sy and self.ex == ex and self.ey == ey):
            self.sx, self.sy, self.ex, self.ey = sx, sy, ex, ey
            self.erase()
            self.draw(self.shape)
    def __del__(self):
        # canvasウィンドウを削除すると
        # オブジェクト解放の順番で Tkinter.TclError が発生してしまうのに対処（多分tkcanvasが先に解放されてしまう）
        try:
            self.erase()
        except Tkinter.TclError:
            pass

class Canvas(Tkinter.Canvas,object):
    # コンテキストイベントの補足機構が必要かも
    # 最前列のオブジェクトイベントのみ確実に捕捉するようなもの
    # rmenu に例を示す
    # イベントハンドラ自体を拡張すべきかもね。いちどイベントを全部集積、選別して、遅延実行するような。
    class Menu(Tkinter.Menu):
        def __init__(self,master=None,obj=None,cnf={},**kw):
            Tkinter.Menu.__init__(self,master,cnf,**kw)
            self.add_command(label='place',command=obj.place)
            self.add_separator()
            self.add_command(label='popup all windows',command=obj.popup_all)
    def __init__(self,master=None,root=None,cnf={},**kw):
        Tkinter.Canvas.__init__(self,master,cnf,**kw)
        self._items = []
        self._buffer_location = weakref.WeakKeyDictionary()
        self._buffer_link = []
        self._location_menu = None
        if root:
            self.root = root
        else:
            self.root = self.chef.pylaf.Root()
        self.following_logics = weakref.WeakKeyDictionary()
        self.following_terminals = weakref.WeakKeyDictionary()
        self.following_nodes = weakref.WeakKeyDictionary()
        self.rmenu_queue = []
        self.canvas_event = Event()
        self.bind('<Button-2>',lambda e:self.rmenu_queue.append((self.Menu,self,e)))
        self.removing_candidate = []
        #
        self.loop()
        self.menu_loop()
    @property
    def chef(self):
        return get_chef(self)
    def clear(self):
        for logic in dict(self.following_logics):
            logic.destroy()
    def reload(self):
        netlist = self.chef.save_netlist()
        self.clear()
        self.chef.load_netlist(netlist)
    def destroy(self):
        for item in self._items:
            item.destroy()
        del self._items[:]
        Tkinter.Canvas.destroy(self)
    def loop(self):
        self.canvas_event.generate('<<CheckModel>>')
        self.populate_logics()
        for item in self.removing_candidate:
            item.destroy()
        del self.removing_candidate[:]
        self.after(500,self.loop)
    def populate_logics(self):
        for logic in self.root.children.itervalues():
            if logic not in self.following_logics:
                canvas_logic = CanvasLogic(self,logic)
                self.following_logics[logic] = weakref.ref(canvas_logic)
    def menu_loop(self):
        if self.rmenu_queue:
            menu, obj, e = self.rmenu_queue[0]
            self._location_menu = (e.x_root,e.y_root)
            w = menu(self,obj)
            w.tk_popup(e.x_root,e.y_root)
            w.destroy()
            del self.rmenu_queue[:]
        self.after(100,self.menu_loop)
    def place(self):
        cls = self.chef.pick_component()
        if not cls:
            return
        logic = cls(self.root)
        if isinstance(logic,self.chef.pylaf.AutoTrigger):
            logic.new_widget(self)
        self._buffer_location[logic] = self._location_menu
        self._location_menu = None
    def popup_all(self):
        for logic in self.following_logics.iterkeys():
            self.chef.pylaf.Equipment(Tkinter.Toplevel(self),logic.__class__,mount=False).mount(logic)
    def link(self):
        if len(self._buffer_link) == 2:
            attr1,attr2 = self._buffer_link
            node = attr1.node
            for o in attr2.node.get_observers():
                o.register(node)
            del self._buffer_link[:]
            
if __name__ == '__main__':
    import sys
    root = Tkinter.Tk()
    Chef(root,name='chef').pack(fill=Tkinter.BOTH,expand=True)
    root.children['chef'].children['mmanage'].working_dir = '/Volumes/Warehouse/Dropbox/workspace/SystemSimulation/src/'
    sys.path.append('/Users/bijoux/Dropbox/workspace/SystemSimulation/src/')
    Tkinter.mainloop()
    