# coding: utf-8
import Tkinter
import ttk
import weakref
import inspect
import re
import platform
from term import Terminal, Rule, event, connect, terminals, Cell
from tkext import Entry, Checkbutton, Button, Label, AutoTrigWidget, TrigLabel, EmptyLabel
from utils import override_default
from utils.tk import TableBuilder
from utils.singleton import Singleton
from utils.weakvaluelist import WeakValueList
from functools import partial

import types
import numpy
import tkFileDialog

pylafopt = {'equip':{},
            'defaults':{'plugin_option':{}}}

def equip(logic_klass,path,ignore_last=False):
    if ignore_last:
        path = path.split('.')[:-1]
    else:
        path = path.split('.')
    root = pylafopt['equip']
    if logic_klass in root:
        cursor = root[logic_klass]
    else:
        cursor = root[logic_klass] = {}
    for item in path:
        if item not in cursor:
            cursor[item] = {}
        cursor = cursor[item]
    return cursor

pylaf_equip = equip

def option(logic_klass,path,*args,**kw):
    dic = pylaf_equip(logic_klass,path,ignore_last=True)
    last = path.split('.')[-1]
    if args:
        if len(args) == 1:
            dic[last] = args[0]
        else:
            dic[last] = args
    else:
        dic[last] = kw

pylafopt_set = option

kw = lambda **kwargs: kwargs

class Root(object):
    __metaclass__ = Singleton
    def __init__(self):
        self.children = {}
    def destroy(self):
        for c in self.children.values(): c.destroy()
        
#class LogicMeta(type):
#    def __new__(cls,cls_name,bases,attrs):
#        klass = type.__new__(cls,cls_name,bases,attrs)
#        klass._make_terminals()
#        return klass

class Logic(object):
    class Meta(type):
        def __new__(cls,cls_name,bases,attrs):
            klass = type.__new__(cls,cls_name,bases,attrs)
            klass._make_terminals()
            return klass
    __metaclass__ = Meta
    @classmethod
    def _make_terminals(cls):
        # 複数の異なる初期値が与えられていた場合にはエラーを与える。
        # 同一の初期値か、初期値がただひとつだけにする
        defaults = {}
        for k,v in inspect.getmembers(cls,lambda x: isinstance(x,Rule)):
            if v.arguments:
                for name,default in zip(v.arguments[-len(v.defaults):],v.defaults):
                    if name not in defaults:
                        defaults[name] = default
                    elif not defaults[name] == default:
                        print 'double init_value error!',name,cls
        for k,v in inspect.getmembers(cls,lambda x: isinstance(x,Rule)):
            if v.arguments:
                for name in v.arguments:
                    if name not in cls.__dict__:
                        if name in defaults:
                            setattr(cls,name,Terminal(defaults[name]))
                        else:
                            setattr(cls,name,Terminal())
#                for name in v.arguments[:-len(v.defaults)]:
#                    if name not in cls.__dict__:
#                        setattr(cls,name,Terminal())
#                for name,default in zip(v.arguments[-len(v.defaults):],v.defaults):
#                    if name not in cls.__dict__:
#                        setattr(cls,name,Terminal(default))
    def __init__(self,master=None,name=None):
        self.children = {}
        if master == None:
            self.master = Root()
        else:
            self.master = master
        if name == None:
            self._name = repr(id(self))
        else:
            self._name = name
        if self._name in self.master.children: # master.childrenにおけるidの唯一性を保証する
            self.master.children[self._name].destroy()
        self.master.children[self._name] = self
        self.name = self._name
    def _remove_from_master(self): # master.childrenから自身へのオブジェクト参照を廃棄する
        if self._name in self.master.children:
            del self.master.children[self._name]
    def destroy(self):
        ''' Destroy this and all descendants nodes.'''
        for c in self.children.values(): c.destroy() # 子オブジェクトを巡回してdestroy()をコールする
        self._remove_from_master() # 親オブジェクトのchildren辞書から自身の参照を削除する
        # ^^^ 辞書の巡回中に辞書を変更しちゃって大丈夫？
        # self.children.clear() で一気に削除するほうが行儀いいのでは？
        # self.master.children.clear()

Parts = Logic

class Panel(Tkinter.Frame,object):
    COLUMN = 2
    CONNECTION = [] # logic: self
    def __init__(self,master=None,cnf={},**kw):
        Tkinter.Frame.__init__(self,master,cnf,**kw)
        self.layout()
    def layout(self):
        try: self.LAYOUT
        except AttributeError: return
        description = []
        for o in self.LAYOUT:
            if len(o) is not 2 and len(o) is not 3: continue # skip item (ERROR!)
            description.append((o[0],o[1],{'sticky':Tkinter.W+Tkinter.E}))
            if len(o) is 3:
                for k,v in o[2].iteritems():
                    description[-1][2][k] = v
        TableBuilder(self,column=self.COLUMN,description=description)
    def widget(self,name):
        #
        # 論理的に最も近い name のウィジェットを検索する
        #
        if name in self.children: return self.children[name]
        # ！！下層へのウィジェットの検索を追加したい
#        for key,value in self.children.iteritems():
#            self.children[key]
        return
    def connect(self,logic):
        #
        # コネクションリストを生成する
        #
        connection = []
        # Logic の各ターミナルと同一名称の論理的に最も近い子 Widget の value をリストに追加する
        terms = inspect.getmembers(logic.__class__,lambda x: isinstance(x,Terminal))
        tmp = {}
        for name,value in terms: tmp[name] = value
        terms = tmp
        for name,value in terms.iteritems():
            if self.widget(name) is None: continue
            connection.append(('#%s' % name,'%s#value' % name))
        # CONNECTION の記述内容を追加する
        # 標準記法
        # self.terminal_name > '~terminal_name'
        # logic.terminal_name > '#terminal_name'
        # self.children['name1'].children['name2'].terminal_name > 'name1.name2#terminal_name'
        # 短縮形
        # '#terminal_name' -> 'name'
        # 'widget#value' -> 'name'
        # 'widget1.widget2#value' -> 'name1.name2'
        for o in self.CONNECTION:
            c = []
            for id in o:
                if '#' in id or id.startswith('~'): # #term or widget#term or widget.widget#term or ~term
                    c.append(id)
                    continue
                path = ''
                if '.' in id: # widget.widget (パスの抽出)
                    for pathi in id.split('.')[:-1]: path = path + '%s.' % pathi
                    id = id.split('.')[-1]
                # widget#value or #term (contraction)
                if path == '' and id in terms: # #term
                    c.append('#%s' % id)
                else:
                    c.append('%s%s#value' % (path,id))
            if c: connection.append(tuple(c))
            
#        print logic.__class__, connection
        for record in connection:
            record = [self.id2tpl(field,logic) for field in record]
#            print record
            connect(record[0],*record[1:])
    def id2tpl(self,id,logic):
        if id.startswith('~'): return (self,id[1:])
        if id.startswith('#'): return (logic,id[1:])
        path, term_name = id.split('#') # ターミナル名を抽出
        # ウィジェットツリーを検索
        owner = self 
        for name in path.split('.'):
            if name in owner.children: owner = owner.children[name]
        if isinstance(owner,BaseEquipment): owner = owner.logic
        return (owner,term_name)
        
class Config(ttk.Notebook):
    def __init__(self,master=None,panel_klass=None,**kw):
        ttk.Notebook.__init__(self,master,**kw)
        self.subpanel = weakref.WeakValueDictionary()
        if panel_klass is None: return
        for key,klass in panel_klass.iteritems():
            self.subpanel[key] = klass(self)
            self.add(self.subpanel[key],text=key.capitalize())

class Layout(Tkinter.Frame):
    def __init__(self,master=None,panel_klass=None,panel_option=None,cnf={},**kw):
        Tkinter.Frame.__init__(self,master,cnf,**kw)
        self.panel = weakref.WeakValueDictionary()
        self.config_panel = weakref.WeakValueDictionary()
        self.config_panel_klass = {}
        if panel_klass is None: return
        #
        self.panel['config'] = self.config_panel
        for key,klass in panel_klass.iteritems():
            if key == 'config':
                #self.panel[key] = self.config_panel
                for mykey,myklass in inspect.getmembers(klass,inspect.isclass):
                    self.config_panel_klass[mykey.lower()] = myklass
                continue
            #
            # パネルを生成する
            #
            try:
                panel_option[klass]
            except KeyError:
                self.panel[key] = klass(self)
            else:
                self.panel[key] = klass(self,**panel_option[klass]) # オプションが指定されていれば適用する
        #
        # 小物ラックを生成する
        #
        if not 'rack' in self.panel: self.panel['rack'] = Panel(self)
        #
        # 各種パネルをグリッド配置する
        #
        self.layout(self.panel)
    def layout(self,panel):
        if 'toolbar' in panel:
            panel['toolbar'].grid(row=0,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
        if 'plot' in panel:
            panel['plot'].grid(row=1,column=0,rowspan=2,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
            self.grid_rowconfigure(1,weight=1)
        if 'control' in panel:
            panel['control'].grid(row=1,column=1,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
        if 'rack' in panel:
            panel['rack'].grid(row=2,column=1,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
        if 'status' in panel:
            panel['status'].grid(row=3,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
        self.grid_columnconfigure(0,weight=1)
    @property
    def rack(self):
        if 'rack' in self.panel:
            return self.panel['rack']
        else:
            return
    @property
    def control(self):
        if 'control' in self.panel:
            return self.panel['control']
        else:
            return
    @property
    def plot(self):
        if 'plot' in self.panel:
            return self.panel['plot']
        else:
            return
    def connect(self,logic):
        for name in ['plot','control','status','toolbar','rack']:
            if name in self.panel: self.panel[name].connect(logic)
    @property
    def logic(self): return self.master.logic
    def popup_config(self,master,**kw):
        if not self.config_panel_klass: return
        c = Config(master,self.config_panel_klass,**kw)
        c.pack(expand=True,fill=Tkinter.X)
        for key,value in c.subpanel.iteritems():
            self.panel['config'][key] = value
            value.connect(self.logic)
        return self.panel['config']
        
class LayoutV(Layout):
    def layout(self,panel):
        if 'toolbar' in panel:
            panel['toolbar'].grid(row=0,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
        if 'plot' in panel:
            panel['plot'].grid(row=1,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
            self.grid_rowconfigure(1,weight=1)
        if 'control' in panel:
            panel['control'].grid(row=2,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
        if 'rack' in panel:
            panel['rack'].grid(row=3,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
        if 'status' in panel:
            panel['status'].grid(row=4,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
        self.grid_columnconfigure(0,weight=1)

class PlotLayout(Layout):
    def __init__(self,master=None,panel_klass=None,cnf={},**kw):
        Layout.__init__(self,master,panel_klass,cnf,**kw)
        self.config_panel_klass['control'] = panel_klass['control']
    def connect(self,logic):
        for name in ['plot']:
            if name in self.panel: self.panel[name].connect(logic)
    def layout(self,panel):
        if 'plot' in panel:
            panel['plot'].grid(row=0,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
            self.grid_rowconfigure(1,weight=1)
        self.grid_columnconfigure(0,weight=1)
        
class ControlLayout(Layout):
    def connect(self,logic):
        for name in ['control']:
            if name in self.panel: self.panel[name].connect(logic)
    def layout(self,panel):
        if 'control' in panel:
            panel['control'].grid(row=0,column=0,sticky=Tkinter.E+Tkinter.W+Tkinter.N+Tkinter.S)
            self.grid_rowconfigure(1,weight=1)
        self.grid_columnconfigure(0,weight=1)

class BaseEquipment(object):
    def __init__(self,
                 logic_klass=None,
                 layout_klass=Layout,
                 auto_trig=False,
                 mount=True,
                 panel_klass={},
                 plugin={}):
        self.logic_klass = logic_klass
        self.panel_klass = {'control':ControlPanelFactory}
        self.panel_option = {}
        if not isinstance(plugin,dict): # もしpluginオプションにクラスがそのまま与えられた場合
            plugin = {plugin:{}}
        self.plugin_option = plugin
        #
        # panel_klassオプションの処理
        #
        # デフォルト処理
        #if logic_klass in pylafii_config['equipment_option']:
        #    o = pylafii_config['equipment_option'][logic_klass]['panel_klass'].copy()
        #    for k,v in panel_klass.iteritems(): o[k] = v
        #    panel_klass = o
        if logic_klass in pylafopt['equip']:
            if 'panel_klass' in pylafopt['equip'][logic_klass]:
                panel_klass = override_default(pylafopt['equip'][logic_klass]['panel_klass'],panel_klass)
            elif 'panel' in pylafopt['equip'][logic_klass]:
                panel_klass = override_default(pylafopt['equip'][logic_klass]['panel'],panel_klass)
        # クラスの抽出
        for name in ['control','plot','config','menu']:
            klass_name = '%s_klass' % name
            if klass_name in panel_klass:
                # キーワード引数にクラス名が含まれていればそれを対象クラスに割り当てる
                self.panel_klass[name] = panel_klass[klass_name]
                #del panel_klass[klass_name]
            else:
                # 含まれておらずかつロジックの属性にPlotなどがあればそれを使う logic.Plotなど
                # to be obsolete
                try:
                    getattr(logic_klass,name.capitalize())
                except AttributeError:
                    pass
                else:
                    self.panel_klass[name] = getattr(logic_klass,name.capitalize())
        # オプションの抽出と処理
#        for k,v in panel_klass.iteritems():
#            if isinstance(v,tuple):
#                klass, option = v
#                panel_klass[k] = klass
#                self.panel_option[klass] = option
        # 新しいオプションの抽出と処理
        for name in ['control','plot','config','menu']:
            option_name = '%s_option' % name
            if option_name in panel_klass:
                self.panel_option[self.panel_klass[name]] = panel_klass[option_name]
        #
        #
        #
#        self.extract('plot',logic_klass,**panel_klass)
#        self.extract('control',logic_klass,**panel_klass)
#        self.extract('config',logic_klass,**panel_klass)
#        self.extract('menu',logic_klass,**panel_klass)
        if 'menu' in self.panel_klass:
            self._menu = self.panel_klass['menu']
            try: del self.panel_option[self.panel_klass['menu']]
            except KeyError: pass
            del self.panel_klass['menu']
        else:
            self._menu = DefaultMenu
        if layout_klass:
            layout = layout_klass(self,self.panel_klass,self.panel_option)
            layout.pack(expand=True,fill=Tkinter.BOTH)
            self._layout = weakref.ref(layout)
        else:
            self._layout = None
        #
        # obsoleted
        #
        if auto_trig:
            Embed(self.layout.rack,AutoTrig,ControlLayout,name='autotrig').pack(fill=Tkinter.X,expand=True)
        #
        #
        #
        if mount:
            self.mount(logic_klass(self))
        else:
            self._logic = None
    def mount(self,logic):
        self._logic = weakref.ref(logic)
        self.layout.connect(logic)
        if 'autotrig' in self.layout.rack.children: connect((logic,'result'),(self.layout.rack.children['autotrig'].logic,'value'))
        if self.plugin_option:
            for klass,option in self.plugin_option.iteritems():
                if klass in pylafopt['defaults']['plugin_option']:
                    option = override_default(pylafopt['defaults']['plugin_option'][klass],option)
                self.plug(klass,**option)
        return self
    @property
    def layout(self):
        if self._layout:
            return self._layout()
        else:
            return
    def extract(self,name,logic_klass,**kw):
        klass_name = '%s_klass' % name
        if klass_name in kw:
            # キーワード引数にクラス名が含まれていればそれを対象クラスに割り当てる
            self.panel_klass[name] = kw[klass_name]
            del kw[klass_name]
        else:
            # 含まれておらずかつロジックの属性にPlotなどがあればそれを使う logic.Plotなど
            # to be obsolete
            try: getattr(logic_klass,name.capitalize())
            except AttributeError: pass
            else: self.panel_klass[name] = getattr(logic_klass,name.capitalize())
    def plug(self,logic_klass,option={},connect=None,layout_klass=ControlLayout):
        o = Embed(self.layout.rack,logic_klass,layout_klass,**option)
        o.pack(fill=Tkinter.X,expand=True)
        for l,r in connect:
            import term
            term.connect(self.terminal_id(l,self.logic), self.terminal_id(r,o.logic))
        return self
    def terminal_id(self,value,root):
        '''
        ターミナルIDを(owner,name)に変換する
        #plot,#control はパネルを示す
        '''
        id = value.split('.')
        name = id[-1]
        path = id[:-1]
        o = root
        for k in path:
            if k == '#plot':
                o = self.layout.plot
            else:
                o = o.children[k]
        return o, name
    @property
    def panel(self):
        return self.layout.panel
    @property
    def logic(self):
        if self._logic:
            return self._logic()
        else:
            return
        
class Equipment(Tkinter.Frame,BaseEquipment):
    def __init__(self,master=None,logic_klass=None,layout_klass=Layout,auto_trig=False,mount=True,panel_klass={},plugin={},cnf={},**kw):
        Tkinter.Frame.__init__(self,master,cnf,**kw)
        BaseEquipment.__init__(self,logic_klass,layout_klass,auto_trig,mount,panel_klass,plugin)
        self.master.config(menu=self._menu(master=self,name='menu'))
        self.pack(expand=True,fill=Tkinter.BOTH)
        
class Embed(Tkinter.LabelFrame,BaseEquipment):
    def __init__(self,master=None,logic_klass=None,layout_klass=PlotLayout,auto_trig=False,mount=True,panel_klass={},plugin={},cnf={},**kw):
        if 'text' not in kw:
            if 'name' in kw:
                kw['text'] = kw['name']
            else:
                if logic_klass:
                    kw['text'] = logic_klass.__name__
        Tkinter.LabelFrame.__init__(self,master,cnf,**kw)
        BaseEquipment.__init__(self,logic_klass,layout_klass,auto_trig,mount,panel_klass,plugin)
        #if logic_klass: self.config(text=logic_klass.__name__)
        #
        # ポップアップメニュー
        #
        self._menu(master=self,name='menu')
        # ポップアップイベントのバインド
        self.bind('<Control-Button-1>', self._rclicked) # Ctrl+右クリック
        if platform.system() == 'Darwin': # Darwinでは右クリックが異なる
            self.bind('<Button-2>', self._rclicked) # DarwinだったらB2
        else:
            self.bind('<Button-3>', self._rclicked) # Windows,LinuxだったらB3
    def _rclicked(self,e):
        self.children['menu'].tk_popup(e.x_root,e.y_root)
    def pack(self,*args,**kw):
        Tkinter.LabelFrame.pack(self,*args,**kw)
        return self
    def grid(self,*args,**kw):
        Tkinter.LabelFrame.grid(self,*args,**kw)
        return self

class EmptyPanel: pass

class ControlPanelFactory(Panel):
    GRID_OPTION={'sticky':Tkinter.W+Tkinter.E}
    #
    # !! ジオメトリマネージャは現在gridのみしか使えません！！
    #
    def __init__(self,
                 master=None,
                 ignore=[],
                 grid_option={},
                 sequence=(),
                 klass={},
                 klass_option={},
                 label={},
                 geometry_manager='grid',
                 geometry_default={'sticky':Tkinter.W+Tkinter.E},
                 geometry_option={},
                 cnf={},
                 **kw):
        Tkinter.Frame.__init__(self,master,cnf,**kw)
        #
        # ターミナルの抽出
        #
        equipment = self.get_equipment(master)
        if sequence:
            members = {}
            for k,v in inspect.getmembers(equipment.logic_klass,lambda x:isinstance(x,Terminal)):
                members[k] = v
            sequence = [(k,members[k]) for k in sequence]
        else:
            sequence = self.get_terminals(equipment,ignore)
            sequence = self.extract_sequence(equipment,sequence)
        #
        # クラスの抽出
        #
        for k,v in sequence:
            if k not in klass:
                # boolean のときはトリガボタンだけ？
                # ndarray のときは行列ウィジェット？
                if (v.init_value is None or # 初期値がNoneかインスタンスか行列で、かつルールでもなければなにもしない
                    type(v.init_value) == types.InstanceType or
                    type(v.init_value) == numpy.ndarray):
                    if isinstance(v,Rule): # ルールであれば、トリガボタンを生成する
                        klass[k] = EmptyLabel
                else:
                    klass[k] = Entry
        #
        # クラスが未定義なターミナルをシーケンスから取り除く
        #
        tmp = list(sequence)
        for k,v in sequence:
            if k not in klass:
                tmp.remove((k,v))
        sequence = tmp
        #
        # ラベルの抽出
        #
        label = override_default(self.extract_labels(equipment,sequence),label)
        #
        # ジオメトリオプションの抽出
        #
        for k,v in sequence:
            if k not in geometry_option:
                geometry_option[k] = geometry_default
        #
        self.layout(sequence,klass,label,geometry_option)
    def get_equipment(self,master):
        #
        # 直近の BaseEquipment 一族を取得する
        #
        while not isinstance(master,BaseEquipment): master = master.master
        return master
    def get_terminals(self,equipment,ignore):
        #
        # Logic のクラスメンバのうち Terminal のインスタンスとラベルをソースに記述された順番に抽出する
        #
        terminals = []
        # Logic の Terminal 型のメンバリストを作成する
        for k,v in inspect.getmembers(equipment.logic_klass,lambda x: isinstance(x,Terminal)):
            if k in ignore: continue
            terminals.append((k,v))
        return terminals
    def layout(self,sequence,klass,label,geometry_option):
        equipment = self.get_equipment(self.master)
        o = TableBuilder(self)
        for k,v in sequence:
            o.add(TrigLabel,**{'text':label[k]}).grid(**geometry_option[k])
            item = o._item()
            o.add(klass[k],**{'name':k}).grid(**geometry_option[k])
            connect((self.children[k],'value'),(item,'value'))
    def extract_sequence(self,equipment,members):
        # ソースからターミナルの順番を抽出する
        # 抽出できなかったターミナルは後半に固める
        # コメントを削除する
        code = inspect.getsource(equipment.logic_klass)
        comment = re.compile('#.*\n')
        for s in comment.findall(code):
            code = code.replace(s,'\n')
        #
        sequence = []
        for line in code.splitlines():
            line = line.strip()
            for k,v in members:
                if isinstance(v,Rule):
                    name = line[4:].split('(')[0]
                else:
                    name = line.split('=')[0].strip()
                if name == k:
                    sequence.append((k,v))
        for k,v in members[::-1]:
            if (k,v) not in sequence:
                sequence.insert(0,(k,v))
        return sequence
    def extract_labels(self,equipment,members):
        labels = {}
        source = inspect.getsource(equipment.logic_klass).splitlines()
        for line in source: # ソースの各行において
            line = line.strip() # 改行や行頭の空白を削除し
            for k,v in members: # すべての Terminal 型メンバについて
                if isinstance(v,Rule): # ルールであればマッチングカーソルを4に設定(def XXXX)
                    idx = 4
                else:
                    idx = 0
                if line.find(k) is idx: # もしメンバ k の定義行であって
                    if line.find('#') is not -1: # コメント欄が
                        label = line.split('#')[-1].strip() # 含まれていれば、コメント以下のテキストをラベルにする
                    else:
                        label = k # 含まれていなければ、メンバ名をラベルにする
                    labels[k] = label
        for k,v in members: # ソースから抽出できなかったメンバのラベルを設定する
            if k not in labels:
                labels[k] = k
        return labels
        
class Menu(Tkinter.Menu):
    TYPE_CASCADE, TYPE_ITEM = range(2)
    ITEMS = []
    def __init__(self,master=None,cnf={},**kw):
        Tkinter.Menu.__init__(self,master,cnf,**kw)
        self.make()
    def make(self,items=None):
        if items is None: items = self.__class__.ITEMS
        for child in items:
            self.add_child(self,child)
    def connect(self,logic): pass
#        for child in 
    def add_child(self,parent,child):
        def nocommand(command=None,**kw): return kw
        cls = self.__class__
        itemtype = self.itemtype(child) # child がどのような要素か調べる
        if itemtype == cls.TYPE_CASCADE: # child が カスケード であるならば
            label, item = self.parse_cascade(child) # label と item を抽出して
            index = self.labeltoindex(label)
            if index is None: # label が 不在 ならば
                if not repr(type(item)) == '<type \'classobj\'>':
                    cascade = Menu(parent,name=label.lower()) # あたらしいカスケード要素を生成して
                    parent.add_cascade(label=label,menu=cascade)
                    parent = cascade # 生成したカスケードを parent とする
            else:
                old = self.item(label)
                if old is None: # old が カスケード でなければ
                    self.delete(index) # 元の要素を削除して
                    if not repr(type(item)) == '<type \'classobj\'>':
                        cascade = Menu(parent,name=label.lower()) # 新しいカスケード要素で上書き
                        parent.add_cascade(label=label,menu=cascade)
                        parent = cascade
                    else:
                        pass
                else:
                    parent = old
            if   item == None:
                pass
            elif repr(type(item)) == '<type \'classobj\'>':
                parent.add_cascade(label=label,menu=item(parent,name=label.lower()))
            elif type(item) == list:
                for o in item:
                    self.add_child(parent,o)
        elif itemtype == cls.TYPE_ITEM:
            name, kwargs = child
            if kwargs.has_key('command'): # もしコマンドが定義されていて
                if type(kwargs['command']) == str: # オペランドがメソッド名ならば
                    command = getattr(self,kwargs['command']) # 自身のメソッドをコマンドに割り当てる
                    getattr(parent,name)(command=command,**nocommand(**kwargs))
                    return
            getattr(parent,name)(**kwargs)
    def itemtype(self,item):
        cls = self.__class__
        if len(item) == 1: return cls.TYPE_CASCADE
        if type(item[1]) == list: return cls.TYPE_CASCADE
        if repr(type(item[1])) == '<type \'classobj\'>': return cls.TYPE_CASCADE
        if type(item[1]) == dict: return cls.TYPE_ITEM
    def parse_cascade(self,item):
        if len(item) == 1: return item[0], None
        if type(item[1]) == list: return item[0], item[1:]
        if repr(type(item[1])) == '<type \'classobj\'>': return item[0], item[1]
    def labeltoindex(self,label):
        index = 0
        while index == self.index(index):
            try: self.entrycget(index,'label')
            except: pass
            else:
                if label == self.entrycget(index,'label'):
                    return index
            index = index + 1
        return
    def item(self,label):
        index = self.labeltoindex(label)
        if not index: return
        return self.nametowidget(self.entrycget(index,'menu'))
    def remove_empty_items(self,cascade):
        length = cascade.len
        for index in range(length):
            if cascade.type(index) == 'cascade':
                label = cascade.entrycget(index,'label')
                menu  = cascade.nametowidget(cascade.entrycget(index,'menu'))
                self.remove_empty_items(menu)
#                if isinstance(menu,ChildrenMenu): continue
#                if menu.len == 0:
#                    cascade.delete(index)
    @property
    def len(self):
        index = 0
        while index == self.index(index):
            index = index + 1
        return index

class ChildrenMenu(Menu):
    def __init__(self,master=None,cnf={},**kw):
        Menu.__init__(self,master,cnf,**kw)
        self.update_children()
#        self.add_separator()
#        self.make([
#                   ['add_command', {'label':'Config'}],
#                   ])
    @property
    def equip(self):
        equip = self
        while not isinstance(equip,BaseEquipment): equip = equip.master
        return equip
#    def assign(self,component):
#        Menu.assign(self,component)
#        self.update_children()
#    def update_children(self):
#        try: self.comp # もしコンポーネントが割り付けられていなければなにもしない
#        except AttributeError: return
#        component = self.component()
#        if component == None: # もしコンポーネントが廃棄されていれば割り付けを解除する
#            del self.comp
#            return
#        # Component 以外が与えられた場合の処理
#        try: component.children
#        except AttributeError: return
#        #
#        children = component.children.copy()
#        # メニューに存在する子Ｃが実在するかチェックしてメニューを削除する
#        existence = ['%s:%s' % (key,children[key].__class__.__classname__) for key in children]
#        remove = []
#        for index in range(self.len()):
#            try:
#                label = self.entrycget(index,'label')
#            except: continue
#            flag = False
#            for s in existence:
#                if s == label:
#                    flag = True
#                    break
#            if not flag:
#                remove.append(index)
#        for index in remove:
#            self.delete(index)
#        # ツリーに存在する子Ｃがメニューアイテムに存在するかチェックしてメニューアイテムを追加する
#        for s in existence:
#            flag = False
#            for index in range(self.len()):
#                try:
#                    label = self.entrycget(index,'label')
#                except: continue
#                if s == label:
#                    flag = True
#                    break
#            if flag: continue
#            self.add_command(label=s,command=partial(self.popup,label=s))
#        self.after(500,self.update_children)
    def update_children(self):
        if self.equip.logic is None:
            self.after(500,self.update_children)
            return
        children = self.equip.logic.children
        existence = ['%s:%s' % (key,children[key].__class__.__name__) for key in children]
        # メニューに存在する子Ｃが実在するかチェックしてメニューを削除する
        remove = []
        for index in range(self.len):
            try:
                label = self.entrycget(index,'label')
            except:
                continue
            flag = False
            for s in existence:
                if s == label:
                    flag = True
                    break
            if not flag:
                remove.append(index)
        for index in remove:
            self.delete(index)
        # ツリーに存在する子Ｃがメニューアイテムに存在するかチェックしてメニューアイテムを追加する
        for s in existence:
            flag = False
            for index in range(self.len):
                try:
                    label = self.entrycget(index,'label')
                except:
                    continue
                if s == label:
                    flag = True
                    break
            if flag:
                continue
            self.add_command(label=s,command=partial(self.popup,label=s))
        self.after(500,self.update_children)
    def popup(self,label):
        key = label.split(':')[0]
        object = self.equip.logic.children[key]
        Equipment(Tkinter.Toplevel(self.equip),object.__class__,mount=False).mount(object)

class FileMenu(Menu):
    ITEMS = []
    RESTS = [
             ['add_command', kw(label='Config',command='popup_config')],
             ]
    def make_rest(self):
        if not self.len == 0: self.add_separator()
        self.make(self.__class__.RESTS)
    def popup_config(self):
        if 'config' in self.children: return
        equip = self
        while not isinstance(equip,BaseEquipment): equip = equip.master
        toplevel = Tkinter.Toplevel(self,name='config')
        panels = equip.layout.popup_config(toplevel)
        if panels == None:
            toplevel.destroy()
            return
        
class DefaultMenu(Menu):
    DEFAULT_ITEMS = [
                     ['File', FileMenu],
                     ['Children', ChildrenMenu],
                     ]
    ITEMS = []
    def __init__(self,master=None,cnf={},**kw):
        cls = self.__class__
        Menu.__init__(self,master,cnf,**kw)
        self.make(cls.DEFAULT_ITEMS)
        self.make(cls.ITEMS)
        self.make_rest(self.children)
        self.remove_empty_items(self)
    def make_rest(self,children): # メニューの末尾にアイテムを追加する
        for key in children:
            child = children[key]
            if isinstance(child,Menu):
                try: make_rest = getattr(child,'make_rest')
                except AttributeError: continue
                make_rest()
                self.make_rest(child.children)

class AutoTrig(Logic):
    value = Terminal()
    interval = Terminal()
    switch = Terminal()
    class Control(Panel):
        COLUMN = 1
        LAYOUT = [(AutoTrigWidget,{'name':'value'}),(Label,{'name':'indicator'}),]
        CONNECTION = [('interval','~interval'),('value#switch','switch','~switch'),('value#interval','interval')]
        @event()
        def interval(self): self._update_indicator()
        @event()
        def switch(self): self._update_indicator()
        def _update_indicator(self):
            if self.switch:
                self.children['indicator'].config(text='%d ms' % self.children['value'].interval)
            else:
                self.children['indicator'].config(text='OFF')
        def layout(self):
            Panel.layout(self)
            self.children['value'].switch = True
    class Config:
        class Config(Panel):
            LAYOUT = [(Checkbutton,{'name':'switch','text':'interval'}),(Entry,{'name':'interval'}),]
            
class MatrixLabel(Tkinter.Label,object):
    @event(numpy.array([]))
    def value(self): self._forward()
    def __init__(self,master=None,skip=4,strip=True,split='\t',column=[2,3],cnf={},**kw):
        Tkinter.Label.__init__(self,master,cnf,**kw)
        self.skip = skip
        self.strip = strip
        self.split = split
        self.column = column
        #
        # ポップアップメニュー
        #
        MatrixLabelPopupMenu(master=self,name='menu')
        #DefaultMenu(master=self,name='menu')
        # ポップアップイベントのバインド
        self.bind('<Control-Button-1>', self._rclicked) # Ctrl+右クリック
        if platform.system() == 'Darwin': # Darwinでは右クリックが異なる
            self.bind('<Button-2>', self._rclicked) # DarwinだったらB2
        else:
            self.bind('<Button-3>', self._rclicked) # Windows,LinuxだったらB3
        connect((self,'value'),(self.children['menu'],'value'))
    def _rclicked(self,e):
        self.children['menu'].tk_popup(e.x_root,e.y_root)
    def _forward(self):
        self.configure(text='Matrix%s' % str(self.value.shape))
        
class MatrixLabelPopupMenu(Menu,object):
    value = Terminal(numpy.array([]))
    def __init__(self,master=None,cnf={},**kw):
        Menu.__init__(self,master,cnf,**kw)
        items = [['add_command',{'label':'Import','command':self._import}],
                 ['add_command',{'label':'Export','command':self._export}],
                 ['add_command',{'label':'show','command':self._show}],]
        self.make(items)
    def _show(self):
        print self.value
    def _export(self):
        #ang, pow, at, pt = self.master.logic.farfield
        #data = numpy.zeros((len(ang),2))
        #data[:,0] = ang
        #data[:,1] = pow
        #if data == []: return
        fobj = tkFileDialog.asksaveasfile()
        if fobj == None: return
        #comment = self.component().comment.get()
        #for line in comment.split('\n'):
        #    if not line == '': file.write('#%s\n' % line)
        data_string = ''
        for r in self.value:
            for c in r:
                data_string = data_string + '%16.14f\t' % float(c)
            data_string = data_string[:-1] + '\n'
        fobj.write('%s\n' % data_string)
        #for a,p in data.astype('float64'):
        #    file.write('%16.14f\t%16.14f\n' % (a,p))
        fobj.close()
    def _import(self):
        file = tkFileDialog.askopenfile()
        if file == None: return
        ext = re.compile('\.[a-zA-Z0-9]*$')
        self.filename = ext.sub('',file.name)
        lines = [line for line in file.readlines()]
        file.close()
        buff = []
        for line in lines[self.master.skip:]:
            line = line.replace('"','')
            line = line.replace('\'','')
            line = line.strip()
            a,b = line.split(self.master.split)[2:4]
            try: a,b = float(a), float(b)
            except ValueError: continue
            buff.append([a, b])
        self.value = numpy.array(buff)
        # skip = 4
        # strip = True
        # split = '\t'
        # column = [2,3]
        

class AutoPlotTrig(AutoTrig): pass

class TkAutoTrig(Tkinter.Frame,object):
    interval = Cell()
    trig = Cell()
    @event(True)
    def switch(self):
        if self.switch and self.id is None: self._polling()
    def __init__(self,master=None,logic=None,cnf=[],**kw):
        Tkinter.Frame.__init__(self,master,cnf,**kw)
        self._logic = weakref.ref(logic)
        self.id = None
    @property
    def logic(self):
        return self._logic()
    def _polling(self):
        # 生存確認
        if self.logic is None:
            if self.id:
                self.after_cancel(self.id)
            self.destroy()
            return
        #
        if self.switch:
            self.trig
            self.id = self.after(self.interval,self._polling)
        else:
            if self.id: # self.id is not None
                self.after_cancel(self.id)
                self.id = None

class AutoTrigger(Logic):
    trig = Cell()
    interval = Cell(100)
    switch = Cell(True)
    def new_widget(self,root):
        w = TkAutoTrig(root,self)
        for tname in ['trig','interval','switch']:
            connect((self,tname),(w,tname))
    class Control(Panel):
        LAYOUT = [(Checkbutton,{'name':'switch','text':'interval'}),(Entry,{'name':'interval'}),]

class PlotTrigButton(Logic):
    value = Terminal()
    class Control(Panel):
        COLUMN=1
        LAYOUT=[(Button,{'name':'value','text':'Plot'})]

class Arrange(Logic):
    def __init__(self,master=None,name=None):
        Logic.__init__(self,master,name)
        self.geometry = 'grid'
        self.items = WeakValueList()
        self.geometry_options = weakref.WeakKeyDictionary()
        self.layout = weakref.WeakKeyDictionary()
    def add_item(self,logic,option={},layout=Layout):
        self.items.append(logic)
        self.geometry_options[logic] = option
        self.layout[logic] = layout

def create_window(master,logic):
    if isinstance(logic,Arrange):
        arrange = logic
    else:
        for key,logic in logic.children.iteritems():
            if isinstance(logic,Arrange):
                arrange = logic
                break
        else:
            return
    frame = ttk.Frame(master)
    if arrange.geometry == 'grid':
        for item in arrange.items:
            logic = item()
            option = arrange.geometry_options[logic]
            layout = arrange.layout[logic]
            Embed(frame,logic.__class__,layout_klass=layout,mount=False).mount(logic).grid(option)
    elif arrange.geometry == 'pack':
        for logic in arrange.items:
            Embed(frame,logic.__class__,layout_klass=layout,mount=False).mount(logic).pack(option)
    frame.pack(fill=Tkinter.BOTH,expand=True)
    
pylafopt['defaults']['plugin_option'] = {AutoTrig:{'connect':(('result','value'),)},
                                         AutoPlotTrig:{'connect':(('#plot.trig','value'),)},
                                         PlotTrigButton:{'connect':(('#plot.trig','value'),)}}
